/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConfigRecordDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerStateDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBTool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DestinationDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.JDBCStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.PropertyDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.TransactionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.XidImpl;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class UpgradeStore
implements DBConstants {
    private BrokerResources br = Globals.getBrokerResources();
    private Logger logger = Globals.getLogger();
    private JDBCStore store;
    private DBManager dbMgr;
    private String brokerID;
    private int oldStoreVersion;
    private String oldVersionTable;
    private String oldPropTable;
    private String oldConfigRecordTable;
    private String oldDestTable;
    private String oldMsgTable;
    private String oldStateTable;
    private String oldInterestTable;
    private String oldTxnTable;
    private String oldAckTable;
    private boolean useBlob;

    UpgradeStore(JDBCStore jDBCStore, int n) throws BrokerException {
        this.store = jDBCStore;
        this.dbMgr = DBManager.getDBManager();
        this.brokerID = this.dbMgr.getBrokerID();
        this.oldStoreVersion = n;
        if (this.oldStoreVersion == 370) {
            this.useBlob = true;
            this.oldVersionTable = "IMQSV37" + this.brokerID;
            this.oldPropTable = "IMQPROPS37" + this.brokerID;
            this.oldConfigRecordTable = "IMQCCREC37" + this.brokerID;
            this.oldDestTable = "IMQDEST37" + this.brokerID;
            this.oldMsgTable = "IMQMSG37" + this.brokerID;
            this.oldStateTable = "IMQILIST37" + this.brokerID;
            this.oldInterestTable = "IMQINT37" + this.brokerID;
            this.oldTxnTable = "IMQTXN37" + this.brokerID;
            this.oldAckTable = "IMQTACK37" + this.brokerID;
        } else {
            this.useBlob = false;
            this.oldVersionTable = "IMQSV35" + this.brokerID;
            this.oldPropTable = "IMQPROPS35" + this.brokerID;
            this.oldConfigRecordTable = "IMQCCREC35" + this.brokerID;
            this.oldDestTable = "IMQDEST35" + this.brokerID;
            this.oldMsgTable = "IMQMSG35" + this.brokerID;
            this.oldStateTable = "IMQILIST35" + this.brokerID;
            this.oldInterestTable = "IMQINT35" + this.brokerID;
            this.oldTxnTable = "IMQTXN35" + this.brokerID;
            this.oldAckTable = "IMQTACK35" + this.brokerID;
        }
    }

    void upgradeStore(Connection connection) throws BrokerException {
        Object[] objectArray = new Object[]{new Integer(400)};
        this.logger.logToAll(8, "B1115", objectArray);
        if (this.store.resetMessage()) {
            this.logger.logToAll(8, "B1101");
            this.logger.logToAll(8, "B1102");
        } else if (this.store.resetInterest()) {
            this.logger.logToAll(8, "B1103");
            this.logger.logToAll(8, "B1102");
        }
        try {
            DBTool.createTables(connection);
        }
        catch (Throwable throwable) {
            String string = this.dbMgr.getCreateDBURL();
            if (string == null || string.length() == 0) {
                string = this.dbMgr.getOpenDBURL();
            }
            String string2 = this.br.getKString("B3073", string);
            this.logger.logToAll(32, string2, throwable);
            throw new BrokerException(string2, throwable);
        }
        try {
            connection.setAutoCommit(false);
            this.upgradeProperties(connection);
            this.upgradeChangeRecords(connection);
            this.upgradeDestinations(connection);
            this.upgradeMessages(connection);
            this.upgradeInterests(connection);
            this.upgradeTxns(connection);
            this.upgradeTxnAcks(connection);
            this.logger.logToAll(8, "B1106");
            if (this.store.upgradeNoBackup()) {
                this.dropTable(connection, this.oldVersionTable);
            } else {
                this.logger.logToAll(8, "B1121");
            }
        }
        catch (Exception exception) {
            this.logger.logToAll(32, "B1116");
            try {
                DBTool.dropTables(connection, this.dbMgr.getTableNames(400));
            }
            catch (SQLException sQLException) {
                this.logger.logStack(32, "B4117", "Failed to clean up new tables after upgrade failed", (Throwable)sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            new BrokerException(this.br.getKString("B3207"), exception);
        }
    }

    private void upgradeDestinations(Connection connection) throws BrokerException {
        DestinationDAO destinationDAO = this.dbMgr.getDAOFactory().getDestinationDAO();
        String string = "SELECT DEST FROM " + this.oldDestTable;
        String string2 = new StringBuffer(128).append("INSERT INTO ").append(destinationDAO.getTableName()).append(" ( ").append("ID").append(", ").append("DESTINATION").append(", ").append("IS_LOCAL").append(", ").append("CONNECTION_ID").append(", ").append("CONNECTED_TS").append(", ").append("BROKER_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?, ? )").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates();
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Destination destination = null;
        try {
            preparedStatement = connection.prepareStatement(string2);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                Object object;
                Object object2 = Util.readObject(resultSet, 1);
                destination = (Destination)object2;
                String string3 = destination.getUniqueName();
                int n = destination.getIsLocal() ? 1 : 0;
                long l = System.currentTimeMillis();
                long l2 = -1L;
                long l3 = -1L;
                String string4 = null;
                if (n > 0) {
                    object = destination.getConnectionUID();
                    if (object != null) {
                        l3 = l;
                        l2 = ((UID)object).longValue();
                    }
                    string4 = this.brokerID;
                }
                try {
                    preparedStatement.setString(1, string3);
                    object = Util.setObject(preparedStatement, 2, destination);
                    ((ByteArrayInputStream)object).close();
                    preparedStatement.setInt(3, n);
                    Util.setLong(preparedStatement, 4, l2);
                    Util.setLong(preparedStatement, 5, l3);
                    Util.setString(preparedStatement, 6, string4);
                    preparedStatement.setLong(7, l);
                    if (bl) {
                        preparedStatement.addBatch();
                        continue;
                    }
                    preparedStatement.executeUpdate();
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + string2 + "]", iOException);
                    throw iOException2;
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
                    throw sQLException2;
                }
            }
            if (bl) {
                preparedStatement.executeBatch();
            }
            connection.commit();
            if (this.store.upgradeNoBackup()) {
                this.dropTable(connection, this.oldDestTable);
            }
        }
        catch (Exception exception) {
            try {
                String string5 = this.br.getKString("B4162", destination == null ? "loading" : destination.getUniqueName());
                this.logger.logStack(32, string5, exception);
                throw new BrokerException(string5, exception);
            }
            catch (Throwable throwable) {
                Util.close(resultSet, statement, null);
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }

    private void upgradeMessages(Connection connection) throws BrokerException {
        String string = null;
        int n = 0;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            string = "SELECT COUNT(*) FROM " + this.oldMsgTable;
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            try {
                this.logger.log(32, "B4166", (Object)string, (Throwable)sQLException);
                throw new BrokerException(this.br.getString("B4166", string), sQLException);
            }
            catch (Throwable throwable) {
                Util.close(resultSet, statement, null);
                throw throwable;
            }
        }
        Util.close(resultSet, statement, null);
        if (Store.DEBUG) {
            this.logger.log(4, "number of messages in old table = " + n);
        }
        boolean bl = this.store.upgradeNoBackup();
        if (n == 0) {
            if (bl) {
                this.dropTable(connection, this.oldMsgTable);
                this.dropTable(connection, this.oldStateTable);
            }
        } else if (this.store.resetMessage()) {
            if (bl) {
                this.dropTable(connection, this.oldMsgTable);
                this.dropTable(connection, this.oldStateTable);
            } else {
                this.clearTable(connection, this.oldMsgTable);
                this.clearTable(connection, this.oldStateTable);
            }
        } else {
            this.logger.logToAll(8, this.br.getString("B1118", String.valueOf(n)));
            this.doUpgradeMsg(connection);
            if (bl) {
                this.dropTable(connection, this.oldMsgTable);
                this.dropTable(connection, this.oldStateTable);
            }
        }
    }

    private void doUpgradeMsg(Connection connection) throws BrokerException {
        String string;
        String string2;
        Object object;
        MessageDAO messageDAO = this.dbMgr.getDAOFactory().getMessageDAO();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = "SELECT MSG FROM " + this.oldMsgTable;
        Statement statement = null;
        ResultSet resultSet = null;
        Packet packet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                packet = new Packet(false);
                packet.generateTimestamp(false);
                packet.generateSequenceNumber(false);
                object = this.useBlob ? resultSet.getBlob(1).getBinaryStream() : resultSet.getBinaryStream(1);
                packet.readPacket((InputStream)object);
                ((InputStream)object).close();
                messageDAO.insert(connection, packet, null, null, null, System.currentTimeMillis(), false);
                string2 = packet.getSysMessageID().getUniqueName();
                string = DestinationUID.getUniqueString(packet.getDestination(), packet.getIsQueue());
                hashMap.put(string2, string);
            }
        }
        catch (Exception exception) {
            try {
                String string4 = this.br.getKString("B4163", packet == null ? "loading" : packet.getSysMessageID().getUniqueName());
                this.logger.logStack(32, string4, exception);
                throw new BrokerException(string4, exception);
            }
            catch (Throwable throwable) {
                Util.close(resultSet, statement, null);
                throw throwable;
            }
        }
        Util.close(resultSet, statement, null);
        object = this.dbMgr.getDAOFactory().getConsumerStateDAO();
        string2 = "SELECT MID, CUID, STATE FROM " + this.oldStateTable + " WHERE " + "STATE" + "<>" + 2;
        string = new StringBuffer(128).append("INSERT INTO ").append(object.getTableName()).append(" ( ").append("MESSAGE_ID").append(", ").append("CONSUMER_ID").append(", ").append("STATE").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ? )").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates();
        PreparedStatement preparedStatement = null;
        String string5 = null;
        long l = 0L;
        try {
            preparedStatement = connection.prepareStatement(string);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                string5 = resultSet.getString(1);
                l = resultSet.getLong(2);
                int n = resultSet.getInt(3);
                String string6 = (String)hashMap.get(string5);
                if (string6 == null) continue;
                try {
                    preparedStatement.setString(1, string5);
                    preparedStatement.setLong(2, l);
                    preparedStatement.setInt(3, n);
                    preparedStatement.setLong(4, System.currentTimeMillis());
                    if (bl) {
                        preparedStatement.addBatch();
                        continue;
                    }
                    preparedStatement.executeUpdate();
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + string + "]", sQLException);
                    throw sQLException2;
                }
            }
            hashMap.clear();
            if (bl) {
                preparedStatement.executeBatch();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            String string7 = this.br.getKString("B4163", string5 == null ? "loading" : string5);
            this.logger.logStack(32, string7, sQLException);
            throw new BrokerException(string7, sQLException);
        }
        finally {
            Util.close(resultSet, statement, null);
            Util.close(null, preparedStatement, null);
        }
    }

    private void upgradeInterests(Connection connection) throws BrokerException {
        String string = "SELECT COUNT(*) FROM " + this.oldInterestTable;
        int n = 0;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            try {
                this.logger.log(32, "B4166", (Object)string, (Throwable)sQLException);
                throw new BrokerException(this.br.getString("B4166", string), sQLException);
            }
            catch (Throwable throwable) {
                Util.close(resultSet, statement, null);
                throw throwable;
            }
        }
        Util.close(resultSet, statement, null);
        if (Store.DEBUG) {
            this.logger.log(4, "number of interests in old table = " + n);
        }
        boolean bl = this.store.upgradeNoBackup();
        if (n == 0) {
            if (bl) {
                this.dropTable(connection, this.oldInterestTable);
            }
        } else if (this.store.resetInterest()) {
            if (bl) {
                this.dropTable(connection, this.oldInterestTable);
            } else {
                this.clearTable(connection, this.oldInterestTable);
            }
        } else {
            this.doUpgradeInterests(this.store, connection);
        }
    }

    private void doUpgradeInterests(JDBCStore jDBCStore, Connection connection) throws BrokerException {
        ConsumerDAO consumerDAO = this.dbMgr.getDAOFactory().getConsumerDAO();
        String string = "SELECT INTEREST FROM " + this.oldInterestTable;
        String string2 = new StringBuffer(128).append("INSERT INTO ").append(consumerDAO.getTableName()).append(" ( ").append("ID").append(", ").append("CONSUMER").append(", ").append("DURABLE_NAME").append(", ").append("CLIENT_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ? )").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates();
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Consumer consumer = null;
        try {
            preparedStatement = connection.prepareStatement(string2);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                Object object;
                consumer = (Consumer)Util.readObject(resultSet, 1);
                String string3 = null;
                String string4 = null;
                if (consumer instanceof Subscription) {
                    object = (Subscription)consumer;
                    string3 = ((Subscription)object).getDurableName();
                    string4 = ((Subscription)object).getClientID();
                }
                try {
                    preparedStatement.setLong(1, consumer.getConsumerUID().longValue());
                    object = Util.setObject(preparedStatement, 2, consumer);
                    Util.setString(preparedStatement, 3, string3);
                    Util.setString(preparedStatement, 4, string4);
                    preparedStatement.setLong(5, System.currentTimeMillis());
                    ((ByteArrayInputStream)object).close();
                    if (bl) {
                        preparedStatement.addBatch();
                        continue;
                    }
                    preparedStatement.executeUpdate();
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + string2 + "]", iOException);
                    throw iOException2;
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
                    throw sQLException2;
                }
            }
            if (bl) {
                preparedStatement.executeBatch();
            }
            connection.commit();
            if (jDBCStore.upgradeNoBackup()) {
                this.dropTable(connection, this.oldInterestTable);
            }
        }
        catch (Exception exception) {
            try {
                String string5 = this.br.getKString("B4168", consumer == null ? "loading" : consumer.toString());
                this.logger.logStack(32, string5, exception);
                throw new BrokerException(string5, exception);
            }
            catch (Throwable throwable) {
                Util.close(resultSet, statement, null);
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }

    private void upgradeTxns(Connection connection) throws BrokerException {
        TransactionDAO transactionDAO = this.dbMgr.getDAOFactory().getTransactionDAO();
        String string = "SELECT TUID,STATE,TSTATEOBJ FROM " + this.oldTxnTable + " WHERE " + "STATE" + " <> " + -1;
        String string2 = new StringBuffer(128).append("INSERT INTO ").append(transactionDAO.getTableName()).append(" ( ").append("ID").append(", ").append("STATE").append(", ").append("TXN_STATE").append(", ").append("AUTO_ROLLBACK").append(", ").append("XID").append(", ").append("BROKER_ID").append(", ").append("EXPIRED_TS").append(", ").append("ACCESSED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?, ?, ? )").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates();
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        TransactionUID transactionUID = null;
        try {
            preparedStatement = connection.prepareStatement(string2);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                Serializable serializable;
                long l = resultSet.getLong(1);
                transactionUID = new TransactionUID(l);
                int n = resultSet.getInt(2);
                TransactionState transactionState = (TransactionState)Util.readObject(resultSet, 3);
                transactionState.setState(n);
                try {
                    preparedStatement.setLong(1, l);
                    preparedStatement.setInt(2, n);
                    ByteArrayInputStream byteArrayInputStream = Util.setObject(preparedStatement, 3, transactionState);
                    preparedStatement.setInt(4, transactionState.getType().intValue());
                    serializable = transactionState.getXid();
                    if (serializable != null) {
                        preparedStatement.setString(5, ((XidImpl)serializable).toString());
                    } else {
                        preparedStatement.setNull(5, 12);
                    }
                    preparedStatement.setString(6, this.brokerID);
                    preparedStatement.setLong(7, transactionState.getExpirationTime());
                    preparedStatement.setLong(8, transactionState.getLastAccessTime());
                    byteArrayInputStream.close();
                    if (bl) {
                        preparedStatement.addBatch();
                        continue;
                    }
                    preparedStatement.executeUpdate();
                }
                catch (IOException iOException) {
                    serializable = DBManager.wrapIOException("[" + string2 + "]", iOException);
                    throw serializable;
                }
                catch (SQLException sQLException) {
                    serializable = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
                    throw serializable;
                }
            }
            if (bl) {
                preparedStatement.executeBatch();
            }
            connection.commit();
        }
        catch (Exception exception) {
            try {
                String string3 = this.br.getKString("B4172", transactionUID == null ? "loading" : transactionUID.toString());
                this.logger.logStack(32, string3, exception);
                throw new BrokerException(string3, exception);
            }
            catch (Throwable throwable) {
                Util.close(resultSet, statement, null);
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }

    private void upgradeTxnAcks(Connection connection) throws BrokerException {
        ConsumerStateDAO consumerStateDAO = this.dbMgr.getDAOFactory().getConsumerStateDAO();
        String string = "SELECT atbl.TUID, TXNACK FROM " + this.oldTxnTable + " ttbl, " + this.oldAckTable + " atbl" + " WHERE ttbl." + "TUID" + " = atbl." + "TUID";
        String string2 = new StringBuffer(128).append("UPDATE ").append(consumerStateDAO.getTableName()).append(" SET ").append("TRANSACTION_ID").append(" = ? ").append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates();
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        TransactionUID transactionUID = null;
        try {
            preparedStatement = connection.prepareStatement(string2);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                long l = resultSet.getLong(1);
                transactionUID = new TransactionUID(l);
                TransactionAcknowledgement transactionAcknowledgement = (TransactionAcknowledgement)Util.readObject(resultSet, 2);
                try {
                    preparedStatement.setLong(1, l);
                    preparedStatement.setString(2, transactionAcknowledgement.getSysMessageID().getUniqueName());
                    preparedStatement.setLong(3, transactionAcknowledgement.getStoredConsumerUID().longValue());
                    if (bl) {
                        preparedStatement.addBatch();
                        continue;
                    }
                    preparedStatement.executeUpdate();
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
                    throw sQLException2;
                }
            }
            if (bl) {
                preparedStatement.executeBatch();
            }
            connection.commit();
            if (this.store.upgradeNoBackup()) {
                this.dropTable(connection, this.oldTxnTable);
                this.dropTable(connection, this.oldAckTable);
            }
        }
        catch (Exception exception) {
            try {
                String string3 = this.br.getKString("B4173", transactionUID == null ? "loading" : transactionUID.toString());
                this.logger.logStack(32, string3, exception);
                throw new BrokerException(string3, exception);
            }
            catch (Throwable throwable) {
                Util.close(resultSet, statement, null);
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }

    private void upgradeChangeRecords(Connection connection) throws BrokerException {
        ConfigRecordDAO configRecordDAO = this.dbMgr.getDAOFactory().getConfigRecordDAO();
        String string = "SELECT RECORD, RECORDTIME FROM " + this.oldConfigRecordTable;
        String string2 = new StringBuffer(128).append("INSERT INTO ").append(configRecordDAO.getTableName()).append(" ( ").append("RECORD").append(", ").append("CREATED_TS").append(") VALUES ( ?, ? )").toString();
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Long l = null;
        try {
            preparedStatement = connection.prepareStatement(string2);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                byte[] byArray = Util.readBytes(resultSet, 1);
                long l2 = resultSet.getLong(2);
                l = new Long(l2);
                try {
                    ByteArrayInputStream byteArrayInputStream = Util.setBytes(preparedStatement, 1, byArray);
                    preparedStatement.setLong(2, l2);
                    byteArrayInputStream.close();
                    preparedStatement.executeUpdate();
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + string2 + "]", iOException);
                    throw iOException2;
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
                    throw sQLException2;
                }
            }
            connection.commit();
            if (this.store.upgradeNoBackup()) {
                this.dropTable(connection, this.oldConfigRecordTable);
            }
        }
        catch (Exception exception) {
            try {
                String string3 = this.br.getKString("B4171", l == null ? "loading" : l.toString());
                this.logger.logStack(32, string3, exception);
                throw new BrokerException(string3, exception);
            }
            catch (Throwable throwable) {
                Util.close(resultSet, statement, null);
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }

    private void upgradeProperties(Connection connection) throws BrokerException {
        PropertyDAO propertyDAO = this.dbMgr.getDAOFactory().getPropertyDAO();
        String string = "SELECT PROPNAME, PROPVALUE FROM " + this.oldPropTable;
        String string2 = new StringBuffer(128).append("INSERT INTO ").append(propertyDAO.getTableName()).append(" ( ").append("PROPNAME").append(", ").append("PROPVALUE").append(") VALUES ( ?, ? )").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates();
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string3 = null;
        try {
            preparedStatement = connection.prepareStatement(string2);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                string3 = resultSet.getString(1);
                Object object = Util.readObject(resultSet, 2);
                try {
                    preparedStatement.setString(1, string3);
                    ByteArrayInputStream byteArrayInputStream = Util.setObject(preparedStatement, 2, object);
                    byteArrayInputStream.close();
                    if (bl) {
                        preparedStatement.addBatch();
                        continue;
                    }
                    preparedStatement.executeUpdate();
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + string2 + "]", iOException);
                    throw iOException2;
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
                    throw sQLException2;
                }
            }
            if (bl) {
                preparedStatement.executeBatch();
            }
            connection.commit();
            if (this.store.upgradeNoBackup()) {
                this.dropTable(connection, this.oldPropTable);
            }
        }
        catch (Exception exception) {
            try {
                String string4 = this.br.getKString("B4170", string3 == null ? "loading" : string3);
                this.logger.logStack(32, string4, exception);
                throw new BrokerException(string4, exception);
            }
            catch (Throwable throwable) {
                Util.close(resultSet, statement, null);
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTable(Connection connection, String string) throws BrokerException {
        String string2 = "DROP TABLE " + string;
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate(string2);
            connection.commit();
            if (Store.DEBUG) {
                Globals.getLogger().log(4, "Dropped table " + string);
            }
        }
        catch (SQLException sQLException) {
            Globals.getLogger().log(32, "B1117", (Object)string, (Throwable)DBManager.wrapSQLException("[" + string2 + "]", sQLException));
        }
        finally {
            Util.close(null, statement, null);
        }
    }

    private void clearTable(Connection connection, String string) throws BrokerException {
        String string2 = "DELETE FROM " + string;
        Statement statement = null;
        try {
            statement = connection.createStatement();
            int n = statement.executeUpdate(string2);
            connection.commit();
            if (Store.DEBUG) {
                Globals.getLogger().log(4, "Deleted " + n + " entries in " + string);
            }
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
            String string3 = Globals.getBrokerResources().getString("B4174", string);
            Globals.getLogger().log(32, string3, sQLException2);
            throw new BrokerException(string3, sQLException2);
        }
        finally {
            Util.close(null, statement, null);
        }
    }
}

