/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.auth.AuthCacheData;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.net.ProtocolCallback;
import com.sun.messaging.jmq.jmsserver.net.ProtocolStreams;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.MQThread;
import com.sun.messaging.jmq.jmsserver.util.pool.RunnableFactory;
import com.sun.messaging.jmq.jmsserver.util.pool.ThreadPool;
import com.sun.messaging.jmq.util.GoodbyeReason;
import com.sun.messaging.jmq.util.ServiceState;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public abstract class IMQService
implements Service,
Runnable,
ProtocolCallback {
    public static boolean DEBUG = false;
    private static boolean WORKAROUND_4244135 = false;
    private boolean WORKAROUND_HTTP = false;
    private ConnectionManager connectionList = Globals.getConnectionManager();
    private boolean serviceRunning = false;
    private boolean shuttingDown = false;
    private int state = 0;
    private int type = 0;
    protected Logger logger = Globals.getLogger();
    protected PacketRouter router = null;
    protected String name = null;
    private AuthCacheData authCacheData = new AuthCacheData();
    protected ThreadPool pool = null;
    protected Thread acceptThread = null;
    protected RunnableFactory runfac = null;
    protected Protocol protocol = null;
    protected Thread listenThread = null;
    protected static final long DESTROY_WAIT_DEFAULT = 30000L;
    protected long ServiceDestroyWait = 30000L;
    private Packet goodbyepacket = null;
    HashMap serviceprops = null;

    public IMQService(String string, Protocol protocol, int n, PacketRouter packetRouter, int n2, int n3) {
        this.name = string;
        this.type = n;
        this.protocol = protocol;
        this.router = packetRouter;
        this.runfac = this.getRunnableFactory();
        if (!protocol.canPause()) {
            this.WORKAROUND_HTTP = true;
        }
        if (n3 == 0) {
            throw new RuntimeException(Globals.getBrokerResources().getKString("B4136", string, String.valueOf(n3)));
        }
        this.pool = new ThreadPool(string, n2, n3, this.runfac);
        if (protocol.getHostName() != null && !protocol.getHostName().equals("*")) {
            this.addServiceProp("hostname", protocol.getHostName());
        }
        protocol.registerProtocolCallback(this, null);
    }

    protected void addServiceProp(String string, String string2) {
        if (this.serviceprops == null) {
            this.serviceprops = new HashMap();
        }
        this.serviceprops.put(string, string2);
    }

    public void resetCounters() {
        List list = this.connectionList.getConnectionList(this);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((IMQConnection)iterator.next()).resetCounters();
        }
    }

    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("name", this.name);
        hashtable.put("state", ServiceState.getString(this.state));
        hashtable.put("shuttingDown", String.valueOf(this.shuttingDown));
        if (this.serviceprops != null) {
            hashtable.put("props", new Hashtable(this.serviceprops));
        }
        hashtable.put("connections", this.connectionList.getDebugState(this));
        return hashtable;
    }

    public Hashtable getPoolDebugState() {
        return this.pool.getDebugState();
    }

    public void dumpPool() {
        this.pool.debug();
    }

    public int size() {
        List list = this.connectionList.getConnectionList(this);
        return list.size();
    }

    public List getConsumers() {
        ArrayList arrayList = new ArrayList();
        List list = this.connectionList.getConnectionList(this);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2 = ((IMQConnection)iterator.next()).getConsumers();
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public List getProducers() {
        ArrayList arrayList = new ArrayList();
        List list = this.connectionList.getConnectionList(this);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2 = ((IMQConnection)iterator.next()).getProducers();
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    protected abstract RunnableFactory getRunnableFactory();

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getName() {
        return this.name;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
    }

    public int getServiceType() {
        return this.type;
    }

    public synchronized int getMinThreadpool() {
        if (this.pool == null) {
            return 0;
        }
        return this.pool.getMinimum();
    }

    public synchronized int getMaxThreadpool() {
        if (this.pool == null) {
            return 0;
        }
        return this.pool.getMaximum();
    }

    public synchronized int getActiveThreadpool() {
        if (this.pool == null) {
            return 0;
        }
        return this.pool.getThreadNum();
    }

    public void setPriority(int n) {
        this.pool.setPriority(n);
    }

    public synchronized void setMinMaxThreadpool(int n, int n2) {
        if (this.pool == null) {
            return;
        }
        this.pool.setMinMax(n, n2);
    }

    public void setDestroyWaitTime(long l) {
        this.ServiceDestroyWait = l;
    }

    public synchronized void startService(boolean bl) {
        if (this.serviceRunning || this.listenThread != null) {
            this.logger.log(4, "B3100", "unable to start service, already started.");
            return;
        }
        this.setState(2);
        Object[] objectArray = new String[]{this.getName(), this.protocol.toString(), String.valueOf(this.getMinThreadpool()), String.valueOf(this.getMaxThreadpool())};
        this.logger.log(8, "B1004", objectArray);
        try {
            this.logger.log(8, "B1227", (Object)AccessController.getInstance(this.getName(), this.getServiceType()).getUserRepository(), this.getName());
        }
        catch (BrokerException brokerException) {
            this.logger.log(16, "B2135", (Object)this.getName(), brokerException.getMessage());
        }
        this.listenThread = new MQThread(this, this.getName() + "_ACCEPT");
        this.listenThread.start();
        this.pool.start();
        if (bl) {
            this.serviceRunning = false;
            this.setState(4);
            if (!this.WORKAROUND_HTTP) {
                try {
                    this.protocol.close();
                    Globals.getPortMapper().updateServicePort(this.name, 0);
                }
                catch (Exception exception) {
                    this.logger.logStack(16, "B3100", "starting paused service " + this, (Throwable)exception);
                }
            }
        } else {
            this.serviceRunning = true;
            this.setState(3);
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService(boolean bl) {
        int n;
        Object object;
        Object object2 = this;
        synchronized (object2) {
            if (this.shuttingDown) {
                return;
            }
            object = new String[]{this.getName(), this.protocol.toString()};
            if (bl) {
                this.logger.log(8, "B1007", (Object[])object);
            } else if (!this.shuttingDown) {
                this.logger.log(8, "B1053", (Object[])object);
            }
            this.shuttingDown = true;
        }
        try {
            this.protocol.close();
        }
        catch (Exception exception) {
            this.logger.log(4, "Exception shutting down  protocol, ignoring since we are exiting", exception);
        }
        if (this.getServiceType() == 0) {
            object2 = this.connectionList.getConnectionList(this);
            object = null;
            for (n = object2.size() - 1; n >= 0; --n) {
                object = (Connection)object2.get(n);
                ((Connection)object).stopConnection();
            }
        }
        object2 = this;
        synchronized (object2) {
            this.setState(5);
            this.notify();
        }
        if (!bl) {
            return;
        }
        if (this.getServiceType() == 0) {
            object2 = this.connectionList.getConnectionList(this);
            object = null;
            for (n = object2.size() - 1; n >= 0; --n) {
                object = (Connection)object2.get(n);
                ((Connection)object).destroyConnection(true, GoodbyeReason.SHUTDOWN_BKR, Globals.getBrokerResources().getKString("B0060"));
            }
        }
        object2 = this;
        synchronized (object2) {
            this.setState(6);
            this.notify();
        }
        if (this.pool.isValid()) {
            this.pool.waitOnDestroy(this.ServiceDestroyWait);
        }
        if (DEBUG) {
            this.logger.log(4, "Destroying Service {0} with protocol {1} ", (Object)this.getName(), this.protocol.toString());
        }
    }

    public void stopNewConnections() throws IOException, IllegalStateException {
        if (this.state != 3) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4254"));
        }
        this.state = 8;
        if (!WORKAROUND_4244135 && !this.WORKAROUND_HTTP) {
            if (this.protocol != null && this.protocol.isOpen()) {
                this.protocol.close();
            }
            Globals.getPortMapper().updateServicePort(this.name, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNewConnections() throws IOException {
        if (this.state != 8 && this.state != 4) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4255"));
        }
        if (!WORKAROUND_4244135 && !this.WORKAROUND_HTTP) {
            try {
                this.protocol.open();
            }
            catch (Exception exception) {
                this.logger.logStack(16, "B3100", "starting connections" + this, (Throwable)exception);
            }
        }
        IMQService iMQService = this;
        synchronized (iMQService) {
            this.setState(3);
            this.notify();
        }
    }

    public void pauseService(boolean bl) {
        if (!this.serviceRunning) {
            this.logger.log(4, "B3100", "unable to pause service " + this.name + ", already paused.");
            return;
        }
        Object[] objectArray = new String[]{this.getName(), this.protocol.toString()};
        this.logger.log(4, "B1005", objectArray);
        try {
            this.stopNewConnections();
        }
        catch (Exception exception) {
            this.logger.logStack(16, "B3100", "pausing service " + this, (Throwable)exception);
        }
        this.setState(4);
        if (bl) {
            this.pool.suspend();
        }
        this.serviceRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeService() {
        if (this.serviceRunning) {
            this.logger.log(4, "B3100", "unable to resume service " + this.name + ", already running.");
            return;
        }
        Object[] objectArray = new String[]{this.getName(), this.protocol.toString()};
        this.logger.log(4, "B1006", objectArray);
        try {
            this.startNewConnections();
        }
        catch (Exception exception) {
            this.logger.logStack(16, "B3100", "pausing service " + this, (Throwable)exception);
        }
        this.pool.resume();
        this.serviceRunning = true;
        IMQService iMQService = this;
        synchronized (iMQService) {
            this.setState(3);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyService() {
        if (this.getState() < 6) {
            this.stopService(true);
        }
        IMQService iMQService = this;
        synchronized (iMQService) {
            this.setState(7);
            this.notify();
        }
    }

    public void updateService(int n, int n2, int n3) throws IOException, PropertyUpdateException, BrokerException {
        String string = this.getName();
        String string2 = Globals.getConfig().getProperty("imq." + string + ".protocoltype");
        Protocol protocol = this.getProtocol();
        Object[] objectArray = new String[]{string, String.valueOf(n), String.valueOf(n2), String.valueOf(n3)};
        this.logger.log(8, "B1090", objectArray);
        if (n > -1) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("port", String.valueOf(n));
            protocol.checkParameters(hashtable);
            if (!WORKAROUND_4244135) {
                protocol.setParameters(hashtable);
                Globals.getPortMapper().removeService(string);
                Globals.getPortMapper().addService(string, string2, Globals.getConfig().getProperty("imq." + string + ".servicetype"), protocol.getLocalPort(), this.getServiceProperties());
            }
            Globals.getConfig().updateProperty("imq." + string + "." + string2 + ".port", String.valueOf(n));
        }
        if (n2 > -1 || n3 > -1) {
            try {
                if (n3 == 0) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4136", string, String.valueOf(n3)));
                }
                this.setMinMaxThreadpool(n2, n3);
                if (n2 > -1) {
                    Globals.getConfig().updateProperty("imq." + string + ".min_threads", String.valueOf(n2));
                }
                if (n3 > -1) {
                    Globals.getConfig().updateProperty("imq." + string + ".max_threads", String.valueOf(n3));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4115", String.valueOf(n2), String.valueOf(n3)), illegalArgumentException);
            }
        }
        if (n > -1 && WORKAROUND_4244135) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3109"));
        }
    }

    public synchronized void socketUpdated(Object object, int n, String string) {
        if (n == -1) {
            n = this.protocol.getLocalPort();
        }
        Object[] objectArray = new String[]{this.name, String.valueOf(n), string == null ? "*" : string};
        this.logger.log(4, "B1091", objectArray);
        Globals.getPortMapper().updateServicePort(this.name, n);
        if (string != null) {
            this.addServiceProp("hostname", string);
            Globals.getPortMapper().updateServiceProperties(this.name, this.getServiceProperties());
        }
    }

    public AuthCacheData getAuthCacheData() {
        return this.authCacheData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (DEBUG) {
            this.logger.log(2, "Starting thread to listen for connections on {0} with protocol {1}", (Object)this.getName(), this.protocol.toString());
        }
        while (true) {
            Object[] objectArray;
            ProtocolStreams protocolStreams = null;
            if (!this.shuttingDown && !this.serviceRunning) {
                objectArray = this;
                synchronized (objectArray) {
                    while (!(this.shuttingDown || this.serviceRunning || WORKAROUND_4244135 && this.getState() == 4 || this.WORKAROUND_HTTP && this.getState() == 4)) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            if (this.shuttingDown) break;
            try {
                IMQService iMQService;
                try {
                    protocolStreams = this.protocol.accept();
                }
                catch (Exception exception) {
                    if (this.getState() == 4 || this.getState() == 8) {
                        iMQService = this;
                        synchronized (iMQService) {
                            if (this.getState() == 4 || this.getState() == 8) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            continue;
                        }
                    }
                    if (this.shuttingDown) break;
                    this.logger.log(4, "Exception accepting connection " + this.protocol + " expected", exception);
                    protocolStreams = this.protocol.accept();
                }
                if ((WORKAROUND_4244135 || this.WORKAROUND_HTTP) && this.getState() == 4) {
                    objectArray = this;
                    synchronized (objectArray) {
                        if (this.getState() == 4) {
                            try {
                                protocolStreams.close();
                            }
                            catch (IOException iOException) {
                                this.logger.log(4, "Exception closing down " + this.protocol, iOException);
                            }
                            continue;
                        }
                    }
                }
                if (DEBUG) {
                    objectArray = new String[]{this.getName(), this.protocol.toString(), ((Object)protocolStreams).toString()};
                    this.logger.log(1, "Accepted new connection for Service( {0},{1}, {2})", objectArray);
                }
                if ((objectArray = this.createConnection(protocolStreams)) == null) {
                    this.logger.log(16, "B3100", "null connection " + protocolStreams);
                    continue;
                }
                try {
                    iMQService = this;
                    synchronized (iMQService) {
                        if (this.shuttingDown) {
                            if (DEBUG) {
                                Object[] objectArray2 = new String[]{this.getName(), this.protocol.toString(), ((Object)protocolStreams).toString()};
                                this.logger.log(1, "Remove new connection for Service( {0},{1}, {2}) is in shutting down", objectArray2);
                            }
                            objectArray.setConnectionState(-1);
                            protocolStreams.close();
                            this.serviceRunning = false;
                            return;
                        }
                        this.connectionList.addConnection((Connection)objectArray);
                    }
                }
                catch (BrokerException brokerException) {
                    objectArray.setConnectionState(-1);
                    this.logger.log(16, brokerException.getMessage());
                }
                try {
                    this.acceptConnection((IMQConnection)objectArray);
                }
                catch (Throwable throwable) {
                    this.connectionList.removeConnection(objectArray.getConnectionUID(), true, GoodbyeReason.CON_FATAL_ERROR, throwable.toString());
                    if (!this.shuttingDown) {
                        int n = 32;
                        if (throwable instanceof BrokerException && ((BrokerException)throwable).getStatusCode() == 405) {
                            n = 4;
                        }
                        this.logger.logStack(n, "B3100", "Unable to allocate connection" + objectArray.toString() + " on service " + this.name + ", closing", throwable);
                    }
                    if (protocolStreams != null) {
                        try {
                            protocolStreams.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.logger.log(4, "Exception closing " + this.protocol, throwable);
                }
            }
            catch (IOException iOException) {
                if (!this.shuttingDown && this.state != 8) {
                    this.logger.logStack(32, "B3018", this.name, (Throwable)iOException);
                }
                this.logger.log(4, "Exception closing " + this.protocol, iOException);
                break;
            }
            catch (Throwable throwable) {
                if (!this.shuttingDown) {
                    this.logger.logStack(32, "B3018", this.name, throwable);
                }
                this.logger.log(4, "Exception closing " + this.protocol, throwable);
                if (protocolStreams == null) break;
                try {
                    protocolStreams.close();
                }
                catch (Exception exception) {}
                break;
            }
        }
        this.serviceRunning = false;
    }

    public IMQConnection createConnection(ProtocolStreams protocolStreams) throws IOException, BrokerException {
        IMQConnection iMQConnection = new IMQConnection(this, protocolStreams, this.router);
        return iMQConnection;
    }

    protected abstract void acceptConnection(IMQConnection var1) throws IOException, BrokerException;

    public void removeConnection(ConnectionUID connectionUID, int n, String string) {
        this.connectionList.removeConnection(connectionUID, true, n, string);
    }

    public HashMap getServiceProperties() {
        return this.serviceprops;
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Properties properties = System.getProperties();
        BrokerConfig brokerConfig = Globals.getConfig();
        try {
            WORKAROUND_4244135 = brokerConfig.getProperty("imq.workaround_4244135") != null ? brokerConfig.getBooleanProperty("imq.workaround_4244135") : properties.getProperty("os.name").startsWith("Linux") && properties.getProperty("java.vm.name").indexOf("HotSpot") > -1 && properties.getProperty("java.version").startsWith("1.3");
        }
        catch (Throwable throwable) {
            Globals.getLogger().log(32, throwable.toString(), throwable);
        }
        finally {
            if (WORKAROUND_4244135) {
                Globals.getLogger().log(4, "Using workaround for bug 4244135");
            }
        }
    }
}

