/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceFactory;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;

public abstract class IMQServiceFactory
extends ServiceFactory {
    public static boolean DEBUG = false;
    private static final Logger logger = Globals.getLogger();
    public static final String PROTOCOL_PREFIX = "imq.protocol.";
    public static final String SERVICE_PREFIX = "imq.";
    private BrokerConfig props = Globals.getConfig();
    private int DEFAULT_DESTROY_TIMEOUT = 30;

    protected Hashtable getProtocolParams(String string, String string2) {
        List list = this.getProtocolNames(string);
        if (list == null) {
            return null;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            String string3 = (String)list.get(i);
            String string4 = Globals.getConfig().getProperty(string2 + "." + string3);
            if (string4 == null) continue;
            hashtable.put(string3, string4);
        }
        return hashtable;
    }

    protected List getProtocolNames(String string) {
        return Globals.getConfig().getList(PROTOCOL_PREFIX + string + ".propertylist");
    }

    public void updateService(Service service) throws BrokerException {
        IMQService iMQService = (IMQService)service;
        String string = service.getName();
        String string2 = SERVICE_PREFIX + string + ".protocoltype";
        String string3 = this.props.getProperty(string2);
        String string4 = SERVICE_PREFIX + string + "." + string3;
        Protocol protocol = iMQService.getProtocol();
        Hashtable hashtable = this.getProtocolParams(string3, string4);
        protocol.checkParameters(hashtable);
        try {
            protocol.setParameters(hashtable);
        }
        catch (IOException iOException) {
            Object[] objectArray = new String[]{string3, protocol.toString(), string};
            throw new BrokerException(Globals.getBrokerResources().getKString("B4001", objectArray), iOException);
        }
        int n = this.getThreadMin(string);
        int n2 = this.getThreadMax(string);
        try {
            iMQService.setMinMaxThreadpool(n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4115", String.valueOf(n), String.valueOf(n2)), illegalArgumentException);
        }
        Globals.getPortMapper().addService(string, string3, this.props.getProperty(SERVICE_PREFIX + string + ".servicetype"), protocol.getLocalPort(), iMQService.getServiceProperties());
    }

    public void startMonitoringService(Service service) throws BrokerException {
        String string = service.getName();
        String string2 = SERVICE_PREFIX + string + ".protocoltype";
        String string3 = this.props.getProperty(string2);
        List list = this.getProtocolNames(string3);
        for (int i = 0; list != null && i < list.size(); ++i) {
            String string4 = (String)list.get(i);
            this.props.addListener(string4, this);
        }
        String string5 = SERVICE_PREFIX + string + ".min_threads";
        this.props.addListener(string5, this);
        string5 = SERVICE_PREFIX + string + ".max_threads";
        this.props.addListener(string5, this);
    }

    public void stopMonitoringService(Service service) throws BrokerException {
        String string = service.getName();
        String string2 = SERVICE_PREFIX + string + ".protocoltype";
        String string3 = this.props.getProperty(string2);
        List list = this.getProtocolNames(string3);
        for (int i = 0; list != null && i < list.size(); ++i) {
            String string4 = (String)list.get(i);
            this.props.removeListener(string4, this);
        }
        String string5 = SERVICE_PREFIX + string + ".min";
        this.props.removeListener(string5, this);
        string5 = SERVICE_PREFIX + string + ".max";
        this.props.removeListener(string5, this);
    }

    public void validate(String string, String string2) throws PropertyUpdateException {
    }

    public boolean update(String string, String string2) {
        return true;
    }

    private int getThreadMin(String string) {
        String string2 = SERVICE_PREFIX + string + ".min_threads";
        return this.props.getIntProperty(string2);
    }

    private int getPoolTimeout(String string) {
        String string2 = SERVICE_PREFIX + string + ".destroy_timeout";
        return this.props.getIntProperty(string2, this.DEFAULT_DESTROY_TIMEOUT) * 1000;
    }

    private int getThreadMax(String string) {
        String string2 = SERVICE_PREFIX + string + ".max_threads";
        return this.props.getIntProperty(string2);
    }

    public Service createService(String string, int n) throws BrokerException {
        String string2 = SERVICE_PREFIX + string + ".protocoltype";
        String string3 = this.props.getProperty(string2);
        if (string3 == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4003", string, string2));
        }
        String string4 = PROTOCOL_PREFIX + string3 + ".class";
        String string5 = this.props.getProperty(string4);
        if (string5 == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4003", string, string4));
        }
        if (DEBUG) {
            logger.log(4, " Creating new Service(" + string + ":" + string5 + ")");
        }
        Protocol protocol = null;
        try {
            protocol = (Protocol)Class.forName(string5).newInstance();
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{string3.toString(), string};
            throw new BrokerException(Globals.getBrokerResources().getKString("B4002", objectArray), exception);
        }
        String string6 = PROTOCOL_PREFIX + string3;
        boolean bl = Globals.getConfig().getBooleanProperty(string6 + ".nodelay", true);
        protocol.setNoDelay(bl);
        int n2 = Globals.getConfig().getIntProperty(string6 + ".inbufsz", 0);
        int n3 = Globals.getConfig().getIntProperty(string6 + ".outbufsz", 0);
        protocol.setInputBufferSize(n2);
        protocol.setOutputBufferSize(n3);
        String string7 = SERVICE_PREFIX + string + "." + string3;
        Hashtable hashtable = this.getProtocolParams(string3, string7);
        protocol.checkParameters(hashtable);
        try {
            protocol.setParameters(hashtable);
            protocol.open();
        }
        catch (IOException iOException) {
            Object[] objectArray = new String[]{string5, string3.toString(), string};
            throw new BrokerException(Globals.getBrokerResources().getKString("B4001", objectArray), iOException);
        }
        try {
            IMQService iMQService = this.createService(string, protocol, Globals.getPacketRouter(n), n, this.getThreadMin(string), this.getThreadMax(string));
            long l = this.getPoolTimeout(string);
            if (l > 0L) {
                iMQService.setDestroyWaitTime(l);
            }
            return iMQService;
        }
        catch (IOException iOException) {
            try {
                protocol.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new BrokerException(Globals.getBrokerResources().getKString("B3009", string), iOException);
        }
    }

    protected abstract IMQService createService(String var1, Protocol var2, PacketRouter var3, int var4, int var5, int var6) throws IOException;
}

