/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.JMQByteArrayOutputStream;
import com.sun.messaging.jmq.io.JMQByteBufferInputStream;
import com.sun.messaging.jmq.io.PacketProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.Hashtable;

public class PacketPayload {
    protected ByteBuffer propBuf_v1 = null;
    protected ByteBuffer propBuf_v2 = null;
    protected Hashtable properties = null;
    protected ByteBuffer bodyBuf = null;

    public PacketPayload() {
        this.reset();
    }

    public synchronized void reset() {
        this.propBuf_v1 = null;
        this.propBuf_v2 = null;
        this.properties = null;
        this.bodyBuf = null;
    }

    public synchronized ByteBuffer getBodyBytes() {
        if (this.bodyBuf == null) {
            return null;
        }
        this.bodyBuf.rewind();
        return this.bodyBuf;
    }

    public int getBodySize() {
        if (this.bodyBuf == null) {
            return 0;
        }
        return this.bodyBuf.limit();
    }

    public InputStream getBodyStream() {
        if (this.bodyBuf == null) {
            return null;
        }
        return new JMQByteBufferInputStream(this.getBodyBytes());
    }

    public synchronized Hashtable getProperties() throws IOException, ClassNotFoundException {
        if (this.properties != null) {
            return this.properties;
        }
        ByteBuffer byteBuffer = this.propBuf_v2;
        short s = 301;
        if (byteBuffer == null && this.propBuf_v1 != null) {
            byteBuffer = this.propBuf_v1;
            s = 200;
        }
        if (byteBuffer != null) {
            byteBuffer.rewind();
            try {
                InputStream inputStream = this.getPropertiesStream(s);
                this.properties = s >= 301 ? PacketProperties.parseProperties(inputStream) : this.parseProperties(inputStream);
            }
            catch (IOException iOException) {
                System.err.println("Could not parse properties " + iOException);
                iOException.printStackTrace();
                throw iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Could not parse properties " + classNotFoundException);
                classNotFoundException.printStackTrace();
                throw classNotFoundException;
            }
            return this.properties;
        }
        return null;
    }

    public synchronized ByteBuffer getPropertiesBytes(short s) {
        ByteBuffer byteBuffer;
        if (this.propBuf_v1 == null && this.propBuf_v2 == null && this.properties == null) {
            return null;
        }
        ByteBuffer byteBuffer2 = byteBuffer = s >= 301 ? this.propBuf_v2 : this.propBuf_v1;
        if (byteBuffer == null && this.properties == null) {
            try {
                this.getProperties();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (byteBuffer == null) {
            JMQByteArrayOutputStream jMQByteArrayOutputStream = new JMQByteArrayOutputStream(new byte[256]);
            try {
                if (s >= 301) {
                    PacketProperties.write(this.properties, jMQByteArrayOutputStream);
                } else {
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(jMQByteArrayOutputStream);
                    objectOutputStream.writeObject(this.properties);
                    objectOutputStream.close();
                }
            }
            catch (Exception exception) {
                System.err.println("Could not marshal properties " + exception);
                exception.printStackTrace();
            }
            byteBuffer = ByteBuffer.wrap(jMQByteArrayOutputStream.getBuf(), 0, jMQByteArrayOutputStream.getCount());
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    public InputStream getPropertiesStream(short s) {
        ByteBuffer byteBuffer = this.getPropertiesBytes(s);
        if (byteBuffer == null) {
            return null;
        }
        return new JMQByteBufferInputStream(byteBuffer);
    }

    public synchronized void setBody(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            this.bodyBuf = null;
        } else {
            this.bodyBuf = byteBuffer;
            this.bodyBuf.rewind();
        }
    }

    public synchronized void setProperties(Hashtable hashtable) {
        this.properties = hashtable;
        this.propBuf_v1 = null;
        this.propBuf_v2 = null;
    }

    public synchronized void setPropertiesBytes(ByteBuffer byteBuffer, short s) {
        if (byteBuffer == null) {
            this.propBuf_v1 = null;
            this.propBuf_v2 = null;
        } else {
            ByteBuffer byteBuffer2 = null;
            byteBuffer2 = s >= 301 ? (this.propBuf_v2 = byteBuffer) : (this.propBuf_v1 = byteBuffer);
            byteBuffer2.rewind();
        }
        this.properties = null;
    }

    private Hashtable parseProperties(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        return (Hashtable)objectInputStream.readObject();
    }
}

