/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.lists;

import com.sun.messaging.jmq.util.lists.EventBroadcaster;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Reason;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class EventBroadcastHelper
implements EventBroadcaster {
    Collection[] c = new Collection[EventType.EVENT_TYPE_NUM];
    boolean[] busy = new boolean[EventType.EVENT_TYPE_NUM];
    int[] start = null;
    int cnt = 0;
    Boolean orderMaintained = new Boolean(true);
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock shareLock = this.lock.readLock();
    private Lock exclusiveLock = this.lock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrderMaintained(boolean bl) {
        Boolean bl2 = this.orderMaintained;
        synchronized (bl2) {
            this.orderMaintained = bl;
            if (!this.orderMaintained.booleanValue()) {
                this.start = new int[EventType.EVENT_TYPE_NUM];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.exclusiveLock.lock();
        try {
            this.c = new Collection[EventType.EVENT_TYPE_NUM];
            for (int i = 0; i < EventType.EVENT_TYPE_NUM; ++i) {
                this.busy[i] = false;
            }
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    public void dump(PrintStream printStream) {
        printStream.println(this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string = "EventBroadcastHelper {\n";
        this.shareLock.lock();
        try {
            int n = this.c.length;
            for (int i = 0; i < n; ++i) {
                boolean bl = false;
                string = string + "\t" + i + " { ";
                if (this.c[i] == null) {
                    string = string + "null";
                } else {
                    Iterator iterator = this.c[i].iterator();
                    boolean bl2 = true;
                    int n2 = 0;
                    while (iterator.hasNext()) {
                        ListenerInfo listenerInfo = (ListenerInfo)iterator.next();
                        bl = true;
                        if (!bl2) {
                            string = string + "\t    ";
                        }
                        bl2 = false;
                        string = string + n2 + ":  " + listenerInfo.getListener() + "\n\t        " + listenerInfo.getType() + "\n\t        " + listenerInfo.getReason() + "\n\t        " + listenerInfo.getUserData() + "\n";
                        ++n2;
                    }
                }
                string = bl ? string + "\t  }\n" : string + " }\n";
            }
        }
        finally {
            this.shareLock.unlock();
        }
        return string;
    }

    public Object addEventListener(EventListener eventListener, EventType eventType, Object object) {
        return this.addEventListener(eventListener, eventType, null, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addEventListener(EventListener eventListener, EventType eventType, Reason reason, Object object) {
        ListenerInfo listenerInfo = new ListenerInfo(eventListener, eventType, reason, object);
        int n = eventType.getEvent();
        this.exclusiveLock.lock();
        try {
            if (this.c[n] == null) {
                this.c[n] = new ArrayList();
                this.c[n].add(listenerInfo);
            } else {
                ArrayList<ListenerInfo> arrayList = new ArrayList<ListenerInfo>(this.c[n]);
                arrayList.add(listenerInfo);
                this.c[n] = arrayList;
            }
            this.busy[n] = true;
            ++this.cnt;
        }
        finally {
            this.exclusiveLock.unlock();
        }
        return listenerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeEventListener(Object object) {
        this.exclusiveLock.lock();
        try {
            if (object == null) {
                Object var2_2 = null;
                return var2_2;
            }
            ListenerInfo listenerInfo = (ListenerInfo)object;
            int n = listenerInfo.getType().getEvent();
            Collection collection = this.c[n];
            if (collection == null) {
                Object var5_6 = null;
                return var5_6;
            }
            ArrayList arrayList = new ArrayList(collection);
            arrayList.remove(listenerInfo);
            this.busy[n] = !arrayList.isEmpty();
            this.c[n] = arrayList;
            EventListener eventListener = listenerInfo.getListener();
            listenerInfo.clear();
            --this.cnt;
            EventListener eventListener2 = eventListener;
            return eventListener2;
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChange(EventType eventType, Reason reason, Object object, Object object2, Object object3) {
        this.shareLock.lock();
        try {
            ArrayList arrayList = (ArrayList)this.c[eventType.getEvent()];
            if (arrayList == null || arrayList.isEmpty()) {
                return;
            }
            int n = 0;
            int n2 = arrayList.size();
            if (!this.orderMaintained.booleanValue() && this.start != null && n2 > 1) {
                Boolean bl = this.orderMaintained;
                synchronized (bl) {
                    n = this.start[eventType.getEvent()];
                    this.start[eventType.getEvent()] = n >= n2 - 1 ? 0 : n + 1;
                }
            }
            for (int i = 0; i < n2; ++i) {
                int n3;
                ListenerInfo listenerInfo = null;
                int n4 = n3 = n == 0 ? i : (i + n) % n2;
                if (n3 >= arrayList.size() || (listenerInfo = (ListenerInfo)arrayList.get(n3)) == null) continue;
                EventListener eventListener = listenerInfo.getListener();
                Reason reason2 = listenerInfo.getReason();
                Object object4 = listenerInfo.getUserData();
                if (eventListener == null || reason2 != null && reason2 != reason) continue;
                eventListener.eventOccured(eventType, reason, object, object2, object3, object4);
            }
        }
        finally {
            this.shareLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners(EventType eventType) {
        this.shareLock.lock();
        try {
            boolean bl = this.busy[eventType.getEvent()];
            return bl;
        }
        finally {
            this.shareLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners() {
        this.shareLock.lock();
        try {
            boolean bl = this.cnt > 0;
            return bl;
        }
        finally {
            this.shareLock.unlock();
        }
    }

    class ListenerInfo {
        EventListener l;
        EventType type;
        Object userData;
        Reason reason;

        public ListenerInfo(EventListener eventListener, EventType eventType, Reason reason, Object object) {
            this.l = eventListener;
            this.type = eventType;
            this.userData = object;
            this.reason = reason;
        }

        Reason getReason() {
            return this.reason;
        }

        Object getUserData() {
            return this.userData;
        }

        EventType getType() {
            return this.type;
        }

        EventListener getListener() {
            return this.l;
        }

        void clear() {
            this.l = null;
            this.userData = null;
            this.reason = null;
            this.type = null;
        }
    }
}

