/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.usermgr;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.Output;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.PasswdDB;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserInfo;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrException;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrOptions;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrProperties;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrUtils;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserPrinter;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;

public class CmdRunner
implements UserMgrOptions {
    private static BrokerResources br = Globals.getBrokerResources();
    private UserMgrProperties userMgrProps;
    private PasswdDB pwDB;

    public CmdRunner(UserMgrProperties userMgrProperties) {
        this.userMgrProps = userMgrProperties;
    }

    public int runCommands() {
        int n = 0;
        String string = this.userMgrProps.getCommand();
        this.pwDB = new PasswdDB();
        PasswdDB.setPasswordFileName(this.userMgrProps.getPasswordFile());
        if (string.equals("add")) {
            n = this.runAdd(this.userMgrProps);
        } else if (string.equals("delete")) {
            n = this.runDelete(this.userMgrProps);
        } else if (string.equals("list")) {
            n = this.runList(this.userMgrProps);
        } else if (string.equals("update")) {
            n = this.runUpdate(this.userMgrProps);
        } else if (string.equals(".exists")) {
            n = this.runExists(this.userMgrProps);
        } else if (string.equals(".getgroup")) {
            n = this.runGetGroup(this.userMgrProps);
        } else if (string.equals(".getgroupsize")) {
            n = this.runGetGroupSize(this.userMgrProps);
        }
        return n;
    }

    private int runAdd(UserMgrProperties userMgrProperties) {
        String string = userMgrProperties.getUserName();
        String string2 = userMgrProperties.getRole();
        if (string2 == null) {
            string2 = "user";
        }
        Output.stdOutPrintln(br.getString("B1120", userMgrProperties.getInstance()));
        try {
            if (string.equals("guest") && !string2.equals("anonymous")) {
                Output.stdErrPrintln(br.getString("B2023"));
            }
            String string3 = this.getPasswordFromFileOrCmdLine(userMgrProperties);
            this.pwDB.addUser(string, string3, string2);
        }
        catch (UserMgrException userMgrException) {
            this.handleUserMgrExceptions(userMgrException);
            Output.stdErrPrintln("");
            Output.stdErrPrintln(br.getString("B1025"));
            return 1;
        }
        Output.stdOutPrintln(br.getString("B1017", string));
        return 0;
    }

    private int runDelete(UserMgrProperties userMgrProperties) {
        String string = userMgrProperties.getUserName();
        boolean bl = userMgrProperties.forceModeSet();
        Output.stdOutPrintln(br.getString("B1120", userMgrProperties.getInstance()));
        try {
            int n;
            Object object;
            if (!bl) {
                object = br.getString("B0027");
                String string2 = UserMgrUtils.getUserInput(null, br.getString("B1023", string), (String)object);
                if (((String)object).equalsIgnoreCase(string2)) {
                    Output.stdErrPrintln("");
                    Output.stdErrPrintln(br.getString("B1020", string));
                    return 0;
                }
            }
            if ((object = this.pwDB.getUserInfo(string)) != null && ((UserInfo)object).getRole().equals("admin") && (n = this.pwDB.getUserCount("admin")) == 1) {
                Output.stdErrPrintln(br.getString("B2022", string));
            }
            this.pwDB.deleteUser(string);
        }
        catch (UserMgrException userMgrException) {
            this.handleUserMgrExceptions(userMgrException);
            Output.stdErrPrintln("");
            Output.stdErrPrintln(br.getString("B1026"));
            return 1;
        }
        Output.stdOutPrintln(br.getString("B1019", string));
        return 0;
    }

    private int runList(UserMgrProperties userMgrProperties) {
        String string = userMgrProperties.getUserName();
        UserPrinter userPrinter = new UserPrinter(3, 4, "-");
        Object[] objectArray = new String[3];
        try {
            Output.stdOutPrintln(br.getString("B1120", userMgrProperties.getInstance()));
            objectArray[0] = br.getString("B1036");
            objectArray[1] = br.getString("B1037");
            objectArray[2] = br.getString("B1038");
            userPrinter.addTitle((String[])objectArray);
            if (string == null) {
                Enumeration enumeration = this.pwDB.getUsers();
                while (enumeration.hasMoreElements()) {
                    UserInfo userInfo = (UserInfo)enumeration.nextElement();
                    objectArray[0] = userInfo.getUser();
                    objectArray[1] = userInfo.getRole();
                    objectArray[2] = String.valueOf(userInfo.isActive());
                    userPrinter.add(objectArray);
                }
            } else {
                UserInfo userInfo = this.pwDB.getUserInfo(string);
                if (userInfo == null) {
                    Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3048", string));
                    Output.stdErrPrintln("");
                    Output.stdErrPrintln(br.getString("B1028"));
                    return 1;
                }
                objectArray[0] = userInfo.getUser();
                objectArray[1] = userInfo.getRole();
                objectArray[2] = String.valueOf(userInfo.isActive());
                userPrinter.add(objectArray);
            }
        }
        catch (UserMgrException userMgrException) {
            this.handleUserMgrExceptions(userMgrException);
            Output.stdErrPrintln("");
            Output.stdErrPrintln(br.getString("B1028"));
            return 1;
        }
        userPrinter.println();
        return 0;
    }

    private int runExists(UserMgrProperties userMgrProperties) {
        int n;
        String string = userMgrProperties.getUserName();
        try {
            UserInfo userInfo = this.pwDB.getUserInfo(string);
            if (userInfo == null) {
                Output.stdOutPrintln(Boolean.FALSE.toString());
                n = 0;
            } else {
                Output.stdOutPrintln(Boolean.TRUE.toString());
                n = 0;
            }
        }
        catch (UserMgrException userMgrException) {
            this.handleUserMgrExceptions(userMgrException);
            Output.stdErrPrintln("");
            Output.stdErrPrintln("Checking if a user exist failed.");
            return 1;
        }
        return n;
    }

    private int runGetGroup(UserMgrProperties userMgrProperties) {
        int n;
        block6: {
            String string = userMgrProperties.getUserName();
            try {
                UserInfo userInfo = this.pwDB.getUserInfo(string);
                if (userInfo == null) {
                    Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3048", string));
                    Output.stdErrPrintln("");
                    Output.stdErrPrintln("Getting a user's group failed.");
                    return 1;
                }
                String string2 = userInfo.getRole();
                if (string2.equals("admin")) {
                    Output.stdOutPrintln("admin");
                    n = 0;
                    break block6;
                }
                if (string2.equals("user")) {
                    Output.stdOutPrintln("user");
                    n = 0;
                    break block6;
                }
                if (string2.equals("anonymous")) {
                    Output.stdOutPrintln("anonymous");
                    n = 0;
                    break block6;
                }
                Output.stdErrPrintln("");
                Output.stdErrPrintln("User " + string + " is in unknown group: " + string2);
                return 1;
            }
            catch (UserMgrException userMgrException) {
                this.handleUserMgrExceptions(userMgrException);
                Output.stdErrPrintln("");
                Output.stdErrPrintln("Getting a user's group failed.");
                return 1;
            }
        }
        return n;
    }

    private int runGetGroupSize(UserMgrProperties userMgrProperties) {
        String string = userMgrProperties.getRole();
        int n = 0;
        try {
            n = this.pwDB.getUserCount(string);
            Output.stdOutPrintln(Integer.toString(n));
        }
        catch (UserMgrException userMgrException) {
            this.handleUserMgrExceptions(userMgrException);
            Output.stdErrPrintln("");
            Output.stdErrPrintln("Getting a group's size failed.");
            return 1;
        }
        return 0;
    }

    private String getActiveString(int n) {
        return Integer.toString(n);
    }

    private int runUpdate(UserMgrProperties userMgrProperties) {
        String string = userMgrProperties.getUserName();
        Boolean bl = userMgrProperties.isActive();
        boolean bl2 = userMgrProperties.forceModeSet();
        Output.stdOutPrintln(br.getString("B1120", userMgrProperties.getInstance()));
        try {
            if (!bl2) {
                String string2 = br.getString("B0027");
                String string3 = UserMgrUtils.getUserInput(null, br.getString("B1024", string), string2);
                if (string2.equalsIgnoreCase(string3)) {
                    Output.stdErrPrintln("");
                    Output.stdErrPrintln(br.getString("B1022", string));
                    return 0;
                }
            }
            String string4 = this.getPasswordFromFileOrCmdLine(userMgrProperties);
            this.pwDB.updateUser(string, string4, bl);
        }
        catch (UserMgrException userMgrException) {
            this.handleUserMgrExceptions(userMgrException);
            Output.stdErrPrintln("");
            Output.stdErrPrintln(br.getString("B1027"));
            return 1;
        }
        Output.stdOutPrintln(br.getString("B1021", string));
        return 0;
    }

    private void handleUserMgrExceptions(UserMgrException userMgrException) {
        Exception exception = userMgrException.getLinkedException();
        String string = userMgrException.getPasswordFile();
        String string2 = userMgrException.getUserName();
        int n = userMgrException.getType();
        switch (n) {
            case 7: {
                Output.stdErrPrintln(br.getString("B3044"), br.getKString("B3046", string));
                break;
            }
            case 8: {
                Output.stdErrPrintln(br.getString("B3044"), br.getKString("B3047", string));
                break;
            }
            case 9: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3048", string2));
                break;
            }
            case 10: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3050", string2));
                break;
            }
            case 11: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3049"));
                break;
            }
            case 12: {
                Output.stdErrPrintln(br.getString("B3044"), br.getKString("B3051", string, exception));
                break;
            }
            case 13: {
                Output.stdErrPrintln(br.getString("B3044"), br.getKString("B3052", string, exception));
                break;
            }
            case 14: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3053"));
                break;
            }
            case 18: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3090"));
                break;
            }
            case 20: {
                Output.stdErrPrintln(br.getString("B3044"), br.getKString("B3118", exception));
                break;
            }
            case 22: {
                Output.stdErrPrintln(br.getString("B3044"), br.getKString("B3158", exception));
            }
        }
    }

    private String getPasswordFromFileOrCmdLine(UserMgrProperties userMgrProperties) throws UserMgrException {
        String string = userMgrProperties.getPassword();
        String string2 = userMgrProperties.getPassfile();
        if (string != null) {
            return string;
        }
        if (string2 != null) {
            String string3 = null;
            try {
                File file = new File(string2);
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                string3 = bufferedReader.readLine();
                bufferedReader.close();
                fileReader.close();
            }
            catch (Exception exception) {
                UserMgrException userMgrException = new UserMgrException(22);
                userMgrException.setProperties(userMgrProperties);
                userMgrException.setLinkedException(exception);
                throw userMgrException;
            }
            return string3;
        }
        return null;
    }
}

