/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.util.CacheHashMap;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class Producer {
    private static boolean DEBUG = false;
    private transient Logger logger = Globals.getLogger();
    private static CacheHashMap cache = new CacheHashMap(20);
    private boolean valid = true;
    private static Map allProducers = Collections.synchronizedMap(new HashMap());
    private ConnectionUID connection_uid;
    private DestinationUID destination_uid;
    private ProducerUID uid = new ProducerUID();
    private long creationTime;
    private int pauseCnt = 0;
    private int resumeCnt = 0;
    private int msgCnt = 0;
    transient String creator = null;

    public String toString() {
        return "Producer[" + this.uid + "," + this.destination_uid + "," + this.connection_uid + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getAllDebugState() {
        Hashtable<String, Hashtable> hashtable;
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        hashtable2.put("TABLE", "AllProducers");
        Vector<String> vector = new Vector<String>();
        HashMap hashMap = cache;
        synchronized (hashMap) {
            hashtable = cache.keySet().iterator();
            while (hashtable.hasNext()) {
                vector.add(String.valueOf(((ProducerUID)hashtable.next()).longValue()));
            }
        }
        hashtable2.put("cache", vector);
        hashMap = null;
        hashtable = allProducers;
        synchronized (hashtable) {
            hashMap = new HashMap(allProducers);
        }
        hashtable = new Hashtable<String, Hashtable>();
        for (ProducerUID producerUID : hashMap.keySet()) {
            Producer producer = (Producer)hashMap.get(producerUID);
            hashtable.put(String.valueOf(producerUID.longValue()), producer.getDebugState());
        }
        hashtable2.put("producersCnt", new Integer(allProducers.size()));
        hashtable2.put("producers", hashtable);
        return hashtable2;
    }

    public synchronized void pause() {
        ++this.pauseCnt;
    }

    public synchronized void addMsg() {
        ++this.msgCnt;
    }

    public synchronized int getMsgCnt() {
        return this.msgCnt;
    }

    public synchronized boolean isPaused() {
        return this.pauseCnt > this.resumeCnt;
    }

    public synchronized void resume() {
        ++this.resumeCnt;
    }

    public Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("TABLE", "Producer[" + this.uid.longValue() + "]");
        hashtable.put("uid", String.valueOf(this.uid.longValue()));
        hashtable.put("valid", String.valueOf(this.valid));
        hashtable.put("pauseCnt", String.valueOf(this.pauseCnt));
        hashtable.put("resumeCnt", String.valueOf(this.resumeCnt));
        if (this.connection_uid != null) {
            hashtable.put("connectionUID", String.valueOf(this.connection_uid.longValue()));
        }
        if (this.destination_uid != null) {
            hashtable.put("destination", this.destination_uid.toString());
        }
        return hashtable;
    }

    private Producer(ConnectionUID connectionUID, DestinationUID destinationUID) {
        this.connection_uid = connectionUID;
        this.destination_uid = destinationUID;
        this.logger.log(4, "Creating new Producer " + this.uid + " on " + destinationUID + " for connection " + connectionUID);
    }

    public ProducerUID getProducerUID() {
        return this.uid;
    }

    public ConnectionUID getConnectionUID() {
        return this.connection_uid;
    }

    public DestinationUID getDestinationUID() {
        return this.destination_uid;
    }

    public static void clearProducers() {
        cache.clear();
        allProducers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkProducer(ProducerUID producerUID) {
        String string = null;
        CacheHashMap cacheHashMap = cache;
        synchronized (cacheHashMap) {
            string = (String)cache.get(producerUID);
        }
        if (string == null) {
            return " pid " + producerUID + " not of of last 20 removed";
        }
        return "Producer[" + producerUID + "]:" + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateProducerInfo(ProducerUID producerUID, String string) {
        CacheHashMap cacheHashMap = cache;
        synchronized (cacheHashMap) {
            cache.put(producerUID, System.currentTimeMillis() + ":" + string);
        }
    }

    public static Iterator getAllProducers() {
        return new ArrayList(allProducers.values()).iterator();
    }

    public static int getNumProducers() {
        return allProducers.size();
    }

    public static Producer getProducer(ProducerUID producerUID) {
        return (Producer)allProducers.get(producerUID);
    }

    public static Producer destroyProducer(ProducerUID producerUID, String string) {
        Producer producer = (Producer)allProducers.remove(producerUID);
        Producer.updateProducerInfo(producerUID, string);
        if (producer == null) {
            return producer;
        }
        Destination destination = Destination.getDestination(producer.getDestinationUID());
        if (destination != null) {
            destination.removeProducer(producerUID);
        }
        producer.destroy();
        return producer;
    }

    public static Producer createProducer(DestinationUID destinationUID, ConnectionUID connectionUID, String string) {
        Producer producer = new Producer(connectionUID, destinationUID);
        Producer producer2 = allProducers.put(producer.getProducerUID(), producer);
        producer.creator = string;
        assert (producer2 == null) : producer2;
        return producer;
    }

    public synchronized void destroy() {
        this.valid = false;
    }

    public synchronized boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Producer getProducer(String string) {
        if (string == null) {
            return null;
        }
        Map map = allProducers;
        synchronized (map) {
            for (Producer producer : allProducers.values()) {
                if (!string.equals(producer.creator)) continue;
                return producer;
            }
        }
        return null;
    }
}

