/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.ClientIDHandler;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.PacketUtil;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.lists.OutOfLimitsException;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;

public class ConsumerHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;
    private static boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn");
    private static boolean DEBUG_CLUSTER_MSG = Globals.getConfig().getBooleanProperty("imq.cluster.debug.msg");
    boolean ALWAYS_WAIT_ON_DESTROY = Globals.getConfig().getBooleanProperty("imq.waitForConsumerDestroy");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Consumer consumer;
        Hashtable<String, Object> hashtable;
        Packet packet2;
        Consumer consumer2;
        Session session;
        boolean bl;
        block82: {
            block81: {
                Object v;
                ConsumerUID consumerUID;
                int n;
                String string;
                Hashtable hashtable2;
                block80: {
                    bl = false;
                    boolean bl2 = false;
                    hashtable2 = null;
                    try {
                        hashtable2 = packet.getProperties();
                    }
                    catch (Exception exception) {
                        this.logger.log(8, "Internal Error: unable to retrieve  properties from consumer message " + packet, exception);
                        hashtable2 = new Hashtable();
                    }
                    Long l = (Long)hashtable2.get("JMQSessionID");
                    session = null;
                    string = null;
                    Boolean bl3 = (Boolean)hashtable2.get("JMQBlock");
                    consumer2 = null;
                    assert (bl3 == null || packet.getPacketType() == 16) : packet;
                    boolean bl4 = bl3 != null && bl3 != false;
                    boolean bl5 = packet.getIndempontent();
                    packet2 = new Packet(iMQConnection.useDirectBuffers());
                    packet2.setConsumerID(packet.getConsumerID());
                    hashtable = new Hashtable<String, Object>();
                    packet2.setPacketType(packet.getPacketType() + 1);
                    n = 200;
                    String string2 = "B2009";
                    consumerUID = null;
                    v = null;
                    Integer n2 = null;
                    consumer = null;
                    try {
                        Boolean bl6;
                        boolean bl7;
                        Serializable serializable;
                        iMQConnection.suspend();
                        bl2 = true;
                        if (packet.getPacketType() == 14) {
                            Object object;
                            int n3;
                            Serializable serializable2;
                            if (DEBUG) {
                                this.logger.log(1, "ConsumerHandler: handle() [ Received AddConsumer message {0}]", packet.toString());
                            }
                            packet2.setPacketType(15);
                            if (l == null) {
                                if (DEBUG) {
                                    this.logger.log(4, "not Raptor consumer packet (no session id)");
                                }
                                if ((session = iMQConnection.getSession((SessionUID)(serializable2 = new SessionUID(iMQConnection.getConnectionUID().longValue())))) == null) {
                                    session = Session.createSession((SessionUID)serializable2, iMQConnection.getConnectionUID(), null);
                                    iMQConnection.attachSession(session);
                                }
                            } else {
                                serializable2 = new SessionUID(l);
                                session = iMQConnection.getSession((SessionUID)serializable2);
                                if (session == null) {
                                    throw new BrokerException("Internal Error: client set invalid sessionUID " + serializable2 + " session does not exist");
                                }
                            }
                            if (bl4) {
                                session.pause("Consumer - Block flag");
                                bl = true;
                            }
                            if ((n2 = (Integer)hashtable2.get("JMQConsumerID")) != null) {
                                hashtable.put("JMQOldConsumerID", n2);
                            }
                            if (hashtable2 == null) {
                                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "no properties in addConsumer packet - client does not match protocol"));
                            }
                            serializable2 = (Integer)hashtable2.get("JMQDestType");
                            int n4 = n3 = serializable2 == null ? -1 : (Integer)serializable2;
                            if (n3 == -1) {
                                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Client is not sending DestType, unable to add interest"));
                            }
                            boolean bl8 = DestType.isQueue(n3);
                            String string3 = (String)hashtable2.get("JMQDestination");
                            String string4 = (String)hashtable2.get("JMQSelector");
                            Boolean bl9 = (Boolean)hashtable2.get("JMQNoLocal");
                            String string5 = (String)hashtable2.get("JMQDurableName");
                            String string6 = this.getClientID(hashtable2, iMQConnection);
                            Boolean bl10 = (Boolean)hashtable2.get("JMQReconnect");
                            Boolean bl11 = (Boolean)hashtable2.get("JMQShare");
                            Integer n5 = (Integer)hashtable2.get("JMQSize");
                            if (bl8 && bl9 != null && bl9.booleanValue()) {
                                Globals.getLogger().log(32, "B3100", "NoLocal is not supported on Queue Receivers");
                                throw new BrokerException("Unsupported property on queues JMQNoLocal is set to " + bl9, 500);
                            }
                            if (bl10 != null && bl10.booleanValue()) {
                                Globals.getLogger().log(32, "B3100", "JMQReconnect not implemented");
                            }
                            if (bl11 != null && bl11.booleanValue() && !ClientIDHandler.CAN_USE_SHARED_CONSUMERS) {
                                throw new BrokerException(Globals.getBrokerResources().getKString("B4180", Globals.getBrokerResources().getKString("B0072"), string3), "B4180", null, 405);
                            }
                            Destination destination = null;
                            while (true) {
                                if ((destination = Destination.getDestination(string3, n3, true, !iMQConnection.isAdminConnection())).isAutoCreated()) {
                                    string2 = "B2106";
                                }
                                try {
                                    if (destination == null) break;
                                    destination.incrementRefCount();
                                }
                                catch (BrokerException brokerException) {
                                    continue;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw new BrokerException(Globals.getBrokerResources().getKString("B4140"), "B4140", illegalStateException, 500);
                                }
                                break;
                            }
                            if (destination == null) {
                                n = 404;
                                throw new BrokerException(Globals.getBrokerResources().getKString("B4017", string3), "B4017", null, 404);
                            }
                            if (string5 != null && string6 == null) {
                                throw new BrokerException(Globals.getBrokerResources().getKString("B4135", string5), "B4135", null, 412);
                            }
                            DestinationUID destinationUID = destination.getDestinationUID();
                            Consumer consumer3 = null;
                            try {
                                object = this.createConsumer(destination, iMQConnection, session, string4, string6, string5, bl9 != null && bl9 != false, n5 == null ? -1 : n5, bl11 != null && bl11 != false, packet.getSysMessageID().toString(), bl5);
                                consumer3 = object[0];
                                consumer2 = object[1];
                                consumer = (Subscription)object[2];
                                if (consumer3.getPrefetch() != -1 || n5 != null) {
                                    hashtable.put("JMQSize", consumer3.getPrefetch());
                                }
                            }
                            catch (SelectorFormatException selectorFormatException) {
                                throw new BrokerException(Globals.getBrokerResources().getKString("B2016", string4), "B2016", selectorFormatException, 400);
                            }
                            catch (OutOfLimitsException outOfLimitsException) {
                                if (destination.isQueue()) {
                                    Object[] objectArray = new String[]{destination.getDestinationUID().getName(), String.valueOf(destination.getActiveConsumerCount()), String.valueOf(destination.getFailoverConsumerCount())};
                                    throw new BrokerException(Globals.getBrokerResources().getKString("B4006", objectArray), "B4006", outOfLimitsException, 409);
                                }
                                Object[] objectArray = new String[]{destination.getDestinationUID().getName(), string5, string6, String.valueOf(outOfLimitsException.getLimit())};
                                throw new BrokerException(Globals.getBrokerResources().getKString("B4186", objectArray), "B4186", outOfLimitsException, 409);
                            }
                            finally {
                                if (destination != null) {
                                    destination.decrementRefCount();
                                }
                            }
                            object = (Integer)hashtable2.get("JMQAckMode");
                            if (object != null) {
                                consumer3.getConsumerUID().setAckType((Integer)object);
                            }
                            consumerUID = consumer3.getConsumerUID();
                            break block80;
                        }
                        if (DEBUG) {
                            this.logger.log(1, "ConsumerHandler: handle() [ Received DestroyConsumer message {0}]", packet.toString());
                        }
                        string2 = "B2010";
                        packet2.setPacketType(17);
                        String string7 = (String)hashtable2.get("JMQDurableName");
                        String string8 = this.getClientID(hashtable2, iMQConnection);
                        Long l2 = (Long)hashtable2.get("JMQConsumerID");
                        ConsumerUID consumerUID2 = consumerUID = l2 == null ? null : new ConsumerUID(l2);
                        if (l != null) {
                            serializable = new SessionUID(l);
                            session = iMQConnection.getSession((SessionUID)serializable);
                        } else {
                            session = Session.getSession(consumerUID);
                        }
                        if (session == null && string7 == null && !bl5 && iMQConnection.getConnectionState() < 6) {
                            this.logger.log(32, "Internal error processing delete consumer\n" + PacketUtil.dumpPacket(packet));
                            Session.dumpAll();
                        }
                        int n6 = (serializable = (Integer)hashtable2.get("JMQBodyType")) == null ? 0 : (Integer)serializable;
                        SysMessageID sysMessageID = null;
                        if (n6 == 3) {
                            int n7 = packet.getMessageBodySize();
                            if (n7 == 0) {
                                this.logger.log(8, "Warning, bad body in destroy consumer");
                            } else {
                                DataInputStream dataInputStream = new DataInputStream(packet.getMessageBodyStream());
                                sysMessageID = new SysMessageID();
                                sysMessageID.readID(dataInputStream);
                            }
                        }
                        if (DEBUG && sysMessageID != null) {
                            this.logger.log(4, "Sent lastID [" + sysMessageID + "]" + " for consumer " + consumerUID + Destination.get(sysMessageID));
                        }
                        boolean bl12 = bl7 = (bl6 = (Boolean)hashtable2.get("JMQRedeliverAll")) == null ? false : bl6;
                        if (!bl && session != null) {
                            bl = true;
                            session.pause("Consumer removeconsumer");
                        }
                        this.destroyConsumer(iMQConnection, session, consumerUID, string7, string8, sysMessageID, bl7, bl5);
                    }
                    catch (BrokerException brokerException) {
                        n = brokerException.getStatusCode();
                        String string9 = null;
                        String string10 = null;
                        try {
                            string10 = (String)hashtable2.get("JMQDestination");
                            if (string10 == null && packet.getPacketType() != 14) {
                                string10 = "";
                            }
                            string9 = n2 != null ? n2.toString() : "";
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Object[] objectArray = new String[]{string9, iMQConnection.getRemoteConnectionString(), string10};
                        string = brokerException.getMessage();
                        if (brokerException.getStatusCode() == 412 || brokerException.getStatusCode() == 409) {
                            this.logger.log(16, string2, objectArray, (Throwable)brokerException);
                        } else if (brokerException.getStatusCode() == 400) {
                            this.logger.log(16, string2, objectArray, (Throwable)brokerException);
                            if (brokerException.getCause() != null) {
                                this.logger.log(8, brokerException.getCause().toString());
                            }
                        } else if (bl5 && packet.getPacketType() == 16) {
                            this.logger.logStack(4, "Reprocessing Indempotent message for {0} on destination {2} from {1}", objectArray, (Throwable)brokerException);
                            n = 200;
                            string = null;
                        } else {
                            this.logger.logStack(16, string2, objectArray, (Throwable)brokerException);
                        }
                    }
                    catch (IOException iOException) {
                        this.logger.log(8, "Internal Error: unable to process  consumer request " + packet, iOException);
                        hashtable2 = new Hashtable();
                        string = iOException.getMessage();
                        assert (false);
                    }
                    catch (SecurityException securityException) {
                        n = 403;
                        string = securityException.getMessage();
                        String string11 = null;
                        String string12 = null;
                        try {
                            string11 = (String)hashtable2.get("JMQDestination");
                            if (n2 != null) {
                                string12 = n2.toString();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.logger.log(16, string2, string11, string12, securityException);
                    }
                    finally {
                        if (bl2) {
                            iMQConnection.resume();
                        }
                    }
                }
                hashtable.put("JMQStatus", new Integer(n));
                if (string != null) {
                    hashtable.put("JMQReason", string);
                }
                if (consumerUID != null) {
                    hashtable.put("JMQConsumerID", new Long(consumerUID.longValue()));
                    if ((DEBUG || this.logger.getLevel() <= 4) && hashtable2.get("JMQOldConsumerID") != null) {
                        this.logger.log(8, "Consumer " + consumerUID + ", JMQOldConsumerID:" + hashtable2.get("JMQOldConsumerID"));
                    }
                }
                if (v != null) {
                    hashtable.put("JMQDestType", v);
                }
                IMQIPConnection cfr_ignored_0 = (IMQIPConnection)iMQConnection;
                if (IMQIPConnection.getDumpPacket()) break block81;
                IMQIPConnection cfr_ignored_1 = (IMQIPConnection)iMQConnection;
                if (!IMQIPConnection.getDumpOutPacket()) break block82;
            }
            hashtable.put("JMQReqID", packet.getSysMessageID().toString());
        }
        packet2.setProperties(hashtable);
        iMQConnection.sendControlMessage(packet2);
        if (bl) {
            session.resume("Consumer - session was paused");
        }
        if (consumer2 != null) {
            consumer2.resume("Consumer - new consumer");
        }
        if (consumer != null) {
            consumer.resume("Consumer - added to sub");
        }
        return true;
    }

    public String getClientID(Hashtable hashtable, Connection connection) {
        String string = (String)connection.getClientData("client id");
        if (string == null && (string = (String)hashtable.get("JMQClientID")) != null) {
            this.logger.log(32, "B3100", "client did not send setCLIENTID method before adding/removing a consumer, retrieved clientid " + string + " from packet properties");
        }
        return string;
    }

    public void destroyConsumer(Connection connection, Session session, ConsumerUID consumerUID, String string, String string2, SysMessageID sysMessageID, boolean bl, boolean bl2) throws BrokerException {
        if (string != null) {
            Subscription subscription = Subscription.unsubscribe(string, string2);
            if (subscription == null) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4058", string, string2), 404);
            }
            DestinationUID destinationUID = subscription.getDestinationUID();
            Destination destination = Destination.getDestination(destinationUID);
            assert (destination != null);
            if (destination != null) {
                destination.removeConsumer(consumerUID, true);
            }
        } else {
            Consumer consumer;
            DestinationUID destinationUID;
            Destination destination;
            boolean bl3 = false;
            if (connection.getClientProtocolVersion() < 350) {
                bl3 = true;
            }
            if (session == null && !bl2) {
                if (connection.getConnectionState() >= 6) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4274", connection.getConnectionUID()), 404);
                }
                assert (session != null);
                throw new BrokerException(Globals.getBrokerResources().getKString("B4275", consumerUID, connection.getConnectionUID()), 404);
            }
            if (session != null && (destination = Destination.getDestination(destinationUID = (consumer = session.detatchConsumer(consumerUID, sysMessageID, bl3, bl)).getDestinationUID())) != null) {
                destination.removeConsumer(consumerUID, true);
            }
        }
    }

    public Consumer[] createConsumer(Destination destination, Connection connection, Session session, String string, String string2, String string3, boolean bl, int n, boolean bl2, String string4, boolean bl3) throws BrokerException, SelectorFormatException, IOException {
        Consumer consumer = null;
        Consumer consumer2 = null;
        Subscription subscription = null;
        DestinationUID destinationUID = destination.getDestinationUID();
        int n2 = -1;
        if (bl3 && (consumer = Consumer.getConsumer(string4)) != null) {
            n2 = consumer.getPrefetch();
        }
        if (consumer == null) {
            int n3;
            consumer = new Consumer(destinationUID, string, bl, connection.getConnectionUID());
            consumer.setCreator(string4);
            consumer2 = consumer;
            consumer2.pause("Consumer: new consumer");
            int n4 = n;
            int n5 = n3 = !bl2 ? destination.getMaxPrefetch() : destination.getSharedConsumerFlowLimit();
            n2 = n3 == -1 ? n4 : (n4 == -1 ? n4 : (n4 > n3 ? n3 : n4));
            consumer.setPrefetch(n2);
            if (string3 != null) {
                subscription = Subscription.findCreateDurableSubscription(string2, string3, destinationUID, string, bl, true);
                subscription.pause("Consumer attaching to durable");
                subscription.setShared(bl2);
                subscription.attachConsumer(consumer);
                Subscription subscription2 = (Subscription)destination.addConsumer(subscription, true);
                if (subscription2 != null) {
                    subscription2.purge();
                }
                subscription.sendCreateSubscriptionNotification(consumer);
            } else if (!destination.isQueue() && bl2) {
                if (string2 == null) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4135", string3), "B4135", null, 412);
                }
                this.logger.log(4, "Creating shared non-durable " + consumer);
                subscription = Subscription.createAttachNonDurableSub(consumer, connection);
                if (subscription != null) {
                    subscription.pause("Consumer: attaching to nondurable");
                    subscription.setShared(true);
                    destination.addConsumer(subscription, true);
                }
                consumer.attachToConnection(connection.getConnectionUID());
                if (subscription != null) {
                    subscription.sendCreateSubscriptionNotification(consumer);
                }
            } else {
                destination.addConsumer(consumer, true);
                consumer.attachToConnection(connection.getConnectionUID());
                consumer.sendCreateConsumerNotification();
            }
        }
        session.attachConsumer(consumer);
        Consumer[] consumerArray = new Consumer[]{consumer, consumer2, subscription};
        return consumerArray;
    }

    static {
        if (!DEBUG) {
            DEBUG = DEBUG_CLUSTER_TXN || DEBUG_CLUSTER_MSG;
        }
    }
}

