/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class ConsumerDAOImpl
extends BaseDAOImpl
implements ConsumerDAO {
    protected String tableName;
    protected String insertSQL;
    protected String deleteSQL;
    protected String selectSQL;
    protected String selectAllSQL;
    protected String selectExistSQL;
    protected String selectExistByIDSQL;

    ConsumerDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQCON41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("CONSUMER").append(", ").append("DURABLE_NAME").append(", ").append("CLIENT_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ? )").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectSQL = new StringBuffer(128).append("SELECT ").append("CONSUMER").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT ").append("CONSUMER").append(" FROM ").append(this.tableName).toString();
        this.selectExistSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("DURABLE_NAME").append(" = ?").append(" AND ").append("CLIENT_ID").append(" = ?").toString();
        this.selectExistByIDSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
    }

    public final String getTableNamePrefix() {
        return "MQCON41";
    }

    public String getTableName() {
        return this.tableName;
    }

    public void insert(Connection connection, Consumer consumer, long l) throws BrokerException {
        block14: {
            PreparedStatement preparedStatement;
            block13: {
                ConsumerUID consumerUID = consumer.getConsumerUID();
                String string = null;
                String string2 = null;
                if (consumer instanceof Subscription) {
                    Subscription subscription = (Subscription)consumer;
                    string = subscription.getDurableName();
                    string2 = subscription.getClientID();
                }
                boolean bl = false;
                preparedStatement = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    if (this.checkConsumer(connection, consumer)) {
                        throw new BrokerException(this.br.getKString("B3010", consumerUID));
                    }
                    preparedStatement = connection.prepareStatement(this.insertSQL);
                    preparedStatement.setLong(1, consumerUID.longValue());
                    Util.setObject(preparedStatement, 2, consumer);
                    Util.setString(preparedStatement, 3, string);
                    Util.setString(preparedStatement, 4, string2);
                    preparedStatement.setLong(5, l);
                    preparedStatement.executeUpdate();
                    if (!bl) break block13;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + this.insertSQL + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception) : exception);
                        throw new BrokerException(this.br.getKString("B4012", consumerUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block14;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void delete(Connection connection, Consumer consumer) throws BrokerException {
        ConsumerUID consumerUID = consumer.getConsumerUID();
        boolean bl = false;
        boolean bl2 = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl2 = true;
            }
            preparedStatement = connection.prepareStatement(this.deleteSQL);
            preparedStatement.setLong(1, consumerUID.longValue());
            if (preparedStatement.executeUpdate() > 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4034", consumerUID), exception2);
        }
        finally {
            if (bl2) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
        if (!bl) {
            DestinationUID destinationUID = consumer.getDestinationUID();
            throw new BrokerException(this.br.getKString("B3011", consumerUID, destinationUID), 404);
        }
    }

    public void deleteAll(Connection connection) throws BrokerException {
        if (Globals.getHAEnabled()) {
            return;
        }
        super.deleteAll(connection);
    }

    public Consumer getConsumer(Connection connection, ConsumerUID consumerUID) throws BrokerException {
        Consumer consumer;
        block12: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block11: {
                consumer = null;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSQL);
                    preparedStatement.setLong(1, consumerUID.longValue());
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        try {
                            consumer = (Consumer)Util.readObject(resultSet, 1);
                        }
                        catch (IOException iOException) {
                            this.logger.logStack(32, "B4125", iOException);
                        }
                    }
                    if (!bl) break block11;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4013", consumerUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block12;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return consumer;
    }

    public List getAllConsumers(Connection connection) throws BrokerException {
        ArrayList<Consumer> arrayList;
        block12: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block11: {
                arrayList = new ArrayList<Consumer>();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        try {
                            Consumer consumer = (Consumer)Util.readObject(resultSet, 1);
                            arrayList.add(consumer);
                        }
                        catch (IOException iOException) {
                            this.logger.logStack(32, "B4125", iOException);
                        }
                    }
                    if (!bl) break block11;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4035"), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block12;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return arrayList;
    }

    public boolean checkConsumer(Connection connection, Consumer consumer) throws BrokerException {
        boolean bl;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                bl = false;
                ConsumerUID consumerUID = consumer.getConsumerUID();
                boolean bl2 = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl2 = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectExistByIDSQL);
                    preparedStatement.setLong(1, consumerUID.longValue());
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        bl = true;
                    }
                    if (!bl2) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectExistByIDSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4013", consumerUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl2) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return bl;
    }

    public HashMap getDebugInfo(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = -1;
        try {
            n = this.getRowCount(null, null);
        }
        catch (Exception exception) {
            this.logger.log(32, exception.getMessage(), exception.getCause());
        }
        hashMap.put("Consumers(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }
}

