/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.VersionDAO;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

class VersionDAOImpl
extends BaseDAOImpl
implements VersionDAO {
    protected String tableName;
    protected String insertSQL;
    protected String updateLockSQL;
    protected String updateLockByLockIDSQL;
    protected String selectStoreVersionSQL;
    protected String selectLockSQL;
    protected String selectAllSQL;

    VersionDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQVER41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("STORE_VERSION").append(") VALUES ( ? )").toString();
        this.updateLockSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("LOCK_ID").append(" = ?").append(" WHERE ").append("STORE_VERSION").append(" = ? AND ").append("LOCK_ID").append(" IS NULL").toString();
        this.updateLockByLockIDSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("LOCK_ID").append(" = ?").append(" WHERE ").append("STORE_VERSION").append(" = ? AND ").append("LOCK_ID").append(" = ?").toString();
        this.selectStoreVersionSQL = new StringBuffer(128).append("SELECT ").append("STORE_VERSION").append(" FROM ").append(this.tableName).toString();
        this.selectLockSQL = new StringBuffer(128).append("SELECT ").append("LOCK_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("STORE_VERSION").append(" = ?").toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT ").append("LOCK_ID").append(", ").append("STORE_VERSION").append(" FROM ").append(this.tableName).toString();
    }

    public final String getTableNamePrefix() {
        return "MQVER41";
    }

    public final String getTableName() {
        return this.tableName;
    }

    public void insert(Connection connection, int n) throws BrokerException {
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.insertSQL);
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4238", this.tableName), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
    }

    public boolean updateLock(Connection connection, int n, String string, String string2) throws BrokerException {
        boolean bl;
        block15: {
            PreparedStatement preparedStatement;
            block14: {
                bl = false;
                boolean bl2 = false;
                String string3 = null;
                preparedStatement = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl2 = true;
                    }
                    if (string2 == null) {
                        string3 = this.updateLockSQL;
                        preparedStatement = connection.prepareStatement(string3);
                        Util.setString(preparedStatement, 1, string);
                        preparedStatement.setInt(2, n);
                    } else {
                        string3 = this.updateLockByLockIDSQL;
                        preparedStatement = connection.prepareStatement(string3);
                        Util.setString(preparedStatement, 1, string);
                        preparedStatement.setInt(2, n);
                        preparedStatement.setString(3, string2);
                    }
                    if (preparedStatement.executeUpdate() > 0) {
                        bl = true;
                    }
                    if (!bl2) break block14;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + string3 + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B3184"), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl2) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block15;
            }
            Util.close(null, preparedStatement, null);
        }
        return bl;
    }

    public void deleteAll(Connection connection) throws BrokerException {
        if (Globals.getHAEnabled()) {
            return;
        }
        super.deleteAll(connection);
    }

    public int getStoreVersion(Connection connection) throws BrokerException {
        int n;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                n = -1;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    if ((resultSet = (preparedStatement = connection.prepareStatement(this.selectStoreVersionSQL)).executeQuery()).next()) {
                        n = resultSet.getInt("STORE_VERSION");
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectStoreVersionSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4239", this.tableName), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return n;
    }

    public String getLock(Connection connection, int n) throws BrokerException {
        String string;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                string = null;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectLockSQL);
                    preparedStatement.setInt(1, n);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next() && (string = resultSet.getString(1)) == null) {
                        string = "";
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectLockSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4239", this.tableName), exception2, 404);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public HashMap getDebugInfo(Connection connection) {
        StringBuffer stringBuffer;
        HashMap<String, String> hashMap;
        block16: {
            hashMap = new HashMap<String, String>();
            stringBuffer = new StringBuffer(256);
            boolean bl = false;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.selectAllSQL);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                stringBuffer.append("(").append("STORE_VERSION").append("=").append(resultSet.getString("STORE_VERSION")).append(", ").append("LOCK_ID").append("=").append(resultSet.getString("LOCK_ID")).append(")").append(BrokerResources.NL);
            }
            try {
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    break block16;
                }
                Util.close(resultSet, preparedStatement, null);
            }
            catch (BrokerException brokerException) {
                this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
            }
            break block16;
            catch (Exception exception) {
                try {
                    this.logger.log(32, "B4166", (Object)this.selectAllSQL, (Throwable)exception);
                }
                catch (Throwable throwable) {
                    try {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                    }
                    catch (BrokerException brokerException) {
                        this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
                    }
                    throw throwable;
                }
                try {
                    if (bl) {
                        Util.close(resultSet, preparedStatement, connection);
                    }
                    Util.close(resultSet, preparedStatement, null);
                }
                catch (BrokerException brokerException) {
                    this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
                }
            }
        }
        hashMap.put("Version(" + this.tableName + ")", stringBuffer.toString());
        return hashMap;
    }
}

