/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2007 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)TopicSessionImpl.java	1.26 06/27/07
 */ 

package com.sun.messaging.jmq.jmsclient;

import javax.jms.*;

import com.sun.messaging.AdministeredObject;

/** A TopicSession provides methods for creating TopicPublisher's,
  * TopicSubscriber's and TemporaryTopics. It also provides a method for
  * deleting its client's durable subscribers.
  *
  * @see         javax.jms.Session
  * @see	 javax.jms.TopicConnection#createTopicSession(boolean, int)
  * @see         javax.jms.XATopicSession#getTopicSession()
  */

public class TopicSessionImpl extends UnifiedSessionImpl implements TopicSession {

    public TopicSessionImpl (ConnectionImpl connection, boolean transacted, int ackMode) throws JMSException {
        super (connection, transacted, ackMode);
    }

    public TopicSessionImpl (ConnectionImpl connection, int ackMode)
        throws JMSException {
        super (connection, ackMode);
    }

    /**
    * Throws an IllegalStateException as it is an invalid method for this domain.
    *
    * @param queueName the name of this queue
    *
    * @return a Queue with the given name.
    *
    * @exception IllegalStateException Always, since it is an invalid method for
    *            this domain.
    */
    public Queue createQueue(String queueName) throws JMSException {

        String errorString = AdministeredObject.cr.getKString(AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN,
                                                              "createQueue");
        throw new javax.jms.IllegalStateException(errorString, AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN);
    }

    /**
    * Throws an IllegalStateException as it is an invalid method for this domain.
    *
    * @return a temporary queue identity
    *
    * @exception IllegalStateException Always, since it is an invalid method for
    *            this domain.
    */
    public TemporaryQueue
    createTemporaryQueue() throws JMSException {

        String errorString = AdministeredObject.cr.getKString(AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN,
                                                              "createTemporaryQueue");
        throw new javax.jms.IllegalStateException(errorString, AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN);
    }

    /**
    * Throws an IllegalStateException as it is an invalid method for this domain.
    *
    * @param queue the queue to access
    *
    * @exception IllegalStateException Always, since it is an invalid method for
    *            this domain.
    */
    public QueueBrowser
    createBrowser(Queue queue) throws JMSException {

        String errorString = AdministeredObject.cr.getKString(AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN,
                                                              "createBrowser");
        throw new javax.jms.IllegalStateException(errorString, AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN);
    }

    /**
    * Throws an IllegalStateException as it is an invalid method for this domain.
    *
    * @param queue the queue to access
    * @param selector the selector to use
    *
    * @exception IllegalStateException Always, since it is an invalid method for
    *            this domain.
    */
    public QueueBrowser
    createBrowser(Queue queue, String selector) throws JMSException {
        String errorString = AdministeredObject.cr.getKString(AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN,
                                                              "createBrowser");
        throw new javax.jms.IllegalStateException(errorString, AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN);
    }
}
