/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2007 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)BrokerAddressListChangedEvent.java	1.3 06/27/07
 */ 

package com.sun.messaging.jmq.jmsclient.notification;

import com.sun.messaging.jms.Connection;
import com.sun.messaging.jms.notification.ConnectionEvent;
import com.sun.messaging.jmq.jmsclient.resources.ClientResources;

/**
 * MQ Connection exit Event.
 *
 * <p>This event is used by MQ client runtime only.  This event is not
 * delivered to the application.
 *
 * <p>This event is generated by MQ client runtime and delivered to
 * the EventHandler.  When EventHandler receives this event, it calls the
 * Connection Exception Listener, and then closes the handler.
 */
public class BrokerAddressListChangedEvent extends ConnectionEvent {

    private String addrList = null;

    /**
     *
     */
    public static final String CONNECTION_ADDRESS_LIST_CHANGED =
        ClientResources.E_CONNECTION_ADDRESS_LIST_CHANGED;

    /**
     * Construct a connection ADDRESS LIST CHANGED event.
     *
     * @param conn the connection that the event is associated with.
     *             MQ may automatically reconnect to the same broker
     *             or a different broker depends on the client runtime
     *             configuration.
     * @param evCode the event code that represents this event object.
     * @param evMessage the event message that describes this event object.
     * @param jmse the JMSException that caused this event.
     */
    public BrokerAddressListChangedEvent
        (Connection conn, String evCode, String evMessage, String addrList) {

        super (conn, evCode, evMessage);

        this.addrList = addrList;
    }

    public String getAddressList() {
        return this.addrList;
    }

}
