/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2007 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)DestLimitBehavior.java	1.4 06/29/07
 */ 

package com.sun.messaging.jmq.util;


/**
 * Limiting behavior used by the destination when it 
 * becomes full.
 * <P>
 * <B>XXX</B> How should serialization be handled.
 */

public class DestLimitBehavior 
{
    public static final int UNKNOWN = -1;
    public static final int FLOW_CONTROL = 0;
    public static final int REMOVE_OLDEST = 1;
    public static final int REJECT_NEWEST = 2;
    public static final int REMOVE_LOW_PRIORITY = 3;

    public static int getStateFromString(String str) {
        if (str.equals("FLOW_CONTROL")) 
            return FLOW_CONTROL;
        if (str.equals("REMOVE_OLDEST")) 
            return REMOVE_OLDEST;
        if (str.equals("REJECT_NEWEST") )
            return REJECT_NEWEST;
        if (str.equals("REMOVE_LOW_PRIORITY")) 
            return REMOVE_LOW_PRIORITY;
        return UNKNOWN;
    }


    public static String getString(int state)
    {
        switch (state) {
            case FLOW_CONTROL:
                return "FLOW_CONTROL";

            case REMOVE_OLDEST:
                return "REMOVE_OLDEST";

            case REJECT_NEWEST:
                return "REJECT_NEWEST";

            case REMOVE_LOW_PRIORITY:
                return "REMOVE_LOW_PRIORITY";

        }
        return "UNKNOWN";

    }
}
