/*
 *  DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 *  Copyright 2000-2007 Sun Microsystems, Inc. All rights reserved. 
 *
 *  The contents of this file are subject to the terms of either the GNU
 *  General Public License Version 2 only ("GPL") or the Common Development
 *  and Distribution License ("CDDL") (collectively, the "License").  You may
 *  not use this file except in compliance with the License.  You can obtain
 *  a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 *  or mq/legal/LICENSE.txt.  See the License for the specific language
 *  governing permissions and limitations under the License.
 * 
 *  When distributing the software, include this License Header Notice in each
 *  file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 *  this particular file as subject to the "Classpath" exception as provided by
 *  Sun in the GPL Version 2 section of the License file that accompanied this
 *  code.  If applicable, add the following below the License Header, with the
 *  fields enclosed by brackets [] replaced by your own identifying information:
 *  "Portions Copyrighted [year] [name of copyright owner]"
 * 
 *  Contributor(s):
 * 
 *  If you wish your version of this file to be governed by only the CDDL or
 *  only the GPL Version 2, indicate your decision by adding "[Contributor]
 *  elects to include this software in this distribution under the [CDDL or GPL
 *  Version 2] license."  If you don't indicate a single choice of license, a
 *  recipient has the option to distribute your version of this file under
 *  either the CDDL, the GPL Version 2 or  to extend the choice of license to
 *  its licensees as provided above.  However, if you add GPL Version 2 code
 *  and therefore, elected the GPL Version 2 license, then the option applies
 *  only if the new code is made subject to such option by the copyright holder. 
 *
 *  DirectLocalTransaction.java
 *
 *  @(#)DirectLocalTransaction.java	1.2 07/12/07
 */

package com.sun.messaging.jms.ra;

import javax.jms.*;

import javax.resource.*;
import javax.resource.spi.*;

import java.util.Vector;
import java.util.logging.Logger;

import com.sun.messaging.jmq.jmsclient.ConnectionImpl;


/**
 *  Implements the LocalTransaction interface in DIRECT mode for the Sun MQ RA
 *
 *  @author tharakan
 */

public class DirectLocalTransaction
implements javax.resource.spi.LocalTransaction
{
    /** The connection event listener list */
    //private Vector listeners = null;

    /** The ManagedConnection associated with this LocalTransaction */
    private com.sun.messaging.jms.ra.ManagedConnection mc = null;
    private DirectConnection dc = null;

    private long transactionID = -1L;
 
    protected boolean started = false;
    protected boolean active = false;
 


    /** Constructor */
    public DirectLocalTransaction(com.sun.messaging.jms.ra.ManagedConnection mc,
            DirectConnection dc)
    {
        //System.out.println("MQRA:LT:Constr");
        this.mc = mc;
        this.dc = dc;
    }

    /** Begin a local transaction */
    public synchronized void
    begin()
    throws ResourceException
    {
        //System.out.println("MQRA:LT:begin()");
        try {
            if (!dc.isClosed()) {
                transactionID = this.dc._startTransaction("DirectLocalTransaction.begin()");
            } else {
                ResourceException re = new EISSystemException("MQRA:LT:startTransaction exception:Connection is closed");
                throw re;
            }
            //mc.getConnectionAdapter().getSessionAdapter().startLocalTransaction();
        } catch (Exception ex) {
            ResourceException re = new EISSystemException("MQRA:LT:startTransaction exception:"+
                ex.getMessage());
            re.initCause(ex);
            throw re;
        }
        started = true;
        active = true;
        mc.setLTActive(true);
    }

    /** Commit a local transaction */
    public synchronized void
    commit()
    throws ResourceException
    {
        //System.out.println("MQRA:LT:commit()");
        try {
            if (!dc.isClosed()) {
                this.dc._commitTransaction("DirectLocalTransaction.commit()",
                        this.transactionID);
            } else {
                ResourceException re = new EISSystemException("MQRA:LT:commitTransaction exception:Connection is closed");
                throw re;
            }
        } catch (Exception ex) {
            ResourceException re = new EISSystemException("MQRA:LT:commit exception:"+
                ex.getMessage());
            re.initCause(ex);
            throw re;
        } finally {
            mc.setLTActive(false);
            started = false;
            active = false;
        }
    }

    /** Rollback a local transaction */
    public synchronized void
    rollback()
    throws ResourceException
    {
        //System.out.println("MQRA:LT:rollback()");
        try {
            if (!dc.isClosed()) {
                this.dc._rollbackTransaction("DirectLocalTransaction.rollback()",
                        this.transactionID);
            } else {
                ResourceException re = new EISSystemException("MQRA:LT:rillbackTransaction exception:Connection is closed");
                throw re;
            }
        } catch (Exception ex) {
            ResourceException re = new EISSystemException("MQRA:LT:rollback exception:"+
                ex.getMessage());
            re.initCause(ex);
            throw re;
        } finally {
            mc.setLTActive(false);
            started = false;
            active = false;
        }
    }

    public synchronized long getTransactionID() {
        return transactionID;
    }

    public boolean started() {
        return started;
    }

    public boolean isActive() {
        return active;
    }
}

