/*******************************************************************************
  
  Copyright(c) 2004 Intel Corporation. All rights reserved.

  Portions of this file are based on the WEP enablement code provided by the
  Host AP project hostap-drivers v0.1.3
  Copyright (c) 2001-2002, SSH Communications Security Corp and Jouni Malinen
  <jkmaline@cc.hut.fi>
  Copyright (c) 2002-2003, Jouni Malinen <jkmaline@cc.hut.fi>
  
  This program is free software; you can redistribute it and/or modify it 
  under the terms of version 2 of the GNU General Public License as 
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but WITHOUT 
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
  more details.
  
  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
  The full GNU General Public License is included in this distribution in the
  file called LICENSE.
  
  Contact Information:
  James P. Ketrenos <ipw2100-admin@linux.intel.com>
  Intel Corporation, 5200 N.E. Elam Young Parkway, Hillsboro, OR 97124-6497

*******************************************************************************/

#include <linux/compiler.h>
#include <linux/config.h>
#include <linux/errno.h>
#include <linux/if_arp.h>
#include <linux/in6.h>
#include <linux/in.h>
#include <linux/ip.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/netdevice.h>
#include <linux/pci.h>
#include <linux/proc_fs.h>
#include <linux/skbuff.h>
#include <linux/slab.h>
#include <linux/tcp.h>
#include <linux/types.h>
#include <linux/version.h>
#include <linux/wireless.h>
#include <linux/etherdevice.h>
#include <asm/uaccess.h>

#include "ieee80211.h"

MODULE_DESCRIPTION("802.11 data/management/control stack");
MODULE_AUTHOR("Copyright (C) 2004 Intel Corporation <jketreno@linux.intel.com>");
MODULE_LICENSE("GPL");

#ifdef CONFIG_IEEE80211_DEBUG
u32 ieee80211_debug_level = 0;
#endif

static inline int ieee80211_beacons_allocate(struct ieee80211_device *ieee)
{
	if (ieee->beacons)
		return 0;

	ieee->beacons = kmalloc(
		MAX_BEACON_COUNT * sizeof(struct ieee80211_beacon),
		GFP_KERNEL);
	if (!ieee->beacons) {
		printk(KERN_WARNING "%s: Out of memory allocating beacons\n",
		       ieee->dev->name);
		return -ENOMEM;
	}

	memset(ieee->beacons, 0, 
	       MAX_BEACON_COUNT * sizeof(struct ieee80211_beacon));

	return 0;
}

static inline void ieee80211_beacons_free(struct ieee80211_device *ieee)
{
	if (!ieee->beacons)
		return;
	kfree(ieee->beacons);
	ieee->beacons = NULL;
}

static inline void ieee80211_beacons_initialize(struct ieee80211_device *ieee)
{
	int i;

	INIT_LIST_HEAD(&ieee->beacon_free_list);
	INIT_LIST_HEAD(&ieee->beacon_list);
	for (i = 0; i < MAX_BEACON_COUNT; i++) 
		list_add_tail(&ieee->beacons[i].list, &ieee->beacon_free_list);
}

struct ieee80211_device *ieee80211_alloc(struct net_device *dev,
					 void *priv)
{
	struct ieee80211_device *ieee = kmalloc(
		sizeof(struct ieee80211_device), GFP_KERNEL);
	int err;
	if (ieee == NULL)
		return NULL;
	memset(ieee, 0, sizeof(*ieee));
	ieee->dev = dev;
	ieee->priv = priv;

	err = ieee80211_beacons_allocate(ieee);
	if (err) {
		IEEE80211_ERROR("Unable to allocate beacon storage\n");
		goto error;
	}
	ieee80211_beacons_initialize(ieee);

	/* Default fragmentation threshold is maximum payload size */
	ieee->fts = DEFAULT_FTS;
	ieee->scan_age = DEFAULT_MAX_SCAN_AGE;
	ieee->open_wep = 1;

#ifdef CONFIG_IEEE80211_CRYPT
	/* Default to enabling full open WEP with host based encrypt/decrypt */
	ieee->host_encrypt = 1;
	ieee->host_decrypt = 1;

	INIT_LIST_HEAD(&ieee->crypt_deinit_list);
	init_timer(&ieee->crypt_deinit_timer);
	ieee->crypt_deinit_timer.data = (unsigned long)ieee;
	ieee->crypt_deinit_timer.function = ieee80211_crypt_deinit_handler;
#endif

	spin_lock_init(&ieee->lock);

	return ieee;

 error:
	if (ieee) 
		kfree(ieee);
	return NULL;
}

void ieee80211_free(struct ieee80211_device *ieee)
{
#ifdef CONFIG_IEEE80211_CRYPT
	int i;

	del_timer_sync(&ieee->crypt_deinit_timer);
	ieee80211_crypt_deinit_entries(ieee, 1);

	for (i = 0; i < WEP_KEYS; i++) {
		struct ieee80211_crypt_data *crypt = ieee->crypt[i];
		if (crypt) {
			if (crypt->ops) {
				crypt->ops->deinit(crypt->priv);
				module_put(crypt->ops->owner);
			}
			kfree(crypt);
			ieee->crypt[i] = NULL;
		}
	}
#endif
	ieee80211_beacons_free(ieee);
	kfree(ieee);
}

EXPORT_SYMBOL(ieee80211_alloc);
EXPORT_SYMBOL(ieee80211_free);
