/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.lang.ref.WeakReference;

public final class WeakReferenceProxy
implements ListEventListener {
    private final WeakReference proxyTargetReference;
    private EventList source;

    public WeakReferenceProxy(EventList source, ListEventListener proxyTarget) {
        if (source == null) {
            throw new IllegalArgumentException("source may not be null");
        }
        if (proxyTarget == null) {
            throw new IllegalArgumentException("proxyTarget may not be null");
        }
        this.source = source;
        this.proxyTargetReference = new WeakReference<ListEventListener>(proxyTarget);
    }

    public void listChanged(ListEvent listChanges) {
        if (this.source == null) {
            return;
        }
        ListEventListener proxyTarget = this.getReferent();
        if (proxyTarget == null) {
            this.source.removeListEventListener(this);
            this.dispose();
        } else {
            proxyTarget.listChanged(listChanges);
        }
    }

    public ListEventListener getReferent() {
        return (ListEventListener)this.proxyTargetReference.get();
    }

    public void dispose() {
        this.source = null;
    }
}

