/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.matchers;

import ca.odell.glazedlists.Filterator;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.ArrayList;
import java.util.List;

public class RangeMatcher
implements Matcher {
    private final Comparable start;
    private final Comparable end;
    private final Filterator filterator;
    private final List filterComparables = new ArrayList();

    public RangeMatcher(Comparable start, Comparable end) {
        this(start, end, null);
    }

    public RangeMatcher(Comparable start, Comparable end, Filterator filterator) {
        this.start = start;
        this.end = end;
        this.filterator = filterator;
    }

    public boolean matches(Object item) {
        this.filterComparables.clear();
        if (this.filterator == null) {
            this.filterComparables.add((Comparable)item);
        } else {
            this.filterator.getFilterValues(this.filterComparables, item);
        }
        for (int c = 0; c < this.filterComparables.size(); ++c) {
            Comparable filterComparable = (Comparable)this.filterComparables.get(c);
            if (filterComparable != null && (this.start != null && this.start.compareTo(filterComparable) == 1 || this.end != null && this.end.compareTo(filterComparable) == -1)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "[RangeMatcher between " + this.start + " and " + this.end + "]";
    }
}

