/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.jfreechart;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.jfreechart.TreePair;
import ca.odell.glazedlists.jfreechart.ValueSegment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.data.UnknownKeyException;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;

public abstract class EventListCategoryDataset
extends AbstractDataset
implements CategoryDataset {
    private final DatasetChangeEvent immutableChangeEvent = new DatasetChangeEvent((Object)this, (Dataset)this);
    private final List sourceCopy;
    private final EventList source;
    private final DatasetEventListener datasetEventListener = new DatasetEventListener();
    protected List rowKeys;
    protected List columnKeys;
    private Map valueToTreePairs = new HashMap();

    public EventListCategoryDataset(EventList source) {
        this.source = source;
        this.sourceCopy = new ArrayList(source.size());
        this.sourceCopy.addAll(source);
        this.rebuildRowAndColumnKeyList();
        this.source.addListEventListener(this.datasetEventListener);
    }

    private void rebuildRowAndColumnKeyList() {
        this.columnKeys = this.createColumnKeyList();
        this.rowKeys = this.createRowKeyList();
    }

    protected List createRowKeyList() {
        return new ArrayList();
    }

    protected List createColumnKeyList() {
        return new ArrayList();
    }

    public Comparable getRowKey(int row) {
        return (Comparable)this.rowKeys.get(row);
    }

    public int getRowIndex(Comparable key) {
        return this.rowKeys.indexOf(key);
    }

    public List getRowKeys() {
        return this.rowKeys;
    }

    public int getRowCount() {
        return this.rowKeys.size();
    }

    public Comparable getColumnKey(int column) {
        return (Comparable)this.columnKeys.get(column);
    }

    public int getColumnIndex(Comparable key) {
        return this.columnKeys.indexOf(key);
    }

    public List getColumnKeys() {
        return this.columnKeys;
    }

    public int getColumnCount() {
        return this.columnKeys.size();
    }

    public Number getValue(int row, int column) {
        return this.getValue(this.getRowKey(row), this.getColumnKey(column));
    }

    public abstract Number getValue(Comparable var1, Comparable var2);

    public void dispose() {
        this.source.removeListEventListener(this.datasetEventListener);
    }

    private void clear() {
        this.sourceCopy.clear();
        this.valueToTreePairs.clear();
        this.rowKeys.clear();
        this.rebuildRowAndColumnKeyList();
    }

    private TreePair getTreePair(Comparable rowKey) {
        return (TreePair)this.valueToTreePairs.get(rowKey);
    }

    public int getCount(Comparable rowKey) {
        TreePair treePair = this.getTreePair(rowKey);
        return treePair == null ? 0 : treePair.size();
    }

    public int getCount(Comparable rowKey, Comparable start, Comparable end) {
        TreePair treePair = this.getTreePair(rowKey);
        if (treePair == null) {
            throw new UnknownKeyException("unrecognized rowKey: " + rowKey);
        }
        return treePair.getCount(start, end);
    }

    protected void postInsert(ValueSegment valueSegment) {
    }

    protected void postDelete(ValueSegment valueSegment) {
    }

    protected void fireDatasetChanged() {
        this.notifyListeners(this.immutableChangeEvent);
    }

    private class DatasetEventListener
    implements ListEventListener {
        private DatasetEventListener() {
        }

        public void listChanged(ListEvent listChanges) {
            if (listChanges.getSourceList().isEmpty()) {
                EventListCategoryDataset.this.clear();
            } else {
                while (listChanges.next()) {
                    TreePair treePair;
                    ValueSegment segment;
                    int type = listChanges.getType();
                    int index = listChanges.getIndex();
                    if (type == 2) {
                        segment = (ValueSegment)listChanges.getSourceList().get(index);
                        treePair = EventListCategoryDataset.this.getTreePair(segment.getValue());
                        if (treePair == null) {
                            treePair = new TreePair();
                            EventListCategoryDataset.this.valueToTreePairs.put(segment.getValue(), treePair);
                        }
                        treePair.insert(segment);
                        EventListCategoryDataset.this.sourceCopy.add(index, segment);
                        EventListCategoryDataset.this.postInsert(segment);
                        continue;
                    }
                    if (type == 1) {
                        ValueSegment newSegment = (ValueSegment)listChanges.getSourceList().get(index);
                        ValueSegment oldSegment = EventListCategoryDataset.this.sourceCopy.set(index, newSegment);
                        TreePair oldTreePair = EventListCategoryDataset.this.getTreePair(oldSegment.getValue());
                        TreePair newTreePair = EventListCategoryDataset.this.getTreePair(newSegment.getValue());
                        oldTreePair.delete(oldSegment);
                        EventListCategoryDataset.this.postDelete(oldSegment);
                        newTreePair.insert(newSegment);
                        EventListCategoryDataset.this.postInsert(newSegment);
                        continue;
                    }
                    if (type != 0) continue;
                    segment = (ValueSegment)EventListCategoryDataset.this.sourceCopy.remove(index);
                    treePair = EventListCategoryDataset.this.getTreePair(segment.getValue());
                    treePair.delete(segment);
                    EventListCategoryDataset.this.postDelete(segment);
                }
            }
            EventListCategoryDataset.this.fireDatasetChanged();
        }
    }
}

