/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.ListSelection;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class EventSelectionModel
implements ListSelectionModel {
    private ListSelection listSelection;
    private TransformedList swingThreadSource;
    private boolean enabled = true;
    private List listeners = new ArrayList();
    private boolean valueIsAdjusting = false;
    private int fullChangeStart = -1;
    private int fullChangeFinish = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventSelectionModel(EventList source) {
        source.getReadWriteLock().readLock().lock();
        try {
            this.swingThreadSource = GlazedListsSwing.swingThreadProxyList(source);
            this.listSelection = new ListSelection(this.swingThreadSource);
            this.listSelection.addSelectionListener(new SwingSelectionListener());
        }
        finally {
            source.getReadWriteLock().readLock().unlock();
        }
    }

    public EventList getEventList() {
        return this.getSelected();
    }

    public EventList getSelected() {
        return this.listSelection.getSelected();
    }

    public EventList getTogglingSelected() {
        return this.listSelection.getTogglingSelected();
    }

    public EventList getDeselected() {
        return this.listSelection.getDeselected();
    }

    public EventList getTogglingDeselected() {
        return this.listSelection.getTogglingDeselected();
    }

    public ListSelectionModel getListSelectionModel() {
        return this;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    private void fireSelectionChanged(int changeStart, int changeFinish) {
        if (this.valueIsAdjusting) {
            if (this.fullChangeStart == -1 || changeStart < this.fullChangeStart) {
                this.fullChangeStart = changeStart;
            }
            if (this.fullChangeFinish == -1 || changeFinish > this.fullChangeFinish) {
                this.fullChangeFinish = changeFinish;
            }
        }
        ListSelectionEvent event = new ListSelectionEvent(this, changeStart, changeFinish, this.valueIsAdjusting);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ListSelectionListener listener = (ListSelectionListener)i.next();
            listener.valueChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invertSelection() {
        this.swingThreadSource.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.invertSelection();
        }
        finally {
            this.swingThreadSource.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectionInterval(int index0, int index1) {
        if (!this.enabled) {
            return;
        }
        this.swingThreadSource.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.setSelection(index0, index1);
        }
        finally {
            this.swingThreadSource.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionInterval(int index0, int index1) {
        if (!this.enabled) {
            return;
        }
        this.swingThreadSource.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.select(index0, index1);
        }
        finally {
            this.swingThreadSource.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionInterval(int index0, int index1) {
        if (!this.enabled) {
            return;
        }
        if (index0 == 0 && index1 == 0 && this.swingThreadSource.isEmpty()) {
            return;
        }
        this.swingThreadSource.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.deselect(index0, index1);
        }
        finally {
            this.swingThreadSource.getReadWriteLock().writeLock().unlock();
        }
    }

    public boolean isSelectedIndex(int index) {
        return this.listSelection.isSelected(index);
    }

    public int getAnchorSelectionIndex() {
        return this.listSelection.getAnchorSelectionIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnchorSelectionIndex(int anchorSelectionIndex) {
        if (!this.enabled) {
            return;
        }
        this.swingThreadSource.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.setAnchorSelectionIndex(anchorSelectionIndex);
        }
        finally {
            this.swingThreadSource.getReadWriteLock().writeLock().unlock();
        }
    }

    public int getLeadSelectionIndex() {
        return this.listSelection.getLeadSelectionIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeadSelectionIndex(int leadSelectionIndex) {
        if (!this.enabled) {
            return;
        }
        this.swingThreadSource.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.setLeadSelectionIndex(leadSelectionIndex);
        }
        finally {
            this.swingThreadSource.getReadWriteLock().writeLock().unlock();
        }
    }

    public int getMinSelectionIndex() {
        return this.listSelection.getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.listSelection.getMaxSelectionIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelection() {
        if (!this.enabled) {
            return;
        }
        this.swingThreadSource.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.deselectAll();
        }
        finally {
            this.swingThreadSource.getReadWriteLock().writeLock().unlock();
        }
    }

    public boolean isSelectionEmpty() {
        return this.listSelection.getSelected().size() == 0;
    }

    public void insertIndexInterval(int index, int length, boolean before) {
    }

    public void removeIndexInterval(int index0, int index1) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
        if (!valueIsAdjusting && this.fullChangeStart != -1 && this.fullChangeFinish != -1) {
            this.swingThreadSource.getReadWriteLock().writeLock().lock();
            try {
                this.fireSelectionChanged(this.fullChangeStart, this.fullChangeFinish);
                this.fullChangeStart = -1;
                this.fullChangeFinish = -1;
            }
            finally {
                this.swingThreadSource.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectionMode(int selectionMode) {
        this.swingThreadSource.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.setSelectionMode(selectionMode);
        }
        finally {
            this.swingThreadSource.getReadWriteLock().writeLock().unlock();
        }
    }

    public int getSelectionMode() {
        return this.listSelection.getSelectionMode();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listeners.remove(listener);
    }

    public void dispose() {
        this.listSelection.dispose();
    }

    private class SwingSelectionListener
    implements ListSelection.Listener {
        private SwingSelectionListener() {
        }

        public void selectionChanged(int changeStart, int changeEnd) {
            EventSelectionModel.this.fireSelectionChanged(changeStart, changeEnd);
        }
    }
}

