/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.font;

import java.awt.Graphics;
import java.io.IOException;
import java.util.HashMap;
import org.fontbox.afm.FontMetric;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.encoding.Encoding;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.pdmodel.font.PDFontDescriptor;
import org.pdfbox.pdmodel.font.PDFontDescriptorAFM;
import org.pdfbox.pdmodel.font.PDFontDescriptorDictionary;

public abstract class PDSimpleFont
extends PDFont {
    private HashMap mFontSizes = new HashMap(128);
    private float avgFontWidth = 0.0f;

    public PDSimpleFont() {
    }

    public PDSimpleFont(COSDictionary fontDictionary) {
        super(fontDictionary);
    }

    public void drawString(String string, Graphics g, float fontSize, float xScale, float yScale, float x, float y) throws IOException {
        System.err.println("Not yet implemented:" + this.getClass().getName());
    }

    public float getFontHeight(byte[] c, int offset, int length) throws IOException {
        float retval = 0.0f;
        int code = this.getCodeFromArray(c, offset, length);
        FontMetric metric = this.getAFM();
        if (metric != null) {
            Encoding encoding = this.getEncoding();
            COSName characterName = encoding.getName(code);
            retval = metric.getCharacterHeight(characterName.getName());
        } else {
            PDFontDescriptor desc = this.getFontDescriptor();
            if (desc != null) {
                float xHeight = desc.getXHeight();
                float capHeight = desc.getCapHeight();
                retval = xHeight != 0.0f && capHeight != 0.0f ? (xHeight + capHeight) / 2.0f : (xHeight != 0.0f ? xHeight : (capHeight != 0.0f ? capHeight : 0.0f));
            }
        }
        return retval;
    }

    public float getFontWidth(byte[] c, int offset, int length) throws IOException {
        float fontWidth = 0.0f;
        int code = this.getCodeFromArray(c, offset, length);
        Integer Icode = new Integer(code);
        if (this.mFontSizes.containsKey(Icode)) {
            Float FfontWidth = (Float)this.mFontSizes.get(Icode);
            fontWidth = FfontWidth.floatValue();
        } else {
            COSInteger firstChar = (COSInteger)this.font.getDictionaryObject(COSName.FIRST_CHAR);
            COSInteger lastChar = (COSInteger)this.font.getDictionaryObject(COSName.LAST_CHAR);
            if (firstChar != null && lastChar != null) {
                long first = firstChar.intValue();
                long last = lastChar.intValue();
                if ((long)code >= first && (long)code <= last && this.font.getDictionaryObject(COSName.WIDTHS) != null) {
                    COSArray widthArray = (COSArray)this.font.getDictionaryObject(COSName.WIDTHS);
                    COSNumber fontWidthObject = (COSNumber)widthArray.get((int)((long)code - first));
                    fontWidth = fontWidthObject.floatValue();
                } else {
                    fontWidth = this.getFontWidthFromAFMFile(code);
                }
            } else {
                fontWidth = this.getFontWidthFromAFMFile(code);
            }
            this.mFontSizes.put(Icode, new Float(fontWidth));
        }
        return fontWidth;
    }

    public float getAverageFontWidth() throws IOException {
        float average = 0.0f;
        if (this.avgFontWidth != 0.0f) {
            average = this.avgFontWidth;
        } else {
            float totalWidth = 0.0f;
            float characterCount = 0.0f;
            COSArray widths = (COSArray)this.font.getDictionaryObject(COSName.WIDTHS);
            if (widths != null) {
                for (int i = 0; i < widths.size(); ++i) {
                    COSNumber fontWidth = (COSNumber)widths.getObject(i);
                    if (!(fontWidth.floatValue() > 0.0f)) continue;
                    totalWidth += fontWidth.floatValue();
                    characterCount += 1.0f;
                }
            }
            average = totalWidth > 0.0f ? totalWidth / characterCount : this.getAverageFontWidthFromAFMFile();
            this.avgFontWidth = average;
        }
        return average;
    }

    public PDFontDescriptor getFontDescriptor() throws IOException {
        PDFontDescriptor retval = null;
        COSDictionary fd = (COSDictionary)this.font.getDictionaryObject(COSName.getPDFName("FontDescriptor"));
        if (fd == null) {
            FontMetric afm = this.getAFM();
            if (afm != null) {
                retval = new PDFontDescriptorAFM(afm);
            }
        } else {
            retval = new PDFontDescriptorDictionary(fd);
        }
        return retval;
    }

    public void setFontDescriptor(PDFontDescriptorDictionary fontDescriptor) {
        COSDictionary dic = null;
        if (fontDescriptor != null) {
            dic = fontDescriptor.getCOSDictionary();
        }
        this.font.setItem(COSName.getPDFName("FontDescriptor"), (COSBase)dic);
    }

    public PDStream getToUnicode() throws IOException {
        return PDStream.createFromCOS(this.font.getDictionaryObject("ToUnicode"));
    }

    public void setToUnicode(PDStream unicode) {
        this.font.setItem("ToUnicode", (COSObjectable)unicode);
    }

    public PDRectangle getFontBoundingBox() throws IOException {
        return this.getFontDescriptor().getFontBoundingBox();
    }
}

