/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.boot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PluginManager;
import org.java.plugin.boot.Application;
import org.java.plugin.boot.ApplicationInitializer;
import org.java.plugin.boot.BootErrorHandler;
import org.java.plugin.boot.BootErrorHandlerConsole;
import org.java.plugin.boot.BootErrorHandlerGui;
import org.java.plugin.boot.ControlThread;
import org.java.plugin.boot.DefaultApplicationInitializer;
import org.java.plugin.boot.ErrorDialog;
import org.java.plugin.boot.ServiceApplication;
import org.java.plugin.boot.SimpleSplashHandler;
import org.java.plugin.boot.SplashHandler;
import org.java.plugin.boot.SplashHandlerWrapper;
import org.java.plugin.util.ExtendedProperties;
import org.java.plugin.util.IoUtil;
import org.java.plugin.util.ResourceManager;

public final class Boot {
    public static final String BOOT_ERROR_FILE_NAME = "jpf-boot-error.txt";
    public static final String PROP_BOOT_CONFIG = "jpf.boot.config";
    public static final String PROP_BOOT_MODE = "jpf.boot.mode";
    public static final String BOOT_MODE_SHELL = "shell";
    public static final String BOOT_MODE_START = "start";
    public static final String BOOT_MODE_STOP = "stop";
    public static final String BOOT_MODE_RESTART = "restart";
    public static final String BOOT_MODE_LOAD = "load";
    static final String PACKAGE_NAME = "org.java.plugin.boot";
    private static final String PARAM_CONTROL_HOST = "org.java.plugin.boot.controlHost";
    private static final String PARAM_CONTROL_PORT = "org.java.plugin.boot.controlPort";
    private static final String PARAM_ERROR_HANDLER = "org.java.plugin.boot.errorHandler";
    private static final String PARAM_APP_INITIALIZER = "org.java.plugin.boot.appInitializer";
    private static final String PARAM_SPLASH_HANDLER = "org.java.plugin.boot.splashHandler";
    private static final String PARAM_SPLASH_IMAGE = "org.java.plugin.boot.splashImage";
    private static final String PARAM_SPLASH_LEAVE_VISIBLE = "org.java.plugin.boot.splashLeaveVisible";
    private static final String PARAM_SPLASH_DISPOSE_ON_HIDE = "org.java.plugin.boot.splashDisposeOnHide";
    private static final String PARAM_SPLASH_CONFIG_PREFIX = "org.java.plugin.boot.splash.";
    static SplashHandler splashHandler = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Boot.clearBootLog();
        ExtendedProperties props = new ExtendedProperties(System.getProperties());
        try {
            InputStream strm = Boot.lookupConfig();
            try {
                props.load(strm);
            }
            finally {
                strm.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        String mode = props.getProperty(PROP_BOOT_MODE);
        mode = mode != null ? mode.trim().toLowerCase(Locale.ENGLISH) : BOOT_MODE_SHELL;
        props.setProperty(PROP_BOOT_MODE, mode);
        System.setProperty(PROP_BOOT_MODE, mode);
        boolean useControlService = props.containsKey(PARAM_CONTROL_HOST) && props.containsKey(PARAM_CONTROL_PORT);
        BootErrorHandler errorHandler = Boot.getErrorHandlerInstance(props.getProperty(PARAM_ERROR_HANDLER), useControlService);
        try {
            if (props.getProperty("applicationRoot") == null) {
                String applicationRoot = new File(".").getCanonicalPath();
                props.put("applicationRoot", applicationRoot);
            }
            Boot.boot(props, useControlService, mode, errorHandler, args);
        }
        catch (Throwable t) {
            if (splashHandler != null) {
                splashHandler.setVisible(false);
                splashHandler = null;
            }
            Boot.bootLog(t);
            errorHandler.handleFatalError(ResourceManager.getMessage(PACKAGE_NAME, "bootFailed"), t);
            System.exit(1);
        }
    }

    public static Application boot(ExtendedProperties config, boolean useControlService, String mode, BootErrorHandler errorHandler, String[] args) throws Exception {
        int controlPort;
        InetAddress controlHost = useControlService ? InetAddress.getByName(config.getProperty(PARAM_CONTROL_HOST)) : null;
        int n = controlPort = useControlService ? Integer.parseInt(config.getProperty(PARAM_CONTROL_PORT), 10) : 0;
        if (useControlService && BOOT_MODE_STOP.equals(mode)) {
            if (!ControlThread.stopRunningApplication(controlHost, controlPort)) {
                System.out.println("application not running");
            } else {
                System.out.println("application stopped");
            }
            return null;
        }
        if (useControlService && BOOT_MODE_START.equals(mode)) {
            if (ControlThread.isApplicationRunning(controlHost, controlPort)) {
                errorHandler.handleFatalError("Application already running.");
                return null;
            }
            Application application = Boot.initApplication(errorHandler, config, args);
            if (!(application instanceof ServiceApplication)) {
                errorHandler.handleFatalError("Application is not a service.");
                return null;
            }
            ControlThread controlThread = new ControlThread(controlHost, controlPort, (ServiceApplication)application);
            application.startApplication();
            controlThread.start();
            System.out.println("application started in BACKGROUND mode");
            return application;
        }
        if (useControlService && BOOT_MODE_RESTART.equals(mode)) {
            Application application;
            if (ControlThread.stopRunningApplication(controlHost, controlPort)) {
                System.out.println("another instance of application stopped");
            }
            if (!((application = Boot.initApplication(errorHandler, config, args)) instanceof ServiceApplication)) {
                errorHandler.handleFatalError("Application is not a service.");
                return null;
            }
            ControlThread controlThread = new ControlThread(controlHost, controlPort, (ServiceApplication)application);
            application.startApplication();
            controlThread.start();
            System.out.println("application started in BACKGROUND mode");
            return application;
        }
        if (useControlService && ControlThread.stopRunningApplication(controlHost, controlPort)) {
            System.out.println("another instance of application stopped");
        }
        if (!BOOT_MODE_LOAD.equals(mode)) {
            Boot.initSplashHandler(config);
            if (splashHandler != null) {
                splashHandler.setVisible(true);
            }
        }
        Application application = Boot.initApplication(errorHandler, config, args);
        if (!BOOT_MODE_LOAD.equals(mode)) {
            application.startApplication();
            if (splashHandler != null && !"true".equalsIgnoreCase(config.getProperty(PARAM_SPLASH_LEAVE_VISIBLE, "false"))) {
                splashHandler.setVisible(false);
            }
            if (application instanceof ServiceApplication && BOOT_MODE_SHELL.equals(mode)) {
                System.out.println("application started in SHELL mode");
                Boot.runShell();
                Boot.stopApplication(application);
            }
        }
        return application;
    }

    public static void stopApplication(Application application) throws Exception {
        PluginManager pluginManager;
        if (application instanceof ServiceApplication) {
            ((ServiceApplication)application).stopApplication();
        }
        if ((pluginManager = PluginManager.lookup(application)) != null) {
            pluginManager.shutdown();
        }
        LogFactory.getLog(Boot.class).info((Object)"logging system finalized");
        LogFactory.getLog(Boot.class).info((Object)"---------------------------------");
        LogFactory.releaseAll();
    }

    public static SplashHandler getSplashHandler() {
        return splashHandler;
    }

    public static void setSplashHandler(SplashHandler handler) {
        if (handler == null && splashHandler != null) {
            splashHandler.setVisible(false);
        }
        splashHandler = handler;
    }

    private static InputStream lookupConfig() throws IOException {
        String property = System.getProperty(PROP_BOOT_CONFIG);
        if (property != null) {
            return IoUtil.getResourceInputStream(Boot.str2url(property));
        }
        File file = new File("boot.properties");
        if (file.isFile()) {
            return new FileInputStream(file);
        }
        URL url = Boot.class.getClassLoader().getResource("boot.properties");
        if (url != null) {
            return IoUtil.getResourceInputStream(url);
        }
        url = Boot.class.getResource("boot.properties");
        if (url != null) {
            return IoUtil.getResourceInputStream(url);
        }
        throw new IOException("configuration file boot.properties not found");
    }

    private static URL str2url(String str) throws MalformedURLException {
        int p = str.indexOf("!/");
        if (p == -1) {
            try {
                return new URL(str);
            }
            catch (MalformedURLException mue) {
                return IoUtil.file2url(new File(str));
            }
        }
        if (str.startsWith("jar:")) {
            return new URL(str);
        }
        File file = new File(str.substring(0, p));
        if (file.isFile()) {
            return new URL("jar:" + IoUtil.file2url(file) + str.substring(p));
        }
        return new URL("jar:" + str);
    }

    private static BootErrorHandler getErrorHandlerInstance(String handler, boolean isServiceApp) {
        if (handler != null) {
            try {
                return (BootErrorHandler)Class.forName(handler).newInstance();
            }
            catch (InstantiationException ie) {
                System.err.println("failed instantiating error handler " + handler);
                ie.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                System.err.println("failed instantiating error handler " + handler);
                iae.printStackTrace();
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println("failed instantiating error handler " + handler);
                cnfe.printStackTrace();
            }
        }
        return isServiceApp ? new BootErrorHandlerConsole() : new BootErrorHandlerGui();
    }

    private static void initSplashHandler(ExtendedProperties config) throws Exception {
        boolean disposeOnHide;
        String handlerClass = config.getProperty(PARAM_SPLASH_HANDLER);
        String splashImage = config.getProperty(PARAM_SPLASH_IMAGE);
        URL url = null;
        if (splashImage != null && splashImage.length() > 0) {
            try {
                url = new URL(splashImage);
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
            if (url == null) {
                File splashFile = new File(splashImage);
                if (splashFile.isFile()) {
                    url = IoUtil.file2url(splashFile);
                } else {
                    throw new FileNotFoundException("splash image file " + splashFile + " not found");
                }
            }
        }
        boolean bl = disposeOnHide = !"false".equalsIgnoreCase(config.getProperty(PARAM_SPLASH_DISPOSE_ON_HIDE, "true"));
        if (handlerClass != null) {
            splashHandler = new SplashHandlerWrapper(disposeOnHide, (SplashHandler)Class.forName(handlerClass).newInstance());
        }
        if (splashHandler == null && url != null) {
            splashHandler = new SplashHandlerWrapper(disposeOnHide, new SimpleSplashHandler());
        }
        if (splashHandler != null) {
            if (url != null) {
                splashHandler.setImage(url);
            }
            splashHandler.configure(config.getSubset(PARAM_SPLASH_CONFIG_PREFIX));
        }
    }

    private static Application initApplication(BootErrorHandler errorHandler, ExtendedProperties props, String[] args) throws Exception {
        ApplicationInitializer appInitializer = null;
        String className = props.getProperty(PARAM_APP_INITIALIZER);
        if (className != null) {
            try {
                appInitializer = (ApplicationInitializer)Class.forName(className).newInstance();
            }
            catch (InstantiationException ie) {
                System.err.println("failed instantiating application initializer " + className);
                ie.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                System.err.println("failed instantiating application initializer " + className);
                iae.printStackTrace();
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println("failed instantiating application initializer " + className);
                cnfe.printStackTrace();
            }
        }
        if (appInitializer == null) {
            appInitializer = new DefaultApplicationInitializer();
        }
        appInitializer.configure(props);
        Application result = appInitializer.initApplication(errorHandler, args);
        if (result == null) {
            throw new Exception(ResourceManager.getMessage(PACKAGE_NAME, "bootAppInitFailed"));
        }
        return result;
    }

    private static void runShell() {
        int c;
        System.out.println("Press 'q' key to exit.");
        do {
            try {
                c = System.in.read();
            }
            catch (IOException ioe) {
                break;
            }
        } while ('q' != (char)c && 'Q' != (char)c);
    }

    private static void clearBootLog() {
        File file = new File(BOOT_ERROR_FILE_NAME);
        if (file.isFile()) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bootLog(Throwable t) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(BOOT_ERROR_FILE_NAME, false), "UTF-8");
            try {
                writer.write("JPF Application boot failed.");
                writer.write(System.getProperty("line.separator"));
                writer.write(ErrorDialog.getErrorDetails(t));
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (Throwable t2) {
            throw new Error("boot failed", t);
        }
    }

    private Boot() {
    }
}

