/*
 *  Jajuk
 *  Copyright (C) 2005 The Jajuk Team
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *  $$Revision: 4113 $$
 */
package org.jajuk.ui.actions;

import java.awt.event.ActionEvent;
import java.util.List;

import org.jajuk.base.Track;
import org.jajuk.base.TrackManager;
import org.jajuk.events.JajukEvent;
import org.jajuk.events.JajukEvents;
import org.jajuk.events.ObservationManager;
import org.jajuk.util.Const;
import org.jajuk.util.IconLoader;
import org.jajuk.util.JajukIcons;
import org.jajuk.util.Messages;
import org.jajuk.util.log.Log;

public class BanSelectionAction extends SelectionAction {

  private static final long serialVersionUID = 1L;

  /**
   * The Ban action is used to ban a set of tracks so they will never be
   * proposed by jajuk automatic selections
   * <p>
   * Selection action
   * </p>
   */
  BanSelectionAction() {
    super(Messages.getString("BanSelectionAction.0"), IconLoader.getIcon(JajukIcons.BAN), true);
    setShortDescription(Messages.getString("BanSelectionAction.1"));
  }

  @Override
  public void perform(final ActionEvent e) throws Exception {
    new Thread("BanSelectionAction") {
      public void run() {
        try {
          BanSelectionAction.super.perform(e);
          // Check selection is not void
          if (selection.size() == 0) {
            return;
          }
          // Extract tracks of each item
          List<Track> tracks = TrackManager.getInstance().getAssociatedTracks(selection, false);
          // Then ban them all !
          for (Track track : tracks) {
            track.setProperty(Const.XML_TRACK_BANNED, true);
          }
          // Request a GUI refresh
          ObservationManager.notify(new JajukEvent(JajukEvents.RATE_CHANGED));
        } catch (Exception e) {
          Log.error(e);
        }
      }
    }.start();
  }
}
