# Detect product
function blackdown_j2sdk_detect() {
    local found=
    case "$archive_name" in
	"j2sdk-1.3.1-02b-FCS-linux-i386.bin")
	    j2se_version=1.3.1+02b
	    j2se_expected_min_size=52 # 54083 kB
	    found=true
	    ;;
	"j2sdk-1.4.1-01-linux-i586-gcc2.95.bin")
	    j2se_version=1.4.1+01
	    j2se_expected_min_size=78 # 80653 kB
	    found=true
	    ;;
	"j2sdk-1.4.1-01-linux-i586-gcc3.2.bin")
	    j2se_version=1.4.1+01
	    j2se_expected_min_size=76 # 78055 kB
	    found=true
	    ;;
	"j2sdk-1.4.2-rc1-linux-i586-gcc2.95.bin")
	    j2se_version=1.4.2+rc1
	    j2se_expected_min_size=76 # 78055 kB
	    found=true
	    ;;
	"j2sdk-1.4.2-rc1-linux-i586-gcc3.2.bin")
	    j2se_version=1.4.2+rc1
	    j2se_expected_min_size=76 # 78055 kB
	    found=true
	    ;;
    esac
    if [[ -n "$found" ]]; then
	cat << EOF

Detected product:
    Java(TM) Software Development Kit (J2SDK)
    Standard Edition, Version $j2se_version
    Blackdown Java-Linux
EOF
	if read_yn "Is this correct [Y/n]: "; then
	    j2se_found=true
	    j2se_release="${j2se_version:0:3}"
	    j2se_required_space=$(( $j2se_expected_min_size * 2 + 20 ))
	    j2se_vendor="blackdown"
	    j2se_title="Java(TM) 2 SDK, Standard Edition, Blackdown"
	    j2sdk_run
	fi
    fi
}

j2se_detect_blackdown_j2sdk=blackdown_j2sdk_detect
