/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jaas;

import java.util.HashMap;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.UserPrincipal;
import org.mortbay.http.UserRealm;
import org.mortbay.jaas.JAASUserPrincipal;
import org.mortbay.jaas.RoleCheckPolicy;
import org.mortbay.jaas.callback.AbstractCallbackHandler;
import org.mortbay.jaas.callback.DefaultCallbackHandler;
import org.mortbay.util.Log;

public class JAASUserRealm
implements UserRealm {
    protected String realmName;
    protected String loginModuleName;
    protected AbstractCallbackHandler callbackHandler;
    protected HashMap userMap = new HashMap();
    protected RoleCheckPolicy roleCheckPolicy;

    public JAASUserRealm() {
    }

    public JAASUserRealm(String name) {
        this();
        this.realmName = name;
    }

    public String getName() {
        return this.realmName;
    }

    public void setName(String name) {
        this.realmName = name;
    }

    public void setLoginModuleName(String name) {
        this.loginModuleName = name;
    }

    public void setCallbackHandler(AbstractCallbackHandler handler) {
        this.callbackHandler = handler;
    }

    public void setRoleCheckPolicy(RoleCheckPolicy policy) {
        this.roleCheckPolicy = policy;
    }

    public UserPrincipal authenticate(String username, Object credentials, HttpRequest request) {
        try {
            UserInfo info = (UserInfo)this.userMap.get(username);
            if (info != null) {
                this.userMap.remove(username);
            }
            if (this.callbackHandler == null) {
                Log.warning((Object)"No CallbackHandler configured: using DefaultCallbackHandler");
                this.callbackHandler = new DefaultCallbackHandler();
            }
            this.callbackHandler.setUserName(username);
            this.callbackHandler.setCredential(credentials);
            LoginContext loginContext = new LoginContext(this.loginModuleName, this.callbackHandler);
            loginContext.login();
            JAASUserPrincipal userPrincipal = new JAASUserPrincipal(username);
            userPrincipal.setSubject(loginContext.getSubject());
            userPrincipal.setRoleCheckPolicy(this.roleCheckPolicy);
            this.userMap.put(username, new UserInfo(username, userPrincipal, loginContext));
            return userPrincipal;
        }
        catch (LoginException e) {
            Log.warning((Object)e);
            return null;
        }
    }

    public void disassociate(UserPrincipal user) {
        if (user != null) {
            ((JAASUserPrincipal)user).disassociate();
        }
    }

    public UserPrincipal pushRole(UserPrincipal user, String role) {
        ((JAASUserPrincipal)user).pushRole(role);
        return user;
    }

    public UserPrincipal popRole(UserPrincipal user) {
        ((JAASUserPrincipal)user).popRole();
        return user;
    }

    public void logout(UserPrincipal user) {
        try {
            if (!(user instanceof JAASUserPrincipal)) {
                throw new IllegalArgumentException(user + " is not a JAASUserPrincipal");
            }
            String key = ((JAASUserPrincipal)user).getName();
            UserInfo info = (UserInfo)this.userMap.get(key);
            if (info == null) {
                Log.warning((Object)("Logout called for user=" + user + " who is NOT in the authentication cache"));
            }
            info.getLoginContext().logout();
            this.userMap.remove(key);
            Log.event((Object)(user + " has been LOGGED OUT"));
        }
        catch (LoginException e) {
            Log.warning((Object)e);
        }
    }

    protected class UserInfo {
        String name;
        JAASUserPrincipal principal;
        LoginContext context;

        public UserInfo(String name, JAASUserPrincipal principal, LoginContext context) {
            this.name = name;
            this.principal = principal;
            this.context = context;
        }

        public String getName() {
            return this.name;
        }

        public JAASUserPrincipal getJAASUserPrincipal() {
            return this.principal;
        }

        public LoginContext getLoginContext() {
            return this.context;
        }
    }
}

