/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.loadbalancer;

import java.nio.ByteBuffer;
import java.util.ArrayList;

public class ByteBufferPool {
    private ArrayList _pool = new ArrayList();
    private int _capacity = 4096;
    private boolean _direct = false;

    public ByteBufferPool() {
    }

    public ByteBufferPool(int capacity, boolean direct) {
        this._capacity = capacity;
        this._direct = direct;
    }

    public int getCapacity() {
        return this._capacity;
    }

    public void setCapacity(int capacity) {
        this._capacity = capacity;
    }

    public boolean isDirect() {
        return this._direct;
    }

    public void setDirect(boolean direct) {
        this._direct = direct;
    }

    public synchronized ByteBuffer get() {
        if (this._pool.isEmpty()) {
            if (this._direct) {
                return ByteBuffer.allocateDirect(this._capacity);
            }
            return ByteBuffer.allocate(this._capacity);
        }
        ByteBuffer buffer = (ByteBuffer)this._pool.remove(this._pool.size() - 1);
        buffer.clear();
        return buffer;
    }

    public synchronized void add(ByteBuffer buffer) {
        if (buffer.capacity() == this._capacity) {
            this._pool.add(buffer);
        }
    }
}

