/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.loadbalancer;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.mortbay.loadbalancer.Connection;
import org.mortbay.loadbalancer.NonBlockingQueue;
import org.mortbay.loadbalancer.Server;
import org.mortbay.util.Code;
import org.mortbay.util.Log;

public class Policy {
    private Server[] _server;
    private int _next;
    private Map _stickyInet = new HashMap();

    public Policy(Server[] server) {
        this._server = server;
    }

    public void deallocate(Connection connection, NonBlockingQueue queue, int tries) throws IOException {
        InetAddress client = connection.getClientSocketChannel().socket().getInetAddress();
        Object sticky = this._stickyInet.remove(client);
        Log.event((Object)("Unstick " + client + " from " + sticky));
        if (tries + 1 < this._server.length) {
            this.allocate(connection, queue, tries + 1);
        } else {
            connection.close();
        }
    }

    public void allocate(Connection connection, NonBlockingQueue queue, int tries) throws IOException {
        Integer s;
        InetAddress client = connection.getClientSocketChannel().socket().getInetAddress();
        if (Code.debug()) {
            Code.debug((String)("Allocate " + client + " size=" + queue.size()));
        }
        if ((s = (Integer)this._stickyInet.get(client)) == null) {
            this._next = (this._next + 1) % this._server.length;
            Log.event((Object)("Stick " + client + " to " + this._next));
            connection.allocate(this._server[this._next], tries);
            this._stickyInet.put(client, new Integer(this._next));
        } else {
            Code.debug((Object)client, (Object)" stuck to ", (Object)s);
            connection.allocate(this._server[s], tries);
        }
    }
}

