/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util.jmx;

import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.loading.MLet;
import org.mortbay.util.Code;
import org.mortbay.util.Log;
import org.mortbay.util.Resource;
import org.mortbay.util.jmx.ModelMBeanImpl;

public class Main {
    static MLet mlet;

    static void startMLet(String[] arg) {
        try {
            MBeanServer server = MBeanServerFactory.createMBeanServer(ModelMBeanImpl.getDefaultDomain());
            Code.debug((Object)"MBeanServer=", (Object)server);
            mlet = new MLet(new URL[0], Thread.currentThread().getContextClassLoader());
            server.registerMBean(mlet, new ObjectName(server.getDefaultDomain(), "service", "MLet"));
            Code.debug((Object)"MLet=", (Object)mlet);
            Thread.currentThread().setContextClassLoader(mlet);
            int i = 0;
            while (i < arg.length) {
                Log.event((Object)("Load " + arg[i]));
                Resource resource = Resource.newResource((String)arg[i]);
                Set<Object> beans = mlet.getMBeansFromURL(resource.getURL().toString());
                Iterator<Object> iter = beans.iterator();
                while (iter.hasNext()) {
                    ObjectInstance oi;
                    Object bean = iter.next();
                    if (bean instanceof Throwable) {
                        iter.remove();
                        Code.warning((Throwable)((Throwable)bean));
                        continue;
                    }
                    if (!(bean instanceof ObjectInstance) || !"com.sun.jdmk.comm.HtmlAdaptorServer".equals((oi = (ObjectInstance)bean).getClassName())) continue;
                    Log.event((Object)"Starting com.sun.jdmk.comm.HtmlAdaptorServer");
                    try {
                        server.invoke(oi.getObjectName(), "start", null, null);
                    }
                    catch (Exception e) {
                        Code.warning((Throwable)e);
                    }
                }
                Code.debug((Object)("Loaded " + beans.size()), (Object)"MBeans: ", beans);
                ++i;
            }
        }
        catch (Exception e) {
            Code.warning((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arg) throws Exception {
        if (arg.length == 0) {
            System.err.println("Usage - java org.mortbay.util.jmx.Main <mletURL>...");
            System.exit(1);
        }
        Main.startMLet(arg);
        MLet mLet = mlet;
        synchronized (mLet) {
            mlet.wait();
        }
    }
}

