/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util.jmx;

import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.mortbay.util.Code;
import org.mortbay.util.Log;
import org.mortbay.util.TypeUtil;

public class ModelMBeanImpl
implements ModelMBean,
MBeanRegistration {
    public static final int IMPACT_ACTION = 1;
    public static final int IMPACT_ACTION_INFO = 2;
    public static final int IMPACT_INFO = 0;
    public static final int IMPACT_UNKOWN = 3;
    public static final String STRING = "java.lang.String";
    public static final String OBJECT = "java.lang.Object";
    public static final String INT = "int";
    public static final String[] NO_PARAMS = new String[0];
    public static final boolean READ_WRITE = true;
    public static final boolean READ_ONLY = false;
    public static final boolean ON_MBEAN = true;
    public static final boolean ON_OBJECT = false;
    private static HashMap __objectId = new HashMap();
    private static String __defaultDomain = "org.mortbay";
    protected ModelMBeanInfoSupport _beanInfo;
    private MBeanServer _mBeanServer;
    private Object _object;
    private ObjectName _objectName;
    private boolean _dirty = false;
    private HashMap _getter = new HashMap(4);
    private HashMap _setter = new HashMap(4);
    private HashMap _method = new HashMap(4);
    private ArrayList _attributes = new ArrayList(4);
    private ArrayList _operations = new ArrayList(4);
    private ArrayList _notifications = new ArrayList(4);
    private String _baseObjectName = null;
    private Map _components = new HashMap(4);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ModelMBean mbeanFor(Object o) {
        try {
            Class<?> oClass = o.getClass();
            ClassLoader loader = oClass.getClassLoader();
            ModelMBean mbean = null;
            boolean jmx = false;
            Class<?>[] interfaces = null;
            int i = 0;
            while (mbean == null) {
                if (oClass == null) {
                    return null;
                }
                Class<?> focus = interfaces == null ? oClass : interfaces[i];
                String pName = focus.getPackage().getName();
                String cName = focus.getName().substring(pName.length() + 1);
                String mName = pName + (jmx ? ".jmx." : ".") + cName + "MBean";
                try {
                    Class<?> mClass = loader.loadClass(mName);
                    if (Code.verbose()) {
                        Code.debug((Object)"mbeanFor ", (Object)o, (Object)" mClass=", mClass);
                    }
                    mbean = (ModelMBean)mClass.newInstance();
                    mbean.setManagedResource(o, "objectReference");
                    Code.debug((Object)"mbeanFor ", (Object)o, (Object)" is ", (Object)mbean);
                    return mbean;
                }
                catch (ClassNotFoundException e) {
                    if (e.toString().endsWith("MBean")) {
                        if (Code.verbose()) {
                            Code.debug((String)e.toString());
                        }
                    }
                    Code.warning((Throwable)e);
                }
                catch (Error e) {
                    Code.warning((Throwable)e);
                    mbean = null;
                }
                catch (Exception e) {
                    Code.warning((Throwable)e);
                    mbean = null;
                }
                if (jmx) {
                    if (interfaces != null) {
                        if (++i >= interfaces.length) {
                            interfaces = null;
                            oClass = oClass.getSuperclass();
                        }
                    } else {
                        interfaces = oClass.getInterfaces();
                        i = 0;
                        if (interfaces == null || interfaces.length == 0) {
                            interfaces = null;
                            oClass = oClass.getSuperclass();
                        }
                    }
                }
                jmx = !jmx;
            }
            return null;
        }
        catch (Exception e) {
            Code.ignore((Throwable)e);
            return null;
        }
    }

    public ModelMBeanImpl() {
    }

    public ModelMBeanImpl(Object proxyObject) {
        try {
            this.setManagedResource(proxyObject, "objectReference");
        }
        catch (Exception e) {
            Code.warning((Throwable)e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    public static String getDefaultDomain() {
        return __defaultDomain;
    }

    public static void setDefaultDomain(String d) {
        __defaultDomain = d;
    }

    public MBeanServer getMBeanServer() {
        return this._mBeanServer;
    }

    public ObjectName getObjectName() {
        return this._objectName;
    }

    public Object getManagedResource() {
        return this._object;
    }

    public void setManagedResource(Object proxyObject, String type) throws MBeanException, RuntimeOperationsException, InstanceNotFoundException, InvalidTargetObjectTypeException {
        if (proxyObject == null) {
            proxyObject = null;
            return;
        }
        Code.debug((String)"setManagedResource");
        if (!"objectreference".equalsIgnoreCase(type)) {
            throw new InvalidTargetObjectTypeException(type);
        }
        if (this._object == null) {
            this._object = proxyObject;
            this.defineManagedResource();
        } else {
            this._object = proxyObject;
        }
    }

    protected void defineManagedResource() {
    }

    public void setModelMBeanInfo(ModelMBeanInfo info) throws MBeanException, RuntimeOperationsException {
        throw new Error("setModelMBeanInfo not supported");
    }

    public synchronized void defineAttribute(String name) {
        this.defineAttribute(name, true, false);
    }

    public synchronized void defineAttribute(String name, boolean writable) {
        this.defineAttribute(name, writable, false);
    }

    public synchronized void defineAttribute(String name, boolean writable, boolean onMBean) {
        this._dirty = true;
        String uName = name.substring(0, 1).toUpperCase() + name.substring(1);
        name = Introspector.decapitalize(name);
        Class<?> oClass = onMBean ? this.getClass() : this._object.getClass();
        Class<?> type = null;
        Method getter = null;
        Method setter = null;
        Method[] methods = oClass.getMethods();
        int m = 0;
        while (m < methods.length) {
            if ((methods[m].getModifiers() & 1) != 0) {
                if (methods[m].getName().equals("get" + uName) && methods[m].getParameterTypes().length == 0) {
                    if (getter != null) {
                        throw new IllegalArgumentException("Multiple getters for attr " + name);
                    }
                    getter = methods[m];
                    if (type != null && !type.equals(methods[m].getReturnType())) {
                        throw new IllegalArgumentException("Type conflict for attr " + name);
                    }
                    type = methods[m].getReturnType();
                }
                if (methods[m].getName().equals("is" + uName) && methods[m].getParameterTypes().length == 0) {
                    if (getter != null) {
                        throw new IllegalArgumentException("Multiple getters for attr " + name);
                    }
                    getter = methods[m];
                    if (type != null && !type.equals(methods[m].getReturnType())) {
                        throw new IllegalArgumentException("Type conflict for attr " + name);
                    }
                    type = methods[m].getReturnType();
                }
                if (writable && methods[m].getName().equals("set" + uName) && methods[m].getParameterTypes().length == 1) {
                    if (setter != null) {
                        throw new IllegalArgumentException("Multiple setters for attr " + name);
                    }
                    setter = methods[m];
                    if (type != null && !type.equals(methods[m].getParameterTypes()[0])) {
                        throw new IllegalArgumentException("Type conflict for attr " + name);
                    }
                    type = methods[m].getParameterTypes()[0];
                }
            }
            ++m;
        }
        if (getter == null && setter == null) {
            throw new IllegalArgumentException("No getter or setters found for " + name);
        }
        try {
            this._getter.put(name, getter);
            this._setter.put(name, setter);
            this._attributes.add(new ModelMBeanAttributeInfo(name, this.findDescription(name), getter, setter));
        }
        catch (Exception e) {
            Code.warning((Throwable)e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    public synchronized void defineAttribute(ModelMBeanAttributeInfo attrInfo) {
        if (this._object == null) {
            throw new IllegalStateException("No Object");
        }
        this._dirty = true;
        String name = attrInfo.getName();
        String uName = name.substring(0, 1).toUpperCase() + name.substring(1);
        Class<?> oClass = this._object.getClass();
        try {
            Class<?> type = TypeUtil.fromName((String)attrInfo.getType());
            if (type == null) {
                type = Thread.currentThread().getContextClassLoader().loadClass(attrInfo.getType());
            }
            Method getter = null;
            Method setter = null;
            if (attrInfo.isReadable()) {
                getter = oClass.getMethod((attrInfo.isIs() ? "is" : "get") + uName, null);
            }
            if (attrInfo.isWritable()) {
                setter = oClass.getMethod("set" + uName, type);
            }
            this._getter.put(name, getter);
            this._setter.put(name, setter);
            this._attributes.add(attrInfo);
        }
        catch (Exception e) {
            Code.warning((Throwable)e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    public synchronized void defineOperation(String name, int impact) {
        this.defineOperation(name, null, impact);
    }

    public synchronized void defineOperation(String name, String[] signature, int impact) {
        this._dirty = true;
        Class<?> oClass = this._object.getClass();
        if (signature == null) {
            signature = new String[]{};
        }
        try {
            Class[] types = new Class[signature.length];
            MBeanParameterInfo[] pInfo = new MBeanParameterInfo[signature.length];
            String methodKey = name + "(";
            int i = 0;
            while (i < signature.length) {
                Class<?> type = TypeUtil.fromName((String)signature[i]);
                if (type == null) {
                    type = Thread.currentThread().getContextClassLoader().loadClass(signature[i]);
                }
                types[i] = type;
                signature[i] = type.isPrimitive() ? TypeUtil.toName(type) : signature[i];
                methodKey = methodKey + (i > 0 ? "," : "") + signature[i];
                ++i;
            }
            methodKey = methodKey + ")";
            int i2 = 0;
            while (i2 < signature.length) {
                String description = this.findDescription(methodKey + "[" + i2 + "]");
                int colon = description.indexOf(":");
                if (colon < 0) {
                    description = "param" + i2 + ":" + description;
                    colon = description.indexOf(":");
                }
                pInfo[i2] = new MBeanParameterInfo(description.substring(0, colon).trim(), signature[i2], description.substring(colon + 1).trim());
                ++i2;
            }
            Method method = oClass.getMethod(name, types);
            Class<?> returnClass = method.getReturnType();
            this._method.put(methodKey, method);
            this._operations.add(new ModelMBeanOperationInfo(name, this.findDescription(methodKey), pInfo, returnClass.isPrimitive() ? TypeUtil.toName(returnClass) : returnClass.getName(), impact));
        }
        catch (Exception e) {
            Code.warning((String)("operation " + name), (Throwable)e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    public synchronized void defineOperation(ModelMBeanOperationInfo opInfo) {
        this._dirty = true;
        Class<?> oClass = this._object.getClass();
        try {
            MBeanParameterInfo[] pInfo = opInfo.getSignature();
            Class[] types = new Class[pInfo.length];
            String method = opInfo.getName() + "(";
            int i = 0;
            while (i < pInfo.length) {
                Class<?> type = TypeUtil.fromName((String)pInfo[i].getType());
                if (type == null) {
                    type = Thread.currentThread().getContextClassLoader().loadClass(pInfo[i].getType());
                }
                types[i] = type;
                method = method + (i > 0 ? "," : "") + pInfo[i].getType();
                ++i;
            }
            method = method + ")";
            this._method.put(method, oClass.getMethod(opInfo.getName(), types));
            this._operations.add(opInfo);
        }
        catch (Exception e) {
            Code.warning((Throwable)e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    public synchronized MBeanInfo getMBeanInfo() {
        Code.debug((String)"getMBeanInfo");
        if (this._dirty) {
            this._dirty = false;
            ModelMBeanAttributeInfo[] attributes = this._attributes.toArray(new ModelMBeanAttributeInfo[0]);
            ModelMBeanOperationInfo[] operations = this._operations.toArray(new ModelMBeanOperationInfo[0]);
            ModelMBeanNotificationInfo[] notifications = this._notifications.toArray(new ModelMBeanNotificationInfo[0]);
            this._beanInfo = new ModelMBeanInfoSupport(this._object.getClass().getName(), this.findDescription(null), attributes, null, operations, notifications);
        }
        return this._beanInfo;
    }

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Code.debug((Object)"getAttribute ", (Object)name);
        Method getter = (Method)this._getter.get(name);
        if (getter == null) {
            throw new AttributeNotFoundException(name);
        }
        try {
            Object o = this._object;
            if (getter.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            return getter.invoke(o, null);
        }
        catch (IllegalAccessException e) {
            Code.warning((Throwable)e);
            throw new AttributeNotFoundException(e.toString());
        }
        catch (InvocationTargetException e) {
            Code.warning((Throwable)e);
            throw new ReflectionException((Exception)e.getTargetException());
        }
    }

    public AttributeList getAttributes(String[] names) {
        Code.debug((String)"getAttributes");
        AttributeList results = new AttributeList(names.length);
        int i = 0;
        while (i < names.length) {
            try {
                results.add(new Attribute(names[i], this.getAttribute(names[i])));
            }
            catch (Exception e) {
                Code.warning((Throwable)e);
            }
            ++i;
        }
        return results;
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attr == null) {
            return;
        }
        Code.debug((Object)"setAttribute ", (Object)attr.getName(), (Object)"=", (Object)attr.getValue());
        Method setter = (Method)this._setter.get(attr.getName());
        if (setter == null) {
            throw new AttributeNotFoundException(attr.getName());
        }
        try {
            Object o = this._object;
            if (setter.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            setter.invoke(o, attr.getValue());
        }
        catch (IllegalAccessException e) {
            Code.warning((Throwable)e);
            throw new AttributeNotFoundException(e.toString());
        }
        catch (InvocationTargetException e) {
            Code.warning((Throwable)e);
            throw new ReflectionException((Exception)e.getTargetException());
        }
    }

    public AttributeList setAttributes(AttributeList attrs) {
        Code.debug((String)"setAttributes");
        AttributeList results = new AttributeList(attrs.size());
        Iterator iter = attrs.iterator();
        while (iter.hasNext()) {
            try {
                Attribute attr = (Attribute)iter.next();
                this.setAttribute(attr);
                results.add(new Attribute(attr.getName(), this.getAttribute(attr.getName())));
            }
            catch (Exception e) {
                Code.warning((Throwable)e);
            }
        }
        return results;
    }

    public Object invoke(String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Code.debug((Object)"invoke ", (Object)name);
        String methodKey = name + "(";
        int i = 0;
        while (i < signature.length) {
            methodKey = methodKey + (i > 0 ? "," : "") + signature[i];
            ++i;
        }
        methodKey = methodKey + ")";
        try {
            Method method = (Method)this._method.get(methodKey);
            if (method == null) {
                throw new NoSuchMethodException(methodKey);
            }
            return method.invoke(this._object, params);
        }
        catch (NoSuchMethodException e) {
            Code.warning((Throwable)e);
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            Code.warning((Throwable)e);
            throw new MBeanException(e);
        }
        catch (InvocationTargetException e) {
            Code.warning((Throwable)e);
            throw new ReflectionException((Exception)e.getTargetException());
        }
    }

    public void load() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        Code.debug((String)"load");
    }

    public void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        Code.debug((String)"store");
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        Code.debug((String)"addNotificationListener");
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        Code.debug((String)"getNotificationInfo");
        return null;
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        Code.debug((String)"removeNotificationListener");
    }

    public void addAttributeChangeNotificationListener(NotificationListener listener, String name, Object handback) throws MBeanException, RuntimeOperationsException, IllegalArgumentException {
        Code.debug((String)"addAttributeChangeNotificationListener");
    }

    public void removeAttributeChangeNotificationListener(NotificationListener listener, String name) throws MBeanException, RuntimeOperationsException, ListenerNotFoundException {
        Code.debug((String)"removeAttributeChangeNotificationListener");
    }

    public void sendAttributeChangeNotification(Attribute oldAttr, Attribute newAttr) throws MBeanException, RuntimeOperationsException {
        Code.debug((String)"sendAttributeChangeNotification");
    }

    public void sendAttributeChangeNotification(AttributeChangeNotification notify) throws MBeanException, RuntimeOperationsException {
        Code.debug((String)"sendAttributeChangeNotification");
    }

    public void sendNotification(String notify) throws MBeanException, RuntimeOperationsException {
        Code.debug((String)"sendNotification");
    }

    public void sendNotification(Notification notify) throws MBeanException, RuntimeOperationsException {
        Code.debug((String)"sendNotification");
    }

    private String findDescription(String key) {
        Class<?> lookIn = this.getClass();
        String[] objectNames = new String[3];
        objectNames[0] = this._object.getClass().getName();
        if (objectNames[0].indexOf(".") >= 0) {
            objectNames[1] = objectNames[0].substring(objectNames[0].lastIndexOf(".") + 1);
        }
        while (lookIn != null) {
            block15: {
                String pkg = lookIn.getName();
                int lastDot = pkg.lastIndexOf(".");
                if (lastDot > 0) {
                    objectNames[2] = pkg.substring(lastDot + 1);
                    pkg = pkg.substring(0, lastDot);
                } else {
                    objectNames[2] = pkg;
                    pkg = null;
                }
                String resource = pkg == null ? "mbean" : pkg.replace('.', '/') + "/mbean";
                Code.debug((Object)"Look for: ", (Object)resource);
                try {
                    ResourceBundle bundle = ResourceBundle.getBundle(resource, Locale.getDefault(), this._object.getClass().getClassLoader());
                    Code.debug((Object)"Bundle ", (Object)resource);
                    int i = 0;
                    while (i < objectNames.length) {
                        block14: {
                            String name = objectNames[i];
                            if (name != null) {
                                if (name.endsWith("MBean")) {
                                    name = name.substring(0, name.length() - 5);
                                }
                                if (key != null && key.length() > 0) {
                                    name = name + "." + key;
                                }
                                try {
                                    String description = bundle.getString(name);
                                    if (description != null && description.length() > 0) {
                                        return description;
                                    }
                                }
                                catch (Exception e) {
                                    if (!Code.verbose()) break block14;
                                    Code.debug((String)e.toString());
                                }
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    if (!Code.verbose()) break block15;
                    Code.debug((String)e.toString());
                }
            }
            lookIn = lookIn.getSuperclass();
        }
        if (key == null || key.length() == 0) {
            return objectNames[0];
        }
        return key;
    }

    protected ObjectName newObjectName(MBeanServer server) {
        if (this._baseObjectName != null) {
            if (this._baseObjectName.indexOf(58) >= 0) {
                return this.uniqueObjectName(server, this._baseObjectName);
            }
            return this.uniqueObjectName(server, ModelMBeanImpl.getDefaultDomain() + ":" + this._baseObjectName);
        }
        return this.uniqueObjectName(server, ModelMBeanImpl.getDefaultDomain() + ":");
    }

    public void setBaseObjectName(String s) {
        this._baseObjectName = s;
    }

    public String getBaseObjectName() {
        return this._baseObjectName;
    }

    public synchronized ObjectName preRegister(MBeanServer server, ObjectName oName) {
        this._mBeanServer = server;
        this._objectName = oName;
        if (this._objectName == null) {
            try {
                oName = this.newObjectName(server);
            }
            catch (Exception e) {
                Code.warning((Throwable)e);
            }
        }
        Code.debug((Object)"preRegister ", (Object)this._objectName, (Object)" -> ", (Object)oName);
        this._objectName = oName;
        return this._objectName;
    }

    public void postRegister(Boolean ok) {
        if (ok.booleanValue()) {
            Log.event((Object)("Registered " + this._objectName));
        } else {
            this._mBeanServer = null;
            this._objectName = null;
        }
    }

    public void preDeregister() {
        Log.event((Object)("Deregister " + this._objectName));
        this.getComponentMBeans(null, this._components);
        this._components.clear();
    }

    public void postDeregister() {
        this._beanInfo = null;
        this._mBeanServer = null;
        this._object = null;
        this._objectName = null;
        if (this._getter != null) {
            this._getter.clear();
        }
        this._getter = null;
        if (this._setter != null) {
            this._setter.clear();
        }
        this._setter = null;
        if (this._method != null) {
            this._method.clear();
        }
        this._method = null;
        if (this._attributes != null) {
            this._attributes.clear();
        }
        this._attributes = null;
        if (this._operations != null) {
            this._operations.clear();
        }
        this._operations = null;
        if (this._notifications != null) {
            this._notifications.clear();
        }
        this._notifications = null;
    }

    public synchronized ObjectName uniqueObjectName(MBeanServer server, String objectName) {
        return this.uniqueObjectName(server, this._object, objectName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized ObjectName uniqueObjectName(MBeanServer server, Object object, String objectName) {
        if (!objectName.endsWith("=")) {
            String className = object.getClass().getName();
            if (className.indexOf(".") > 0) {
                className = className.substring(className.lastIndexOf(".") + 1);
            }
            if (className.endsWith("MBean")) {
                className = className.substring(0, className.length() - 5);
            }
            if (!objectName.endsWith(":")) {
                objectName = objectName + ",";
            }
            objectName = objectName + className + "=";
        }
        ObjectName oName = null;
        try {
            do {
                Integer id;
                if ((id = (Integer)__objectId.get(objectName)) == null) {
                    id = new Integer(0);
                }
                oName = new ObjectName(objectName + id);
                id = new Integer(id + 1);
                __objectId.put(objectName, id);
                if (server == null) return oName;
            } while (server.isRegistered(oName));
            return oName;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.warning((Object)e);
        }
        return oName;
    }

    protected ObjectName[] getComponentMBeans(Object[] components, Map map) {
        if (map == null) {
            map = this._components;
        }
        ObjectName[] beans = null;
        if (components == null) {
            beans = new ObjectName[]{};
        } else {
            beans = new ObjectName[components == null ? 0 : components.length];
            int i = 0;
            while (i < components.length) {
                ObjectName on = (ObjectName)map.get(components[i]);
                if (on == null) {
                    ModelMBean mbean = ModelMBeanImpl.mbeanFor(components[i]);
                    if (mbean == null) {
                        Code.warning((String)("No mbean for " + components[i]));
                    } else {
                        try {
                            if (mbean instanceof ModelMBeanImpl) {
                                ((ModelMBeanImpl)mbean).setBaseObjectName(this.getObjectName().toString());
                                on = this.getMBeanServer().registerMBean(mbean, null).getObjectName();
                            } else {
                                on = this.uniqueObjectName(this.getMBeanServer(), components[i], this.getObjectName().toString());
                                on = this.getMBeanServer().registerMBean(mbean, on).getObjectName();
                            }
                            map.put(components[i], on);
                        }
                        catch (Exception e) {
                            Code.warning((Throwable)e);
                        }
                    }
                }
                beans[i] = on;
                ++i;
            }
        }
        if (components == null || map.size() > components.length) {
            Object[] to_delete = new Object[map.size() - beans.length];
            int d = 0;
            Iterator iter = map.keySet().iterator();
            block5: while (iter.hasNext()) {
                Object bean = iter.next();
                if (components != null) {
                    int i = 0;
                    while (i < components.length) {
                        if (components[i] == bean) continue block5;
                        ++i;
                    }
                }
                to_delete[d++] = bean;
            }
            while (d-- > 0) {
                try {
                    this.getMBeanServer().unregisterMBean((ObjectName)map.remove(to_delete[d]));
                }
                catch (Exception e) {
                    Code.warning((Throwable)e);
                }
            }
        }
        return beans;
    }
}

