/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.common;

import com.p6spy.engine.common.KeyValue;
import com.p6spy.engine.common.OptionReloader;
import com.p6spy.engine.common.P6LogQuery;
import com.p6spy.engine.common.P6Options;
import com.p6spy.engine.common.P6Util;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

public class P6SpyProperties {
    protected static final String OPTIONS_FILE_PROPERTY = "spy.properties";
    protected static final String DFLT_OPTIONS_FILE = "spy.properties";
    protected static String SPY_PROPERTIES_FILE;
    protected static long propertiesLastModified;
    protected static String propertiesPath;
    public Properties properties;

    public static void initMethod() {
        P6SpyProperties.setSpyProperties(System.getProperty("spy.properties", "spy.properties"));
    }

    public P6SpyProperties() {
        File propertiesFile = new File(propertiesPath);
        if (propertiesFile.exists()) {
            long lastModified = propertiesFile.lastModified();
            if (lastModified != propertiesLastModified) {
                propertiesLastModified = lastModified;
                this.properties = P6Util.loadProperties(SPY_PROPERTIES_FILE);
            } else {
                this.properties = null;
            }
        }
    }

    public boolean isNewProperties() {
        return this.properties != null;
    }

    public static String getPropertiesPath() {
        return propertiesPath;
    }

    public static void setSpyProperties(String _properties) {
        SPY_PROPERTIES_FILE = _properties == null ? "spy.properties" : _properties;
        propertiesPath = P6SpyProperties.findPropertiesPath();
        propertiesLastModified = -1L;
    }

    protected static String findPropertiesPath() {
        File propertiesFile;
        String propertiesPath = P6Util.classPathFile(SPY_PROPERTIES_FILE);
        if (propertiesPath != null && (propertiesFile = new File(propertiesPath)).exists()) {
            return propertiesPath;
        }
        return null;
    }

    public static void saveProperties() {
        Properties props = new Properties();
        Iterator it = OptionReloader.iterator();
        while (it.hasNext()) {
            P6Options opts = (P6Options)it.next();
            Method[] allMethods = opts.getClass().getDeclaredMethods();
            Object[] noParams = new Class[]{};
            int i = 0;
            while (i < allMethods.length) {
                Class<?>[] params;
                Method m = allMethods[i];
                if (m.getName().startsWith("get") && (params = m.getParameterTypes()).length == 0) {
                    String propertyName = m.getName().substring(3);
                    propertyName = propertyName.toLowerCase();
                    try {
                        Object rv = m.invoke((Object)opts, noParams);
                        props.setProperty(propertyName, rv.toString());
                        P6LogQuery.logInfo("added property '" + propertyName + "' with value of '" + rv.toString() + "'");
                    }
                    catch (Exception e) {
                        P6LogQuery.logError("Could not get property value " + propertyName + " in class " + opts.getClass().getName() + " because of error " + e);
                    }
                }
                ++i;
            }
        }
        File propertiesFile = new File(propertiesPath);
        try {
            FileOutputStream out = new FileOutputStream(propertiesFile, false);
            props.store(out, "P6Spy configuration");
            out.close();
            P6LogQuery.logInfo("successfully saved properties to file " + propertiesFile);
        }
        catch (Exception e) {
            P6LogQuery.logError("Could save to property file " + propertiesFile + " because of error " + e);
        }
    }

    public Properties forceReadProperties() {
        File propertiesFile = new File(propertiesPath);
        if (propertiesFile.exists()) {
            long lastModified = propertiesFile.lastModified();
            this.properties = P6Util.loadProperties(SPY_PROPERTIES_FILE);
        }
        return this.properties;
    }

    public void setClassValues(Class klass) {
        String value;
        if (this.properties == null) {
            return;
        }
        try {
            ArrayList allMethods = P6Util.findAllMethods(klass);
            Iterator i = allMethods.iterator();
            while (i.hasNext()) {
                String methodName = ((String)i.next()).substring(3);
                value = (String)this.properties.get(methodName.toLowerCase());
                P6Util.dynamicSet(klass, "set" + methodName, value == null ? null : value.trim());
            }
        }
        catch (IntrospectionException e) {
            P6LogQuery.logError("Could not set property values due to IntrospectionException");
        }
        Collection list = P6Util.dynamicGetOptions(klass);
        Iterator it = list.iterator();
        P6LogQuery.logInfo("Using properties file: " + propertiesPath);
        while (it.hasNext()) {
            String opt = (String)it.next();
            value = System.getProperty("p6" + opt);
            if (value != null) {
                P6LogQuery.logInfo("Found value in environment: " + opt + ", setting to value: " + value);
                P6Util.dynamicSet(klass, opt, value);
                continue;
            }
            P6LogQuery.logInfo("No value in environment for: " + opt + ", using: " + P6Util.dynamicGet(klass, opt));
        }
    }

    public ArrayList getReverseOrderedList(String prefix) {
        return P6Util.reverseArrayList(this.getOrderedList(prefix));
    }

    public ArrayList getOrderedList(String prefix) {
        ArrayList<String> orderedList = new ArrayList<String>();
        ArrayList list = P6Util.loadProperties(SPY_PROPERTIES_FILE, prefix);
        Iterator j = list.iterator();
        while (j.hasNext()) {
            KeyValue keyValue = (KeyValue)j.next();
            String value = (String)keyValue.getValue();
            orderedList.add(value);
        }
        return orderedList;
    }

    static {
        OPTIONS_FILE_PROPERTY = "spy.properties";
        DFLT_OPTIONS_FILE = "spy.properties";
        propertiesLastModified = -1L;
        P6SpyProperties.initMethod();
    }
}

