/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.outage;

import com.p6spy.engine.common.P6LogQuery;
import com.p6spy.engine.outage.InvocationInfo;
import com.p6spy.engine.outage.P6OutageOptions;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class P6OutageDetector
implements Runnable {
    private Hashtable pendingMessages = new Hashtable();
    private boolean haltThread = false;
    private static P6OutageDetector instance = null;
    private static final boolean debug = true;

    protected P6OutageDetector() {
        P6LogQuery.logDebug("P6Spy - P6OutageDetector has been invoked.");
        P6LogQuery.logDebug("P6Spy - P6OutageOptions.getOutageDetectionIntervalMS() = " + P6OutageOptions.getOutageDetectionIntervalMS());
    }

    public static synchronized P6OutageDetector getInstance() {
        if (instance == null) {
            instance = new P6OutageDetector();
            ThreadGroup group = new ThreadGroup("P6SpyThreadGroup");
            group.setDaemon(true);
            Thread outageThread = new Thread(group, instance, "P6SpyOutageThread");
            outageThread.start();
        }
        return instance;
    }

    public void run() {
        while (!this.haltThread) {
            this.detectOutage();
            try {
                Thread.sleep(P6OutageOptions.getOutageDetectionIntervalMS());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void shutdown() {
        this.haltThread = true;
    }

    public void registerInvocation(Object jdbcObject, long startTime, String category, String ps, String sql) {
        this.pendingMessages.put(jdbcObject, new InvocationInfo(startTime, category, ps, sql));
    }

    public void unregisterInvocation(Object jdbcObject) {
        this.pendingMessages.remove(jdbcObject);
    }

    private void detectOutage() {
        int listSize = this.pendingMessages.size();
        if (listSize == 0) {
            return;
        }
        P6LogQuery.logDebug("P6Spy - detectOutage.pendingMessage.size = " + listSize);
        long currentTime = System.currentTimeMillis();
        long threshold = P6OutageOptions.getOutageDetectionIntervalMS();
        Set keys = this.pendingMessages.keySet();
        Iterator keyIter = keys.iterator();
        while (keyIter.hasNext()) {
            InvocationInfo ii = (InvocationInfo)this.pendingMessages.get(keyIter.next());
            if (ii == null || currentTime - ii.startTime <= threshold) continue;
            P6LogQuery.logDebug("P6Spy - statement exceeded threshold - check log.");
            this.logOutage(ii);
        }
    }

    private void logOutage(InvocationInfo ii) {
        P6LogQuery.logElapsed(-1, ii.startTime, "OUTAGE", ii.preparedStmt, ii.sql);
    }

    static {
        debug = true;
    }
}

