/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.spy;

import com.p6spy.engine.spy.P6ProxyConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class P6PooledConnection
implements PooledConnection {
    private Hashtable eventTargets;
    protected Connection proxyConnection = null;
    protected Connection realConnection;
    public static final int EVENT_TYPE_CLOSE = 1;
    public static final int EVENT_TYPE_ERROR = 2;

    public P6PooledConnection(Connection connection) {
        this.realConnection = connection;
        this.eventTargets = new Hashtable(5);
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.realConnection == null) {
            SQLException sqlException = new SQLException("Pooled Connection has no real connection, must have been closed");
            this.deliverEvent(2, sqlException);
            return null;
        }
        try {
            if (this.proxyConnection != null) {
                this.proxyConnection.close();
            }
            this.proxyConnection = new P6ProxyConnection(this, this.realConnection);
        }
        catch (SQLException sqlException) {
            this.deliverEvent(2, sqlException);
            return null;
        }
        return this.proxyConnection;
    }

    public synchronized void close() throws SQLException {
        this.realConnection.close();
        this.realConnection = null;
        this.deliverEvent(2, null);
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener eventTarget) {
        if (this.eventTargets != null) {
            this.eventTargets.put(eventTarget, eventTarget);
        }
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener eventTarget) {
        if (this.eventTargets != null) {
            this.eventTargets.remove(eventTarget);
        }
    }

    protected synchronized void deliverEvent(int type, SQLException sqlException) {
        if (this.eventTargets == null) {
            return;
        }
        ConnectionEvent event = new ConnectionEvent(this, sqlException);
        Enumeration enumeration = this.eventTargets.elements();
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener eventTarget = (ConnectionEventListener)enumeration.nextElement();
            if (type == 1) {
                eventTarget.connectionClosed(event);
                continue;
            }
            if (type != 2) continue;
            eventTarget.connectionErrorOccurred(event);
        }
    }

    static {
        EVENT_TYPE_CLOSE = 1;
        EVENT_TYPE_ERROR = 2;
    }
}

