/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.sun.jdmk.trace.Trace;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.monitor.MonitorMBean;
import javax.management.monitor.MonitorNotification;

public abstract class Monitor
extends NotificationBroadcasterSupport
implements MonitorMBean,
MBeanRegistration {
    private ObjectName observedObject = null;
    private String observedAttribute = null;
    private long granularityPeriod = 10000L;
    protected MBeanServer server = null;
    protected int alreadyNotified = 0;
    protected static final int RESET_FLAGS_ALREADY_NOTIFIED = 0;
    protected static final int OBSERVED_OBJECT_ERROR_NOTIFIED = 1;
    protected static final int OBSERVED_ATTRIBUTE_ERROR_NOTIFIED = 2;
    protected static final int OBSERVED_ATTRIBUTE_TYPE_ERROR_NOTIFIED = 4;
    protected static final int RUNTIME_ERROR_NOTIFIED = 8;
    protected String dbgTag = "Monitor";
    transient boolean isActive = false;
    transient long sequenceNumber = 0L;

    boolean isTraceOn() {
        return Trace.isSelected(1, 4);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 4, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 4);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 4, string, string2, string3);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (this.isTraceOn()) {
            this.trace("preRegister", "initialize the reference on the MBean server");
        }
        this.server = mBeanServer;
        return objectName;
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
        if (this.isTraceOn()) {
            this.trace("preDeregister", "stop the monitor");
        }
        this.stop();
    }

    public void postDeregister() {
    }

    public abstract void start();

    public abstract void stop();

    public ObjectName getObservedObject() {
        return this.observedObject;
    }

    public void setObservedObject(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            throw new IllegalArgumentException("The object to observe cannot be null.");
        }
        this.observedObject = objectName;
        this.alreadyNotified &= 0xFFFFFFFE;
        this.alreadyNotified &= 0xFFFFFFFD;
        this.alreadyNotified &= 0xFFFFFFFB;
    }

    public String getObservedAttribute() {
        return this.observedAttribute;
    }

    public void setObservedAttribute(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("The attribute to observe cannot be null.");
        }
        this.observedAttribute = string;
        this.alreadyNotified &= 0xFFFFFFFD;
        this.alreadyNotified &= 0xFFFFFFFB;
    }

    public long getGranularityPeriod() {
        return this.granularityPeriod;
    }

    public void setGranularityPeriod(long l) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException("The granularity period must be greater than zero.");
        }
        this.granularityPeriod = l;
    }

    public boolean isActive() {
        return this.isActive;
    }

    void sendNotification(String string, long l, String string2, Object object, Object object2) {
        MonitorNotification monitorNotification = null;
        Monitor monitor = this;
        synchronized (monitor) {
            ++this.sequenceNumber;
            if (this.isTraceOn()) {
                this.trace("sendNotification", "send notification:\n\tNotification observed object = " + this.observedObject + "\n\tNotification observed attribute = " + this.observedAttribute + "\n\tNotification derived gauge = " + object);
            }
            monitorNotification = new MonitorNotification(string, this, this.sequenceNumber, l, string2, this.observedObject, this.observedAttribute, object, object2);
        }
        this.sendNotification(monitorNotification);
    }
}

