/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public final class SimpleType
extends OpenType
implements Serializable {
    static final long serialVersionUID = 2215577471957694503L;
    public static SimpleType VOID;
    public static SimpleType BOOLEAN;
    public static SimpleType CHARACTER;
    public static SimpleType BYTE;
    public static SimpleType SHORT;
    public static SimpleType INTEGER;
    public static SimpleType LONG;
    public static SimpleType FLOAT;
    public static SimpleType DOUBLE;
    public static SimpleType STRING;
    public static SimpleType BIGDECIMAL;
    public static SimpleType BIGINTEGER;
    public static SimpleType OBJECTNAME;
    private transient Integer myHashCode = null;
    private transient String myToString = null;

    private SimpleType(String string) throws OpenDataException {
        super(string, string, string);
    }

    public boolean isValue(Object object) {
        if (object == null) {
            return false;
        }
        return this.getClassName().equals(object.getClass().getName());
    }

    public boolean equals(Object object) {
        SimpleType simpleType;
        if (object == null) {
            return false;
        }
        try {
            simpleType = (SimpleType)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.getClassName().equals(simpleType.getClassName());
    }

    public int hashCode() {
        if (this.myHashCode == null) {
            this.myHashCode = new Integer(this.getClassName().hashCode());
        }
        return this.myHashCode;
    }

    public String toString() {
        if (this.myToString == null) {
            this.myToString = this.getClass().getName() + "(name=" + this.getTypeName() + ")";
        }
        return this.myToString;
    }

    public Object readResolve() throws ObjectStreamException {
        String string = super.getClassName();
        if (string.equals("java.lang.Void")) {
            return VOID;
        }
        if (string.equals("java.lang.Boolean")) {
            return BOOLEAN;
        }
        if (string.equals("java.lang.Character")) {
            return CHARACTER;
        }
        if (string.equals("java.lang.Byte")) {
            return BYTE;
        }
        if (string.equals("java.lang.Short")) {
            return SHORT;
        }
        if (string.equals("java.lang.Integer")) {
            return INTEGER;
        }
        if (string.equals("java.lang.Long")) {
            return LONG;
        }
        if (string.equals("java.lang.Float")) {
            return FLOAT;
        }
        if (string.equals("java.lang.Double")) {
            return DOUBLE;
        }
        if (string.equals("java.lang.String")) {
            return STRING;
        }
        if (string.equals("java.math.BigDecimal")) {
            return BIGDECIMAL;
        }
        if (string.equals("java.math.BigInteger")) {
            return BIGINTEGER;
        }
        if (string.equals("javax.management.ObjectName")) {
            return OBJECTNAME;
        }
        throw new InvalidObjectException("Invalid class name: " + string);
    }

    static {
        try {
            VOID = new SimpleType("java.lang.Void");
        }
        catch (OpenDataException openDataException) {
            VOID = null;
        }
        try {
            BOOLEAN = new SimpleType("java.lang.Boolean");
        }
        catch (OpenDataException openDataException) {
            BOOLEAN = null;
        }
        try {
            CHARACTER = new SimpleType("java.lang.Character");
        }
        catch (OpenDataException openDataException) {
            CHARACTER = null;
        }
        try {
            BYTE = new SimpleType("java.lang.Byte");
        }
        catch (OpenDataException openDataException) {
            BYTE = null;
        }
        try {
            SHORT = new SimpleType("java.lang.Short");
        }
        catch (OpenDataException openDataException) {
            SHORT = null;
        }
        try {
            INTEGER = new SimpleType("java.lang.Integer");
        }
        catch (OpenDataException openDataException) {
            INTEGER = null;
        }
        try {
            LONG = new SimpleType("java.lang.Long");
        }
        catch (OpenDataException openDataException) {
            LONG = null;
        }
        try {
            FLOAT = new SimpleType("java.lang.Float");
        }
        catch (OpenDataException openDataException) {
            FLOAT = null;
        }
        try {
            DOUBLE = new SimpleType("java.lang.Double");
        }
        catch (OpenDataException openDataException) {
            DOUBLE = null;
        }
        try {
            STRING = new SimpleType("java.lang.String");
        }
        catch (OpenDataException openDataException) {
            STRING = null;
        }
        try {
            BIGDECIMAL = new SimpleType("java.math.BigDecimal");
        }
        catch (OpenDataException openDataException) {
            BIGDECIMAL = null;
        }
        try {
            BIGINTEGER = new SimpleType("java.math.BigInteger");
        }
        catch (OpenDataException openDataException) {
            BIGINTEGER = null;
        }
        try {
            OBJECTNAME = new SimpleType("javax.management.ObjectName");
        }
        catch (OpenDataException openDataException) {
            OBJECTNAME = null;
        }
    }
}

