/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.OutputStream;
import org.mortbay.http.HttpResponse;
import org.mortbay.util.Code;
import org.mortbay.util.StringUtil;

public class MultiPartResponse {
    private static byte[] __CRLF;
    private static byte[] __DASHDASH;
    private String boundary;
    private byte[] boundaryBytes;
    private OutputStream out = null;
    private boolean inPart = false;

    private MultiPartResponse() {
        try {
            this.boundary = "org.mortbay.http.MultiPartResponse.boundary." + Long.toString(System.currentTimeMillis(), 36);
            this.boundaryBytes = this.boundary.getBytes(StringUtil.__ISO_8859_1);
        }
        catch (Exception e) {
            Code.fail(e);
        }
    }

    public String getBoundary() {
        return this.boundary;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public MultiPartResponse(OutputStream out) throws IOException {
        this();
        this.out = out;
        this.inPart = false;
    }

    public MultiPartResponse(HttpResponse response) throws IOException {
        this();
        response.setField("Content-Type", "multipart/mixed;boundary=" + this.boundary);
        this.out = response.getOutputStream();
        this.inPart = false;
    }

    public void startPart(String contentType) throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = true;
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__CRLF);
        this.out.write(("Content-type: " + contentType).getBytes(StringUtil.__ISO_8859_1));
        this.out.write(__CRLF);
        this.out.write(__CRLF);
    }

    public void startPart(String contentType, String[] headers) throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = true;
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__CRLF);
        this.out.write(("Content-type: " + contentType).getBytes(StringUtil.__ISO_8859_1));
        this.out.write(__CRLF);
        int i = 0;
        while (headers != null && i < headers.length) {
            this.out.write(headers[i].getBytes(StringUtil.__ISO_8859_1));
            this.out.write(__CRLF);
            ++i;
        }
        this.out.write(__CRLF);
    }

    public void close() throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__DASHDASH);
        this.out.write(__CRLF);
        this.inPart = false;
    }

    static {
        try {
            __CRLF = "\r\n".getBytes(StringUtil.__ISO_8859_1);
            __DASHDASH = "--".getBytes(StringUtil.__ISO_8859_1);
        }
        catch (Exception e) {
            Code.fail(e);
        }
    }
}

