/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.core;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.enhydra.jdbc.util.JdbcUtil;

public abstract class CoreStatement
extends JdbcUtil
implements Statement {
    protected Statement statement;

    public void addBatch(String s) throws SQLException {
        try {
            this.statement.addBatch(s);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void cancel() throws SQLException {
        try {
            this.statement.cancel();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void clearBatch() throws SQLException {
        try {
            this.statement.clearBatch();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.statement.clearWarnings();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void close() throws SQLException {
        if (this.statement != null) {
            this.statement.close();
        }
    }

    public boolean execute(String s) throws SQLException {
        try {
            return this.statement.execute(s);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return false;
        }
    }

    public int[] executeBatch() throws SQLException {
        try {
            return this.statement.executeBatch();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public ResultSet executeQuery(String s) throws SQLException {
        try {
            return this.statement.executeQuery(s);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public int executeUpdate(String s) throws SQLException {
        try {
            return this.statement.executeUpdate(s);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            return this.statement.getConnection();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            return this.statement.getFetchDirection();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            return this.statement.getFetchSize();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            return this.statement.getMaxFieldSize();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            return this.statement.getMaxRows();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    public boolean getMoreResults() throws SQLException {
        try {
            return this.statement.getMoreResults();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return false;
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            return this.statement.getQueryTimeout();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            return this.statement.getResultSet();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.statement.getResultSetConcurrency();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            return this.statement.getResultSetType();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    public int getUpdateCount() throws SQLException {
        try {
            return this.statement.getUpdateCount();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return 0;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.statement.getWarnings();
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public void setCursorName(String name) throws SQLException {
        try {
            this.statement.setCursorName(name);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            this.statement.setEscapeProcessing(enable);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        try {
            this.statement.setFetchDirection(direction);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        try {
            this.statement.setFetchSize(rows);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void setMaxFieldSize(int max) throws SQLException {
        try {
            this.statement.setMaxFieldSize(max);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void setMaxRows(int max) throws SQLException {
        try {
            this.statement.setMaxRows(max);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            this.statement.setQueryTimeout(seconds);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public abstract void preInvoke() throws SQLException;

    public abstract void catchInvoke(SQLException var1) throws SQLException;
}

