/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.http.HttpContext;
import org.mortbay.http.InclusiveByteRange;
import org.mortbay.http.MultiPartResponse;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.util.CachedResource;
import org.mortbay.util.Code;
import org.mortbay.util.IO;
import org.mortbay.util.Resource;
import org.mortbay.util.URI;

public class Default
extends HttpServlet {
    private HttpContext _httpContext;
    private ServletHandler _servletHandler;
    private String _AllowString = "GET, POST, HEAD, OPTIONS, TRACE";
    private boolean _acceptRanges = true;
    private boolean _dirAllowed;
    private boolean _putAllowed;
    private boolean _delAllowed;
    private boolean _redirectWelcomeFiles;
    private int _minGzipLength = -1;
    private Resource _resourceBase;

    public void init() throws UnavailableException {
        ServletContext config = this.getServletContext();
        this._servletHandler = ((ServletHandler.Context)config).getServletHandler();
        this._httpContext = this._servletHandler.getHttpContext();
        this._acceptRanges = this.getInitBoolean("acceptRanges");
        this._dirAllowed = this.getInitBoolean("dirAllowed");
        this._putAllowed = this.getInitBoolean("putAllowed");
        this._delAllowed = this.getInitBoolean("delAllowed");
        this._redirectWelcomeFiles = this.getInitBoolean("redirectWelcome");
        this._minGzipLength = this.getInitInt("minGzipLength");
        String rrb = this.getInitParameter("relativeResourceBase");
        if (rrb != null) {
            try {
                this._resourceBase = this._httpContext.getBaseResource().addPath(rrb);
            }
            catch (Exception e) {
                Code.warning(e);
                throw new UnavailableException(e.toString());
            }
        }
        String rb = this.getInitParameter("resourceBase");
        if (rrb != null && rb != null) {
            throw new UnavailableException("resourceBase & relativeResourceBase");
        }
        if (rb != null) {
            try {
                this._resourceBase = Resource.newResource(rb);
            }
            catch (Exception e) {
                Code.warning(e);
                throw new UnavailableException(e.toString());
            }
        }
        if (this._putAllowed) {
            this._AllowString = this._AllowString + ", PUT";
        }
        if (this._delAllowed) {
            this._AllowString = this._AllowString + ", DELETE";
        }
        if (this._putAllowed && this._delAllowed) {
            this._AllowString = this._AllowString + ", MOVE";
        }
    }

    private boolean getInitBoolean(String name) {
        String value = this.getInitParameter(name);
        return value != null && value.length() > 0 && (value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1"));
    }

    private int getInitInt(String name) {
        String value = this.getInitParameter(name);
        if (value != null && value.length() > 0) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    protected Resource getResource(String pathInContext) throws IOException {
        if (this._resourceBase == null) {
            return this._httpContext.getResource(pathInContext);
        }
        return this._resourceBase.addPath(pathInContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInContext = URI.addPaths((String)request.getAttribute("javax.servlet.include.path_info"), (String)request.getAttribute("javax.servlet.include.servlet_path"));
        if (pathInContext == null) {
            pathInContext = URI.addPaths(request.getServletPath(), request.getPathInfo());
        }
        boolean endsWithSlash = pathInContext.endsWith("/");
        Resource resource = this.getResource(pathInContext);
        String method = request.getMethod();
        if (this._AllowString.indexOf(method) < 0) {
            Code.debug((Object)"Method not allowed: ", (Object)method);
            if (resource != null && resource.exists()) {
                response.setHeader("Allow", this._AllowString);
                response.sendError(405);
                return;
            }
            response.sendError(404);
            return;
        }
        try {
            try {
                if (Code.debug()) {
                    Code.debug(method, " PATH=", pathInContext, " RESOURCE=", resource);
                }
                if (method.equals("GET") || method.equals("POST") || method.equals("HEAD")) {
                    this.handleGet(request, response, pathInContext, resource, endsWithSlash);
                } else if (this._putAllowed && method.equals("PUT")) {
                    this.handlePut(request, response, pathInContext, resource);
                } else if (this._delAllowed && method.equals("DELETE")) {
                    this.handleDelete(request, response, pathInContext, resource);
                } else if (this._putAllowed && this._delAllowed && method.equals("MOVE")) {
                    this.handleMove(request, response, pathInContext, resource);
                } else if (method.equals("OPTIONS")) {
                    this.handleOptions(request, response);
                } else if (method.equals("TRACE")) {
                    this._servletHandler.handleTrace(request, response);
                } else {
                    Code.debug("Unknown action:" + method);
                    try {
                        if (resource.exists()) {
                            response.sendError(501);
                        } else {
                            this._servletHandler.notFound(request, response);
                        }
                    }
                    catch (Exception e) {
                        Code.ignore(e);
                    }
                }
                Object var9_9 = null;
                if (resource == null) return;
            }
            catch (IllegalArgumentException e) {
                Code.ignore(e);
                Object var9_10 = null;
                if (resource == null) return;
                if (resource instanceof CachedResource) return;
                resource.release();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (resource == null) throw throwable;
            if (resource instanceof CachedResource) throw throwable;
            resource.release();
            throw throwable;
        }
        if (resource instanceof CachedResource) return;
        resource.release();
    }

    public void handleGet(HttpServletRequest request, HttpServletResponse response, String pathInContext, Resource resource, boolean endsWithSlash) throws ServletException, IOException {
        Code.debug((Object)"handleGet ", (Object)resource);
        if (resource == null || !resource.exists()) {
            response.sendError(404);
        } else if (resource.isDirectory()) {
            if (!endsWithSlash && !pathInContext.equals("/")) {
                Code.debug("Redirect to directory/");
                String q = request.getQueryString();
                StringBuffer buf = request.getRequestURL();
                if (q != null && q.length() != 0) {
                    buf.append('?');
                    buf.append(q);
                }
                response.setContentLength(0);
                response.sendRedirect(response.encodeRedirectURL(URI.addPaths(buf.toString(), "/")));
                return;
            }
            String welcome = this._httpContext.getWelcomeFile(resource);
            if (welcome != null) {
                String ipath = URI.addPaths(pathInContext, welcome);
                if (this._redirectWelcomeFiles) {
                    response.setContentLength(0);
                    response.sendRedirect(URI.addPaths(this._httpContext.getContextPath(), ipath));
                } else {
                    RequestDispatcher dispatcher = this._servletHandler.getRequestDispatcher(ipath);
                    dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                }
                return;
            }
            if (!this.passConditionalHeaders(request, response, resource)) {
                return;
            }
            this.sendDirectory(request, response, resource, pathInContext.length() > 1);
        } else {
            if (!this.passConditionalHeaders(request, response, resource)) {
                return;
            }
            this.sendData(request, response, pathInContext, resource);
        }
    }

    public void handlePut(HttpServletRequest request, HttpServletResponse response, String pathInContext, Resource resource) throws ServletException, IOException {
        boolean exists;
        Code.debug((Object)"handlePut ", (Object)resource);
        boolean bl = exists = resource != null && resource.exists();
        if (exists && !this.passConditionalHeaders(request, response, resource)) {
            return;
        }
        if (pathInContext.endsWith("/")) {
            if (!exists) {
                if (!resource.getFile().mkdirs()) {
                    response.sendError(403, "Directories could not be created");
                } else {
                    response.setStatus(201);
                    response.flushBuffer();
                }
            } else {
                response.setStatus(200);
                response.flushBuffer();
            }
        } else {
            try {
                int toRead = request.getContentLength();
                ServletInputStream in = request.getInputStream();
                OutputStream out = resource.getOutputStream();
                if (toRead >= 0) {
                    IO.copy((InputStream)in, out, (long)toRead);
                } else {
                    IO.copy((InputStream)in, out);
                }
                out.close();
                response.setStatus(exists ? 200 : 201);
                response.flushBuffer();
            }
            catch (Exception ex) {
                Code.warning(ex);
                response.sendError(403, ex.getMessage());
            }
        }
    }

    public void handleDelete(HttpServletRequest request, HttpServletResponse response, String pathInContext, Resource resource) throws ServletException, IOException {
        block4: {
            Code.debug((Object)"handleDelete ", (Object)resource);
            if (!resource.exists() || !this.passConditionalHeaders(request, response, resource)) {
                return;
            }
            try {
                if (resource.delete()) {
                    response.setStatus(204);
                    response.flushBuffer();
                    break block4;
                }
                response.sendError(403);
            }
            catch (SecurityException sex) {
                Code.warning(sex);
                response.sendError(403, sex.getMessage());
            }
        }
    }

    public void handleMove(HttpServletRequest request, HttpServletResponse response, String pathInContext, Resource resource) throws ServletException, IOException {
        Code.debug((Object)"handleMove ", (Object)resource);
        if (!resource.exists() || !this.passConditionalHeaders(request, response, resource)) {
            return;
        }
        String newPath = URI.canonicalPath(request.getHeader("new-uri"));
        if (newPath == null) {
            response.sendError(400, "No new-uri");
            return;
        }
        String contextPath = this._httpContext.getContextPath();
        if (contextPath != null && !newPath.startsWith(contextPath)) {
            response.sendError(405, "Not in context");
            return;
        }
        try {
            String newInfo = newPath;
            if (contextPath != null) {
                newInfo = newInfo.substring(contextPath.length());
            }
            Resource newFile = this._httpContext.getBaseResource().addPath(newInfo);
            Code.debug("Moving " + resource + " to " + newFile);
            resource.renameTo(newFile);
            response.setStatus(204);
            response.flushBuffer();
        }
        catch (Exception ex) {
            Code.warning(ex);
            response.sendError(500, "Error:" + ex);
            return;
        }
    }

    public void handleOptions(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ("*".equals(request.getRequestURI())) {
            response.setIntHeader("Content-Length", 0);
            response.setHeader("Allow", this._AllowString);
            response.flushBuffer();
        } else {
            response.sendError(404);
        }
    }

    protected boolean passConditionalHeaders(HttpServletRequest request, HttpServletResponse response, Resource resource) throws IOException {
        if (!request.getMethod().equals("HEAD") && request.getAttribute("javax.servlet.include.request_uri") == null) {
            HttpContext.ResourceMetaData metaData = this._httpContext.getResourceMetaData(resource);
            if (metaData != null) {
                String ifms = request.getHeader("If-Modified-Since");
                String mdlm = metaData.getLastModified();
                if (ifms != null && mdlm != null && ifms.equals(mdlm)) {
                    response.setStatus(304);
                    response.flushBuffer();
                    return false;
                }
            }
            long date = 0L;
            date = request.getDateHeader("If-Unmodified-Since");
            if (date > 0L && resource.lastModified() / 1000L > date / 1000L) {
                response.sendError(412);
                return false;
            }
            date = request.getDateHeader("If-Modified-Since");
            if (date > 0L && resource.lastModified() / 1000L <= date / 1000L) {
                response.setStatus(304);
                response.flushBuffer();
                return false;
            }
        }
        return true;
    }

    protected void sendDirectory(HttpServletRequest request, HttpServletResponse response, Resource resource, boolean parent) throws IOException {
        if (!this._dirAllowed) {
            response.sendError(403);
            return;
        }
        Code.debug("sendDirectory: " + resource);
        byte[] data = null;
        if (resource instanceof CachedResource) {
            data = ((CachedResource)resource).getCachedData();
        }
        if (data == null) {
            String base = URI.addPaths(request.getRequestURI(), "/");
            String dir = resource.getListHTML(base, parent);
            if (dir == null) {
                response.sendError(403, "No directory");
                return;
            }
            data = dir.getBytes("UTF-8");
            if (resource instanceof CachedResource) {
                ((CachedResource)resource).setCachedData(data);
            }
        }
        response.setContentType("text/html; charset=UTF-8");
        response.setContentLength(data.length);
        if (!request.getMethod().equals("HEAD")) {
            response.getOutputStream().write(data);
        }
    }

    protected void sendData(HttpServletRequest request, HttpServletResponse response, String pathInContext, Resource resource) throws IOException {
        Enumeration reqRanges;
        long resLength = resource.length();
        boolean include = request.getAttribute("javax.servlet.include.request_uri") != null;
        Enumeration enumeration = reqRanges = include ? null : request.getHeaders("Range");
        if (reqRanges == null || !reqRanges.hasMoreElements()) {
            Resource data = resource;
            if (!include) {
                Resource gz;
                String accept;
                if (this._minGzipLength > 0 && (accept = request.getHeader("Accept-Encoding")) != null && resLength > (long)this._minGzipLength && !pathInContext.endsWith(".gz") && (gz = this.getResource(pathInContext + ".gz")).exists() && accept.indexOf("gzip") >= 0) {
                    Code.debug((Object)"gzip=", (Object)gz);
                    response.setHeader("Content-Encoding", "gzip");
                    data = gz;
                    resLength = data.length();
                }
                this.writeHeaders(response, resource, resLength);
            }
            ServletOutputStream out = response.getOutputStream();
            data.writeTo((OutputStream)out, 0L, resLength);
            return;
        }
        List ranges = InclusiveByteRange.satisfiableRanges(reqRanges, resLength);
        if (Code.debug()) {
            Code.debug("ranges: " + reqRanges + " == " + ranges);
        }
        if (ranges == null || ranges.size() == 0) {
            Code.debug("no satisfiable ranges");
            this.writeHeaders(response, resource, resLength);
            response.setStatus(416);
            response.setHeader("Content-Range", InclusiveByteRange.to416HeaderRangeString(resLength));
            ServletOutputStream out = response.getOutputStream();
            resource.writeTo((OutputStream)out, 0L, resLength);
            return;
        }
        if (ranges.size() == 1) {
            InclusiveByteRange singleSatisfiableRange = (InclusiveByteRange)ranges.get(0);
            Code.debug("single satisfiable range: " + singleSatisfiableRange);
            long singleLength = singleSatisfiableRange.getSize(resLength);
            this.writeHeaders(response, resource, singleLength);
            response.setStatus(206);
            response.setHeader("Content-Range", singleSatisfiableRange.toHeaderRangeString(resLength));
            ServletOutputStream out = response.getOutputStream();
            resource.writeTo((OutputStream)out, singleSatisfiableRange.getFirst(resLength), singleLength);
            return;
        }
        HttpContext.ResourceMetaData metaData = this._httpContext.getResourceMetaData(resource);
        String encoding = metaData.getEncoding();
        MultiPartResponse multi = new MultiPartResponse((OutputStream)response.getOutputStream());
        response.setStatus(206);
        String ctp = request.getHeader("Request-Range") != null ? "multipart/x-byteranges; boundary=" : "multipart/byteranges; boundary=";
        response.setContentType(ctp + multi.getBoundary());
        InputStream in = resource instanceof CachedResource ? null : resource.getInputStream();
        ServletOutputStream out = response.getOutputStream();
        long pos = 0L;
        int i = 0;
        while (i < ranges.size()) {
            InclusiveByteRange ibr = (InclusiveByteRange)ranges.get(i);
            String header = "Content-Range: " + ibr.toHeaderRangeString(resLength);
            Code.debug((Object)"multi range: ", encoding, (Object)" ", header);
            multi.startPart(encoding, new String[]{header});
            long start = ibr.getFirst(resLength);
            long size = ibr.getSize(resLength);
            if (in != null) {
                if (start < pos) {
                    in.close();
                    in = resource.getInputStream();
                    pos = 0L;
                }
                if (pos < start) {
                    in.skip(start - pos);
                    pos = start;
                }
                IO.copy(in, (OutputStream)out, size);
                pos += size;
            } else {
                resource.writeTo((OutputStream)out, start, size);
            }
            ++i;
        }
        if (in != null) {
            in.close();
        }
        multi.close();
    }

    protected void writeHeaders(HttpServletResponse response, Resource resource, long count) throws IOException {
        HttpContext.ResourceMetaData metaData = this._httpContext.getResourceMetaData(resource);
        response.setContentType(metaData.getEncoding());
        if (count != -1L) {
            if (count == resource.length()) {
                response.setHeader("Content-Length", metaData.getLength());
            } else {
                response.setContentLength((int)count);
            }
        }
        response.setHeader("Last-Modified", metaData.getLastModified());
        if (this._acceptRanges) {
            response.setHeader("Accept-Ranges", "bytes");
        }
    }
}

