/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.enc.java;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.ResolveResult;
import org.objectweb.carol.jndi.enc.java.CompNamingContext;
import org.objectweb.carol.jndi.enc.java.javaNameParser;
import org.objectweb.carol.util.configuration.TraceCarol;

public class javaURLContext
implements Context {
    private static final String URL_PREFIX = "java:comp/";
    private static final String ENV_PREFIX = "env";
    private Hashtable myEnv = null;
    private static NameParser myParser = null;
    private InitialContext ictx = null;
    private Context serverContext = null;
    private Hashtable clBindings = null;
    private ThreadLocal threadContext = new ThreadLocal();

    public javaURLContext(Hashtable env) throws NamingException {
        this.ictx = new InitialContext();
        if (env != null) {
            this.myEnv = (Hashtable)env.clone();
        }
        this.serverContext = new CompNamingContext("server", this.myEnv);
    }

    private String getRelativeName(String name) throws NamingException {
        if (!name.startsWith(URL_PREFIX)) {
            TraceCarol.error("relative name!" + name);
            throw new NameNotFoundException("Invalid name:" + name);
        }
        name = name.substring(URL_PREFIX.length());
        return name;
    }

    private ResolveResult findContextFor(String name) throws NamingException {
        String rname = this.getRelativeName(name);
        Context context = null;
        if (rname.equals("")) {
            context = new javaURLContext(this.myEnv);
        } else if (rname.equals("UserTransaction")) {
            context = this.ictx;
            rname = "javax.transaction.UserTransaction";
        } else if (rname.startsWith(ENV_PREFIX)) {
            context = this.getComponentContext();
            if ((rname = rname.substring(ENV_PREFIX.length())).startsWith("/")) {
                rname = rname.substring(1);
            }
        } else {
            context = this.getServerContext();
        }
        if (context == null) {
            TraceCarol.error("No context for this component");
            throw new NameNotFoundException("No context for this component");
        }
        ResolveResult r = new ResolveResult((Object)context, rname);
        return r;
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public Object lookup(String name) throws NamingException {
        TraceCarol.debugJndiCarol("name=" + name);
        if (name.equals("")) {
            return new javaURLContext(this.myEnv);
        }
        ResolveResult r = this.findContextFor(name);
        Context ctx = (Context)r.getResolvedObj();
        String rname = r.getRemainingName().toString();
        return ctx.lookup(rname);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        TraceCarol.debugJndiCarol("name=" + name);
        ResolveResult r = this.findContextFor(name);
        Context ctx = (Context)r.getResolvedObj();
        String rname = r.getRemainingName().toString();
        ctx.bind(rname, obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        TraceCarol.debugJndiCarol("name=" + name);
        ResolveResult r = this.findContextFor(name);
        Context ctx = (Context)r.getResolvedObj();
        String rname = r.getRemainingName().toString();
        ctx.rebind(rname, obj);
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void unbind(String name) throws NamingException {
        TraceCarol.debugJndiCarol("name=" + name);
        ResolveResult r = this.findContextFor(name);
        Context ctx = (Context)r.getResolvedObj();
        String rname = r.getRemainingName().toString();
        ctx.unbind(rname);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    public void rename(String oldName, String newName) throws NamingException {
        TraceCarol.debugJndiCarol("old name=" + oldName + ", new name=" + newName);
        throw new OperationNotSupportedException("Rename not supported in java:comp");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        TraceCarol.debugJndiCarol("name=" + name);
        ResolveResult r = this.findContextFor(name);
        Context ctx = (Context)r.getResolvedObj();
        String rname = r.getRemainingName().toString();
        return ctx.list(rname);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        TraceCarol.debugJndiCarol("name=" + name);
        ResolveResult r = this.findContextFor(name);
        Context ctx = (Context)r.getResolvedObj();
        String rname = r.getRemainingName().toString();
        return ctx.listBindings(rname);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        TraceCarol.debugJndiCarol("name=" + name);
        throw new OperationNotSupportedException("destroySubcontext not supported in java:comp");
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        TraceCarol.debugJndiCarol("name=" + name);
        throw new OperationNotSupportedException("createSubcontext not supported in java:comp");
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        TraceCarol.debugJndiCarol("name=" + name);
        if (name.equals("")) {
            return new javaURLContext(this.myEnv);
        }
        ResolveResult r = this.findContextFor(name);
        Context ctx = (Context)r.getResolvedObj();
        String rname = r.getRemainingName().toString();
        return ctx.lookupLink(rname);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException("javaURLContext: composeName not supported");
    }

    public String composeName(String name, String prefix) throws NamingException {
        TraceCarol.debugJndiCarol("name=" + name + " prefix= " + prefix);
        throw new OperationNotSupportedException("composeName not supported in java:comp");
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        TraceCarol.debugJndiCarol("property name= " + propName);
        if (this.myEnv == null) {
            this.myEnv = new Hashtable();
        }
        return this.myEnv.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        TraceCarol.debugJndiCarol("property name=" + propName);
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        TraceCarol.debugJndiCarol("");
        if (this.myEnv == null) {
            this.myEnv = new Hashtable();
        }
        return this.myEnv;
    }

    public void close() throws NamingException {
        this.myEnv = null;
    }

    public String getNameInNamespace() throws NamingException {
        TraceCarol.debugJndiCarol("");
        throw new OperationNotSupportedException("getNameInNamespace not implemented in java:comp");
    }

    public Context getComponentContext() {
        Context ctx;
        block6: {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            TraceCarol.debugJndiCarol("class loader=" + cl);
            ctx = null;
            if (cl != null && cl.getParent() != null) {
                ctx = (Context)this.clBindings.get(cl.getParent());
                if (ctx != null) {
                    return ctx;
                }
                try {
                    ctx = new CompNamingContext(cl.getParent().toString(), (Hashtable)this.myEnv.clone());
                    this.clBindings.put(cl.getParent(), ctx);
                }
                catch (NamingException e) {
                    TraceCarol.error("bad name");
                }
            }
            if ((ctx = (Context)this.threadContext.get()) != null) break block6;
            try {
                ctx = new CompNamingContext(this.threadContext.toString(), (Hashtable)this.myEnv.clone());
            }
            catch (NamingException e) {
                TraceCarol.error("bad name");
            }
        }
        return ctx;
    }

    protected Context getServerContext() {
        return this.serverContext;
    }

    static {
        myParser = new javaNameParser();
    }
}

