/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.rmi.jrmp.interceptor;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.objectweb.carol.rmi.jrmp.interceptor.JClientRequestInfo;
import org.objectweb.carol.rmi.jrmp.interceptor.JClientRequestInterceptor;
import org.objectweb.carol.rmi.jrmp.interceptor.JContextStore;
import org.objectweb.carol.rmi.jrmp.interceptor.JInterceptorHelper;
import org.objectweb.carol.rmi.jrmp.interceptor.JRMPClientRequestInfoImpl;
import org.objectweb.carol.rmi.jrmp.interceptor.JServiceContext;
import org.objectweb.carol.util.configuration.TraceCarol;

public class JClientInterceptorHelper
extends JInterceptorHelper {
    public static void send_request(ObjectOutput out, JClientRequestInterceptor[] cis, boolean localRef) throws IOException {
        if (cis == null || cis.length == 0) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JClientInterceptorHelper send request with no contexts");
            }
            out.writeInt(0);
        } else {
            JRMPClientRequestInfoImpl ri = new JRMPClientRequestInfoImpl();
            int i = 0;
            while (i < cis.length) {
                cis[i].send_request(ri);
                ++i;
            }
            JClientInterceptorHelper.setClientContextInOutput(out, ri, localRef);
        }
    }

    public static void send_poll(ObjectOutput out, JClientRequestInterceptor[] cis, boolean localRef) throws IOException {
    }

    public static void receive_reply(ObjectInput in, JClientRequestInterceptor[] cis) throws IOException {
        try {
            int ctxValue = in.readInt();
            if (cis == null || cis.length == 0) {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JClientInterceptorHelper receive reply with no contexts");
                }
                JClientInterceptorHelper.getClientContextFromInput(in, ctxValue, false);
            } else {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JClientInterceptorHelper receive reply contexts");
                }
                JRMPClientRequestInfoImpl ri = new JRMPClientRequestInfoImpl(JClientInterceptorHelper.getClientContextFromInput(in, ctxValue, true));
                int i = 0;
                while (i < cis.length) {
                    cis[i].receive_reply(ri);
                    ++i;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("" + cnfe);
        }
    }

    public static void receive_exception(ObjectInput in, JClientRequestInterceptor[] cis) throws IOException {
        try {
            int ctxValue = in.readInt();
            if (cis == null || cis.length == 0) {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JClientInterceptorHelper receive exception with no contexts");
                }
                JClientInterceptorHelper.getClientContextFromInput(in, ctxValue, false);
            } else {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JClientInterceptorHelper receive exception contexts");
                }
                JRMPClientRequestInfoImpl ri = new JRMPClientRequestInfoImpl(JClientInterceptorHelper.getClientContextFromInput(in, ctxValue, true));
                int i = 0;
                while (i < cis.length) {
                    cis[i].receive_exception(ri);
                    ++i;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("" + cnfe);
        }
    }

    public static void receive_other(ObjectInput in, JClientRequestInterceptor[] cis) throws IOException {
        try {
            int ctxValue = in.readInt();
            if (cis == null || cis.length == 0) {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JClientInterceptorHelper receive other with no contexts");
                }
                JClientInterceptorHelper.getClientContextFromInput(in, ctxValue, false);
            } else {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JClientInterceptorHelper receive other contexts");
                }
                JRMPClientRequestInfoImpl ri = new JRMPClientRequestInfoImpl(JClientInterceptorHelper.getClientContextFromInput(in, ctxValue, true));
                int i = 0;
                while (i < cis.length) {
                    cis[i].receive_other(ri);
                    ++i;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("" + cnfe);
        }
    }

    public static JServiceContext[] getClientContextFromInput(ObjectInput in, int ctxValue, boolean request) throws ClassNotFoundException, IOException {
        if (ctxValue == 0) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JClientInterceptorHelper getObjectFromInput no context, request=" + request);
            }
            return null;
        }
        if (ctxValue == 1) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JClientInterceptorHelper getObjectFromInput remote, request=" + request);
            }
            int sz = in.readInt();
            if (request) {
                JServiceContext[] jcs = new JServiceContext[sz];
                int i = 0;
                while (i < sz) {
                    jcs[i] = (JServiceContext)in.readObject();
                    ++i;
                }
                return jcs;
            }
            int i = 0;
            while (i < sz) {
                in.readObject();
                ++i;
            }
            return null;
        }
        if (ctxValue == 2) {
            int id = in.readInt();
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JClientInterceptorHelper getObjectFromInput local id(" + id + "), request=" + request);
            }
            if (request) {
                return (JServiceContext[])JContextStore.getObject(id);
            }
            JContextStore.getObject(id);
            return null;
        }
        throw new IOException("Unknow context type:" + ctxValue);
    }

    public static void setClientContextInOutput(ObjectOutput out, JClientRequestInfo ri, boolean locRef) throws IOException {
        if (!ri.hasContexts()) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JClientInterceptorHelper send request without contexts");
            }
            out.writeInt(0);
        } else if (locRef) {
            JServiceContext[] ctx = ri.get_all_request_service_context();
            int k = JContextStore.storeObject(ctx);
            out.writeInt(2);
            out.writeInt(k);
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JClientInterceptorHelper send request with local contexts id(" + k + ")");
            }
        } else {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JClientInterceptorHelper send request with remote contexts");
            }
            out.writeInt(1);
            JServiceContext[] jcs = ri.get_all_request_service_context();
            out.writeInt(jcs.length);
            int i = 0;
            while (i < jcs.length) {
                out.writeObject(jcs[i]);
                ++i;
            }
        }
    }
}

