/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.rmi.jrmp.interceptor;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.objectweb.carol.rmi.jrmp.interceptor.JClientRequestInterceptor;
import org.objectweb.carol.rmi.jrmp.interceptor.JInitializer;
import org.objectweb.carol.rmi.jrmp.interceptor.JRMPInitInfoImpl;
import org.objectweb.carol.rmi.jrmp.interceptor.JServerRequestInterceptor;
import org.objectweb.carol.rmi.jrmp.interceptor.RemoteKey;
import org.objectweb.carol.util.configuration.TraceCarol;

public class JInterceptorStore {
    public static String INTIALIZER_PREFIX = "org.objectweb.PortableInterceptor.JRMPInitializerClass";
    private static boolean init = false;
    private static JServerRequestInterceptor[] sis = null;
    private static JClientRequestInterceptor[] cis = null;
    private static String[] initializers = null;
    private static HashMap remoteClientInterceptors = new HashMap();

    public static void initLocalInterceptors() {
        block3: {
            if (init) break block3;
            try {
                JRMPInitInfoImpl jrmpInfo = new JRMPInitInfoImpl();
                String[] ins = JInterceptorStore.getJRMPInitializers();
                int i = 0;
                while (i < ins.length) {
                    JInitializer jinit = (JInitializer)Class.forName(ins[i]).newInstance();
                    jinit.pre_init(jrmpInfo);
                    jinit.post_init(jrmpInfo);
                    ++i;
                }
                sis = jrmpInfo.getServerRequestInterceptors();
                cis = jrmpInfo.getClientRequestInterceptors();
                init = true;
            }
            catch (Exception e) {
                TraceCarol.error("JrmpPRODelegate(), No interceptors found", e);
            }
        }
    }

    public static JServerRequestInterceptor[] getLocalServerInterceptors() {
        return sis;
    }

    public static JClientRequestInterceptor[] getLocalClientInterceptors() {
        return cis;
    }

    public static String[] getJRMPInitializers() {
        if (!init) {
            ArrayList<String> ins = new ArrayList<String>();
            Properties sys = System.getProperties();
            Enumeration<?> e = System.getProperties().propertyNames();
            while (e.hasMoreElements()) {
                String pkey = (String)e.nextElement();
                if (!pkey.startsWith(INTIALIZER_PREFIX)) continue;
                ins.add(pkey.substring(INTIALIZER_PREFIX.length() + 1));
            }
            int sz = ins.size();
            initializers = new String[sz];
            int i = 0;
            while (i < sz) {
                JInterceptorStore.initializers[i] = (String)ins.get(i);
                ++i;
            }
            return initializers;
        }
        return initializers;
    }

    public static JClientRequestInterceptor[] setRemoteInterceptors(RemoteKey rk, String[] ins) {
        if (remoteClientInterceptors.containsKey(rk)) {
            return (JClientRequestInterceptor[])remoteClientInterceptors.get(rk);
        }
        try {
            JRMPInitInfoImpl jrmpInfo = new JRMPInitInfoImpl();
            int i = 0;
            while (i < ins.length) {
                JInitializer jinit = (JInitializer)Class.forName(ins[i]).newInstance();
                jinit.pre_init(jrmpInfo);
                jinit.post_init(jrmpInfo);
                ++i;
            }
            JClientRequestInterceptor[] rci = jrmpInfo.getClientRequestInterceptors();
            remoteClientInterceptors.put(rk, rci);
            return rci;
        }
        catch (Exception e) {
            TraceCarol.error("JrmpPRODelegate(), No remote interceptors found", e);
            return null;
        }
    }
}

