/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.rmi.jrmp.interceptor;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.objectweb.carol.rmi.jrmp.interceptor.JContextStore;
import org.objectweb.carol.rmi.jrmp.interceptor.JInterceptorHelper;
import org.objectweb.carol.rmi.jrmp.interceptor.JRMPServerRequestInfoImpl;
import org.objectweb.carol.rmi.jrmp.interceptor.JServerRequestInfo;
import org.objectweb.carol.rmi.jrmp.interceptor.JServerRequestInterceptor;
import org.objectweb.carol.rmi.jrmp.interceptor.JServiceContext;
import org.objectweb.carol.util.configuration.TraceCarol;

public class JServerInterceptorHelper
extends JInterceptorHelper {
    private static InheritableThreadLocal threadCtx = new InheritableThreadLocal();

    public static void receive_request(ObjectInput in, JServerRequestInterceptor[] sis) throws IOException {
        try {
            int ctxValue = in.readInt();
            if (sis == null || sis.length == 0) {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JServerInterceptorHelper receive exception with no contexts");
                }
                JServerInterceptorHelper.getServerContextFromInput(in, ctxValue, false);
            } else {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JServerInterceptorHelper receive exception contexts");
                }
                JRMPServerRequestInfoImpl ri = new JRMPServerRequestInfoImpl(JServerInterceptorHelper.getServerContextFromInput(in, ctxValue, true));
                int i = 0;
                while (i < sis.length) {
                    sis[i].receive_request(ri);
                    ++i;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("" + cnfe);
        }
    }

    public static void send_reply(ObjectOutput out, JServerRequestInterceptor[] sis) throws IOException {
        if (sis == null || sis.length == 0) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send reply with no contexts");
            }
            out.writeInt(0);
        } else {
            JRMPServerRequestInfoImpl ri = new JRMPServerRequestInfoImpl();
            int i = 0;
            while (i < sis.length) {
                sis[i].send_reply(ri);
                ++i;
            }
            JServerInterceptorHelper.setServerContextInOutput(out, ri, JServerInterceptorHelper.isLocal());
            threadCtx.set(null);
        }
    }

    public static void send_exception(ObjectOutput out, JServerRequestInterceptor[] sis) throws IOException {
        if (sis == null || sis.length == 0) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send exception with no contexts");
            }
            out.writeInt(0);
        } else {
            JRMPServerRequestInfoImpl ri = new JRMPServerRequestInfoImpl();
            int i = 0;
            while (i < sis.length) {
                sis[i].send_exception(ri);
                ++i;
            }
            JServerInterceptorHelper.setServerContextInOutput(out, ri, JServerInterceptorHelper.isLocal());
            threadCtx.set(null);
        }
    }

    public static void send_other(ObjectOutput out, JServerRequestInterceptor[] sis) throws IOException {
        if (sis == null || sis.length == 0) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send other with no contexts");
            }
            out.writeInt(0);
        } else {
            JRMPServerRequestInfoImpl ri = new JRMPServerRequestInfoImpl();
            int i = 0;
            while (i < sis.length) {
                sis[i].send_other(ri);
                ++i;
            }
            JServerInterceptorHelper.setServerContextInOutput(out, ri, JServerInterceptorHelper.isLocal());
            threadCtx.set(null);
        }
    }

    public static JServiceContext[] getServerContextFromInput(ObjectInput in, int ctxValue, boolean request) throws ClassNotFoundException, IOException {
        if (ctxValue == 0) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper getObjectFromInput no context, request=" + request);
            }
            return null;
        }
        if (ctxValue == 1) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper getObjectFromInput remote, request=" + request);
            }
            int sz = in.readInt();
            if (request) {
                JServiceContext[] jcs = new JServiceContext[sz];
                int i = 0;
                while (i < sz) {
                    jcs[i] = (JServiceContext)in.readObject();
                    ++i;
                }
                return jcs;
            }
            int i = 0;
            while (i < sz) {
                in.readObject();
                ++i;
            }
            return null;
        }
        if (ctxValue == 2) {
            JServerInterceptorHelper.setLocal();
            int id = in.readInt();
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper getObjectFromInput local id(" + id + "), request=" + request);
            }
            if (request) {
                return (JServiceContext[])JContextStore.getObject(id);
            }
            JContextStore.getObject(id);
            return null;
        }
        throw new IOException("Unknow context type:" + ctxValue);
    }

    public static void setServerContextInOutput(ObjectOutput out, JServerRequestInfo ri, boolean locRef) throws IOException {
        if (!ri.hasContexts()) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send request without contexts");
            }
            out.writeInt(0);
        } else if (locRef) {
            JServiceContext[] ctx = ri.get_all_reply_service_context();
            int k = JContextStore.storeObject(ctx);
            out.writeInt(2);
            out.writeInt(k);
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send request with local contexts id(" + k + ")");
            }
        } else {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send request with remote contexts");
            }
            out.writeInt(1);
            JServiceContext[] jcs = ri.get_all_reply_service_context();
            out.writeInt(jcs.length);
            int i = 0;
            while (i < jcs.length) {
                out.writeObject(jcs[i]);
                ++i;
            }
        }
    }

    public static void setLocal() {
        threadCtx.set("");
    }

    public static boolean isLocal() {
        return threadCtx.get() != null;
    }
}

