/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.rmi.PortableRemoteObject;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.HeuristicCommit;
import org.objectweb.jotm.Resource;
import org.objectweb.jotm.SLog;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionImpl;

public class SubCoordinator
extends PortableRemoteObject
implements Resource {
    private TransactionImpl tx = null;
    private Vector synchroList = new Vector();
    private Vector resourceList = new Vector();
    private TransactionManager tm;
    private Xid xid = null;
    private SLog log = null;
    private int status = 0;
    private boolean beforeCompletionDone = false;

    SubCoordinator(TransactionImpl tx, Xid xid) throws RemoteException {
        TraceTm.jta.debug((Object)("tx=" + tx + ",  xid=" + xid));
        this.tx = tx;
        this.xid = xid;
        this.tm = Current.getTransactionManager();
        Current.getCurrent().incrementBeginCounter();
    }

    public int prepare() throws RemoteException {
        TraceTm.jta.debug((Object)"SubCoordinator.prepare()");
        switch (this.status) {
            case 1: {
                this.doBeforeCompletion(false);
                this.doRollback();
                return 1;
            }
            case 3: {
                return 0;
            }
        }
        this.doBeforeCompletion(true);
        if (this.status == 1) {
            TraceTm.jotm.info((Object)"Rollback during beforeCompletion in SubCoordinator.prepare");
            this.doRollback();
            return 1;
        }
        int ret = this.doPrepare();
        if (ret == 2) {
            this.doAfterCompletion();
        }
        return ret;
    }

    public void rollback() throws RemoteException {
        TraceTm.jta.debug((Object)"SubCoordinator.rollback()");
        switch (this.status) {
            case 0: 
            case 1: {
                break;
            }
            case 4: {
                return;
            }
            default: {
                TraceTm.jotm.error((Object)("rollback: bad status: " + this.stringStatus()));
                return;
            }
        }
        this.doBeforeCompletion(false);
        this.doRollback();
    }

    public void commit() throws RemoteException {
        TraceTm.jta.debug((Object)"SubCoordinator.commit()");
        switch (this.status) {
            case 2: {
                break;
            }
            default: {
                TraceTm.jotm.error((Object)("commit: bad status: " + this.stringStatus()));
                return;
            }
        }
        this.doCommit();
    }

    public void commit_one_phase() throws RemoteException {
        TraceTm.jta.debug((Object)"commit 1 phase");
        switch (this.status) {
            case 4: {
                throw new TransactionRolledbackException();
            }
            case 1: {
                this.doBeforeCompletion(false);
                this.doRollback();
                throw new TransactionRolledbackException();
            }
            case 3: {
                return;
            }
        }
        this.doBeforeCompletion(true);
        if (this.status == 1) {
            TraceTm.jotm.info((Object)"Rollback during beforeCompletion in SubCoordinator.commit_one_phase");
            this.doRollback();
            throw new TransactionRolledbackException();
        }
        if (this.resourceList.size() == 1) {
            this.doOnePhaseCommit();
            return;
        }
        int vote = this.doPrepare();
        switch (vote) {
            case 0: {
                this.doCommit();
                break;
            }
            case 2: {
                this.doAfterCompletion();
                break;
            }
            case 1: {
                this.doRollback();
                throw new TransactionRolledbackException();
            }
        }
    }

    public void forget() throws RemoteException {
        TraceTm.jta.debug((Object)"SubCoordinator.forget()");
        this.doForget();
    }

    public void addSynchronization(Synchronization synchro) throws RollbackException, IllegalStateException {
        TraceTm.jta.debug((Object)"SubCoordinator.addSynchronization(Synchronization synchro)");
        boolean markedRollback = false;
        switch (this.status) {
            case 1: 
            case 4: {
                markedRollback = true;
                break;
            }
            case 0: {
                break;
            }
            default: {
                TraceTm.jotm.error((Object)("addSynchronization: bad status = " + this.stringStatus()));
                throw new IllegalStateException("addSynchronization: Bad status");
            }
        }
        this.synchroList.addElement(synchro);
        if (markedRollback) {
            TraceTm.jta.debug((Object)"SubCoordinator.addSynchronization: transaction rollback only");
            throw new RollbackException();
        }
    }

    public boolean addResource(XAResource xares) throws RollbackException, IllegalStateException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("xares=" + xares));
        }
        boolean markedRollback = false;
        switch (this.status) {
            case 1: {
                markedRollback = true;
                break;
            }
            case 0: {
                break;
            }
            default: {
                TraceTm.jotm.error((Object)("SubCoordinator.addResource: bad status=" + this.stringStatus()));
                throw new IllegalStateException("SubCoordinator.addResource: Bad status");
            }
        }
        boolean found = false;
        int i = 0;
        while (i < this.resourceList.size()) {
            XAResource res = (XAResource)this.resourceList.elementAt(i);
            try {
                if (res.isSameRM(xares)) {
                    found = true;
                    break;
                }
            }
            catch (XAException e) {
                TraceTm.jotm.error((Object)"Exception on isSameRM:", (Throwable)e);
            }
            ++i;
        }
        if (!found) {
            TraceTm.jta.debug((Object)"new XAResource added to the list");
            this.resourceList.addElement(xares);
        }
        if (markedRollback) {
            TraceTm.jta.debug((Object)"SubCoordinator.addResource: transaction rollback only");
            throw new RollbackException();
        }
        return found;
    }

    public int getStatus() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("status=" + this.stringStatus()));
        }
        return this.status;
    }

    public void setRollbackOnly() {
        TraceTm.jta.debug((Object)"SubCoordinator.setRollbackOnly()");
        switch (this.status) {
            case 0: 
            case 5: 
            case 7: {
                this.status = 1;
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                TraceTm.jotm.error((Object)"Cannot set transaction as rollback only");
                TraceTm.jotm.error((Object)("Bad status=" + this.stringStatus()));
            }
        }
    }

    public String stringStatus() {
        String ret = null;
        switch (this.status) {
            case 0: {
                ret = "ACTIVE";
                break;
            }
            case 5: {
                ret = "UNKNOWN";
                break;
            }
            case 7: {
                ret = "PREPARING";
                break;
            }
            case 1: {
                ret = "MARKED_ROLLBACK";
                break;
            }
            case 2: {
                ret = "PREPARED";
                break;
            }
            case 3: {
                ret = "COMMITTED";
                break;
            }
            case 4: {
                ret = "ROLLEDBACK";
                break;
            }
            case 6: {
                ret = "NO_TRANSACTION";
                break;
            }
            case 8: {
                ret = "COMMITTING";
                break;
            }
            case 9: {
                ret = "ROLLING_BACK";
                break;
            }
            default: {
                ret = "BAD_VALUE";
            }
        }
        return ret;
    }

    private void doForget() throws RemoteException {
        TraceTm.jta.debug((Object)"SubCoordinator.doForget()");
        boolean exception = false;
        int i = 0;
        while (i < this.resourceList.size()) {
            XAResource xar = (XAResource)this.resourceList.elementAt(i);
            try {
                xar.forget(this.xid);
            }
            catch (XAException e) {
                exception = true;
            }
            ++i;
        }
        if (exception) {
            throw new RemoteException("XAException on forget");
        }
        PortableRemoteObject.unexportObject((Remote)this);
    }

    private int doPrepare() throws RemoteException {
        TraceTm.jta.debug((Object)"SubCoordinator.doPrepare()");
        int ret = 2;
        int errors = 0;
        if (this.resourceList.size() == 0) {
            Current.getCurrent().incrementCommitCounter();
            this.status = 3;
            return ret;
        }
        this.log = new SLog();
        this.status = 7;
        int i = 0;
        while (i < this.resourceList.size()) {
            XAResource res = (XAResource)this.resourceList.elementAt(i);
            if (errors > 0) {
                try {
                    res.rollback(this.xid);
                }
                catch (XAException e) {}
            } else {
                try {
                    switch (res.prepare(this.xid)) {
                        case 0: {
                            this.log.addResource(res);
                            ret = 0;
                            break;
                        }
                    }
                }
                catch (XAException e) {
                    ret = 1;
                    ++errors;
                }
            }
            ++i;
        }
        switch (ret) {
            case 2: {
                Current.getCurrent().incrementCommitCounter();
                this.status = 3;
                break;
            }
            case 0: {
                this.status = 2;
                break;
            }
            case 1: {
                this.status = 4;
            }
        }
        return ret;
    }

    private int doCommit() throws RemoteException {
        TraceTm.jta.debug((Object)"SubCoordinator.doCommit()");
        if (this.log == null) {
            TraceTm.jotm.error((Object)"doCommit: no log");
            return -1;
        }
        this.status = 8;
        int errors = 0;
        int commitnb = 0;
        int heuristicnb = 0;
        List loggedResources = this.log.getLoggedResources();
        int i = 0;
        while (i < loggedResources.size()) {
            block10: {
                XAResource res = (XAResource)loggedResources.get(i);
                if (commitnb == 0 && errors > 0) {
                    try {
                        res.rollback(this.xid);
                    }
                    catch (XAException e) {
                        ++commitnb;
                        ++heuristicnb;
                    }
                } else {
                    try {
                        res.commit(this.xid, false);
                    }
                    catch (XAException e) {
                        ++errors;
                        if (commitnb <= 0) break block10;
                        ++heuristicnb;
                    }
                }
            }
            ++i;
        }
        if (errors == 0) {
            Current.getCurrent().incrementCommitCounter();
            this.status = 3;
            this.doAfterCompletion();
            this.log.forgetLog();
            return 0;
        }
        if (heuristicnb == 0) {
            this.status = 4;
            this.doAfterCompletion();
            this.log.forgetLog();
            throw new TransactionRolledbackException();
        }
        this.status = 5;
        this.doAfterCompletion();
        return -1;
    }

    private void doOnePhaseCommit() throws RemoteException {
        TraceTm.jta.debug((Object)"SubCoordinator.doOnePhaseCommit()");
        this.status = 8;
        XAResource res = (XAResource)this.resourceList.elementAt(0);
        try {
            try {
                Current.getCurrent().incrementCommitCounter();
                res.commit(this.xid, true);
                this.status = 3;
            }
            catch (XAException e) {
                this.status = 5;
                if (e.errorCode == 100) {
                    throw new TransactionRolledbackException("XAException:" + e);
                }
                throw new RemoteException("XAException:" + e);
            }
            Object var4_2 = null;
            this.doAfterCompletion();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.doAfterCompletion();
            throw throwable;
        }
    }

    private void doRollback() throws RemoteException {
        TraceTm.jta.debug((Object)"SubCoordinator.doRollback()");
        this.status = 4;
        boolean hcomm = false;
        int i = 0;
        while (i < this.resourceList.size()) {
            XAResource res = (XAResource)this.resourceList.elementAt(i);
            try {
                res.rollback(this.xid);
            }
            catch (XAException e) {
                switch (e.errorCode) {
                    case 7: {
                        hcomm = true;
                    }
                }
                TraceTm.jotm.error((Object)("Got XAException from resource: " + e));
                throw new RemoteException("rollback: Unexpected XAException:" + e.errorCode);
            }
            ++i;
        }
        this.doAfterCompletion();
        Current.getCurrent().incrementRollbackCounter();
        if (hcomm) {
            throw new HeuristicCommit();
        }
    }

    private void doBeforeCompletion(boolean committing) {
        block30: {
            if (this.beforeCompletionDone) {
                return;
            }
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("committing=" + committing));
            }
            this.tx.unsetTimer();
            if (committing && this.synchroList.size() > 0) {
                boolean resumed;
                boolean suspended;
                Transaction mytx;
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                mytx = null;
                                suspended = false;
                                resumed = false;
                                try {
                                    mytx = this.tm.getTransaction();
                                }
                                catch (SystemException e) {
                                    if (!TraceTm.jta.isDebugEnabled()) break block26;
                                    TraceTm.jta.debug((Object)("Cannot get transaction:" + (Object)((Object)e)));
                                }
                            }
                            if (mytx != null && !mytx.equals(this.tx)) {
                                try {
                                    this.tm.suspend();
                                    suspended = true;
                                }
                                catch (SystemException e) {
                                    if (!TraceTm.jta.isDebugEnabled()) break block27;
                                    TraceTm.jta.debug((Object)("Cannot suspend transaction:" + (Object)((Object)e)));
                                }
                            }
                        }
                        if (mytx == null || suspended) {
                            try {
                                this.tm.resume((Transaction)this.tx);
                                resumed = true;
                            }
                            catch (SystemException e) {
                                if (TraceTm.jta.isDebugEnabled()) {
                                    TraceTm.jta.debug((Object)("Cannot resume transaction:" + (Object)((Object)e)));
                                }
                            }
                            catch (InvalidTransactionException e) {
                                if (TraceTm.jta.isDebugEnabled()) {
                                    TraceTm.jta.debug((Object)("Cannot resume transaction:" + (Object)((Object)e)));
                                }
                            }
                            catch (IllegalStateException e) {
                                if (!TraceTm.jta.isDebugEnabled()) break block28;
                                TraceTm.jta.debug((Object)("Cannot resume transaction:" + e));
                            }
                        }
                    }
                    int i = 0;
                    while (i < this.synchroList.size()) {
                        Synchronization sync = (Synchronization)this.synchroList.elementAt(i);
                        sync.beforeCompletion();
                        ++i;
                    }
                    if (resumed) {
                        try {
                            this.tm.suspend();
                        }
                        catch (SystemException e) {
                            if (!TraceTm.jta.isDebugEnabled()) break block29;
                            TraceTm.jta.debug((Object)("Cannot suspend transaction:" + (Object)((Object)e)));
                        }
                    }
                }
                if (suspended) {
                    try {
                        this.tm.resume(mytx);
                        resumed = true;
                    }
                    catch (SystemException e) {
                        if (TraceTm.jta.isDebugEnabled()) {
                            TraceTm.jta.debug((Object)("Cannot resume transaction:" + (Object)((Object)e)));
                        }
                    }
                    catch (InvalidTransactionException e) {
                        if (TraceTm.jta.isDebugEnabled()) {
                            TraceTm.jta.debug((Object)("Cannot resume transaction:" + (Object)((Object)e)));
                        }
                    }
                    catch (IllegalStateException e) {
                        if (!TraceTm.jta.isDebugEnabled()) break block30;
                        TraceTm.jta.debug((Object)("Cannot resume transaction:" + e));
                    }
                }
            }
        }
        this.beforeCompletionDone = true;
    }

    private void doAfterCompletion() {
        TraceTm.jta.debug((Object)"SubCoordinator.doAfterCompletion()");
        int i = 0;
        while (i < this.synchroList.size()) {
            Synchronization sync = (Synchronization)this.synchroList.elementAt(i);
            sync.afterCompletion(this.status);
            ++i;
        }
        Current.getCurrent().forgetTx(this.tx.getXid());
        try {
            PortableRemoteObject.unexportObject((Remote)this);
        }
        catch (Exception e) {}
    }
}

