/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.rmi.PortableRemoteObject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.objectweb.jonas_timer.TimerEvent;
import org.objectweb.jonas_timer.TimerEventListener;
import org.objectweb.jotm.Coordinator;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.HeuristicMixed;
import org.objectweb.jotm.InternalTransactionContext;
import org.objectweb.jotm.RecoveryCoordinator;
import org.objectweb.jotm.SubCoordinator;
import org.objectweb.jotm.Terminator;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionContext;

public class TransactionImpl
implements Transaction,
TimerEventListener {
    private SubCoordinator subcoord = null;
    private TransactionContext myCtx = null;
    private Xid myXid = null;
    private boolean interpose = false;
    private int ucount = 0;
    private TimerEvent timer = null;
    private RecoveryCoordinator recoveryCoord = null;
    private List enlistedXARes = Collections.synchronizedList(new ArrayList());
    private List delistedXARes = null;
    static /* synthetic */ Class class$org$objectweb$jotm$Coordinator;

    public TransactionImpl(Xid xid, int timeout) throws SystemException {
        TraceTm.jta.debug((Object)("xid=" + xid + ", timeout=" + timeout));
        this.myXid = xid;
        this.myCtx = new InternalTransactionContext(timeout, null, xid);
    }

    public TransactionImpl(TransactionContext pctx) {
        if (pctx == null) {
            TraceTm.jotm.error((Object)"TransactionImpl: null PropagationContext");
        }
        this.myCtx = pctx;
        this.myXid = pctx.getXid();
        this.interpose = true;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        TraceTm.jta.debug((Object)("commit transaction (tx=" + this + ")"));
        Terminator term = this.myCtx.getTerminator();
        if (term != null) {
            try {
                term.commit(true);
            }
            catch (ServerException e) {
                if (e.detail instanceof TransactionRolledbackException) {
                    Current.getCurrent().forgetTx(this.getXid());
                    TraceTm.jta.debug((Object)"Commit distributed transaction -> rolled back!");
                    throw new RollbackException();
                }
                if (e.detail instanceof HeuristicMixed) {
                    TraceTm.jotm.info((Object)"Commit distributed transaction -> Heuristic mixed!");
                    throw new HeuristicMixedException();
                }
            }
            catch (TransactionRolledbackException e) {
                Current.getCurrent().forgetTx(this.getXid());
                TraceTm.jta.debug((Object)"Commit distributed transaction -> rolled back!");
                throw new RollbackException();
            }
            catch (HeuristicMixed e) {
                TraceTm.jotm.info((Object)"Commit distributed transaction -> Heuristic mixed!");
                throw new HeuristicMixedException();
            }
            catch (Exception e) {
                TraceTm.jotm.error((Object)"Unexpected Exception on commit:", (Throwable)e);
                throw new SystemException("Unexpected Exception on commit");
            }
            if (this.subcoord == null) {
                this.unsetTimer();
            }
            Current.getCurrent().forgetTx(this.getXid());
            return;
        }
        if (this.subcoord != null) {
            try {
                this.subcoord.commit_one_phase();
            }
            catch (TransactionRolledbackException e) {
                TraceTm.jta.debug((Object)"Commit local transaction -> rolled back!");
                throw new RollbackException();
            }
            catch (RemoteException e) {
                TraceTm.jotm.error((Object)"Unexpected Exception on commit_one_phase:", (Throwable)e);
                throw new SystemException("Unexpected Exception on commit_one_phase");
            }
        } else {
            this.unsetTimer();
            Current.getCurrent().forgetTx(this.getXid());
        }
    }

    public boolean delistResource(XAResource xares, int flag) throws IllegalStateException, SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("xares=" + xares + ", flag=" + flag));
        }
        try {
            xares.end(this.getXid(), flag);
        }
        catch (XAException e) {
            throw new SystemException("Cannot send XA end:" + e);
        }
        this.enlistedXARes.remove(xares);
        return true;
    }

    public boolean enlistResource(XAResource xares) throws RollbackException, IllegalStateException, SystemException {
        int flag;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("xares=" + xares));
        }
        if (xares == null) {
            TraceTm.jotm.error((Object)"enlistResource: null argument");
            throw new SystemException("enlistResource: null argument");
        }
        if (this.myCtx == null) {
            throw new SystemException("enlistResource: no Transactional Context");
        }
        if (this.subcoord == null) {
            this.makeSubCoord();
            if (this.subcoord == null) {
                TraceTm.jotm.error((Object)"enlistResource: could not create subcoordinator");
                throw new SystemException("enlistResource: could not create subcoordinator");
            }
        }
        boolean found = false;
        boolean rollbackOnly = false;
        try {
            found = this.subcoord.addResource(xares);
        }
        catch (RollbackException e) {
            rollbackOnly = true;
        }
        int n = flag = found ? 0x200000 : 0;
        if (this.delistedXARes != null && this.delistedXARes.contains(xares)) {
            flag = 0x8000000;
        }
        try {
            xares.start(this.getXid(), flag);
        }
        catch (XAException e) {
            String error = "Cannot send XA start:" + e + "--" + e.getMessage();
            TraceTm.jotm.error((Object)error);
            throw new SystemException(error);
        }
        if (rollbackOnly) {
            throw new RollbackException();
        }
        this.enlistedXARes.add(xares);
        return true;
    }

    public void doDetach(int status) throws SystemException {
        TraceTm.jta.debug((Object)("status=" + status));
        TraceTm.jta.debug((Object)("number of enlisted=" + this.enlistedXARes.size()));
        this.delistedXARes = new ArrayList(this.enlistedXARes);
        int i = 0;
        while (i < this.delistedXARes.size()) {
            this.delistResource((XAResource)this.delistedXARes.get(i), status);
            ++i;
        }
    }

    public void doAttach(int status) throws SystemException, RollbackException {
        TraceTm.jta.debug((Object)("status=" + status));
        TraceTm.jta.debug((Object)("number of enlisted=" + this.enlistedXARes.size()));
        if (status == 0x8000000) {
            int i = 0;
            while (this.delistedXARes != null && i < this.delistedXARes.size()) {
                this.enlistResource((XAResource)this.delistedXARes.get(i));
                ++i;
            }
        }
        this.delistedXARes = null;
    }

    public List getEnlistedXAResource() {
        TraceTm.jta.debug((Object)("TransactionImpl.getEnlistedXAResource - size=" + this.enlistedXARes.size()));
        return new ArrayList(this.enlistedXARes);
    }

    public int getStatus() throws SystemException {
        TraceTm.jta.debug((Object)"TransactionImpl.getStatus()");
        Coordinator coord = this.myCtx.getCoordinator();
        if (coord != null) {
            int ret;
            try {
                ret = coord.get_status();
            }
            catch (Exception e) {
                TraceTm.jotm.error((Object)"TransactionImpl.getStatus: cannot reach JTM:", (Throwable)e);
                return 6;
            }
            return ret;
        }
        if (this.subcoord == null) {
            return 0;
        }
        return this.subcoord.getStatus();
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        TraceTm.jta.debug((Object)"TransactionImpl.registerSynchronization(Synchronization sync)");
        if (this.subcoord == null) {
            this.makeSubCoord();
        }
        this.subcoord.addSynchronization(sync);
    }

    public void rollback() throws IllegalStateException, SystemException {
        TraceTm.jta.debug((Object)"TransactionImpl.rollback()");
        Terminator term = this.myCtx.getTerminator();
        if (term != null) {
            try {
                term.rollback();
            }
            catch (ServerException e) {
                throw new IllegalStateException("Exception on rollback:" + e.detail);
            }
            catch (Exception e) {
                throw new SystemException("Unexpected Exception on rollback");
            }
            if (this.subcoord == null) {
                this.unsetTimer();
            }
            Current.getCurrent().forgetTx(this.getXid());
            return;
        }
        if (this.subcoord != null) {
            try {
                this.subcoord.rollback();
            }
            catch (RemoteException e) {
                throw new IllegalStateException("Exception on rollback:" + e);
            }
        } else {
            this.unsetTimer();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        TraceTm.jta.debug((Object)"TransactionImpl.setRollbackOnly()");
        if (this.subcoord == null) {
            this.makeSubCoord();
        }
        this.subcoord.setRollbackOnly();
    }

    public void timeoutExpired(Object arg) {
        Current.getCurrent().incrementTimeOutExpCounter();
        if (this.subcoord == null) {
            Terminator term = this.myCtx.getTerminator();
            if (term != null) {
                TraceTm.jotm.info((Object)("forget tx (tx=" + this + ")"));
                Current.getCurrent().forgetTx(this.getXid());
                return;
            }
            this.makeSubCoord();
        }
        TraceTm.jotm.info((Object)("set rollback only (tx=" + this + ")"));
        try {
            this.subcoord.setRollbackOnly();
        }
        catch (Exception e) {
            TraceTm.jotm.error((Object)("cannot rollbackonly:" + e));
            return;
        }
    }

    public boolean equals(Object obj2) {
        TransactionImpl tx2 = (TransactionImpl)obj2;
        if (tx2 == this) {
            return true;
        }
        if (tx2 == null) {
            TraceTm.jotm.info((Object)"Null pointer in Transaction.equals");
            return false;
        }
        return this.getXid().equals(tx2.getXid());
    }

    public int hashCode() {
        return this.getXid().hashCode();
    }

    public String toString() {
        return this.getXid().toString();
    }

    public synchronized TransactionContext getPropagationContext(boolean hold) {
        if (hold) {
            ++this.ucount;
        }
        return this.myCtx;
    }

    public void setTimer(TimerEvent timer) {
        TraceTm.jta.debug((Object)("set timer for tx (timer=" + timer + ", tx=" + this + ")"));
        this.timer = timer;
    }

    public void unsetTimer() {
        TraceTm.jta.debug((Object)("unset timer for tx (timer=" + this.timer + ", tx=" + this + ")"));
        if (this.timer != null) {
            this.timer.unset();
            this.timer = null;
        }
    }

    public synchronized void updatePropagationContext(TransactionContext pctx) {
        TraceTm.jta.debug((Object)"TransactionImpl.updatePropagationContext");
        Coordinator remoteCoord = pctx.getCoordinator();
        if (remoteCoord == null && this.myCtx.getCoordinator() != null) {
            TraceTm.jotm.error((Object)"setPropagationContext: Bad Coordinator");
            return;
        }
        --this.ucount;
        if (remoteCoord != null && this.myCtx.getCoordinator() == null) {
            this.myCtx.setCoordinator(pctx.getCoordinator());
            if (this.subcoord != null) {
                try {
                    this.recoveryCoord = remoteCoord.register_resource(this.subcoord);
                }
                catch (RemoteException e) {
                    TraceTm.jotm.error((Object)"Cannot make interposition:", (Throwable)e);
                    return;
                }
            }
        }
    }

    public Xid getXid() {
        return this.myXid;
    }

    private void makeSubCoord() {
        TraceTm.jta.debug((Object)"make subcoordinator");
        try {
            this.subcoord = new SubCoordinator(this, this.getXid());
        }
        catch (RemoteException e) {
            TraceTm.jotm.error((Object)"new SubCoordinator raised exception: ", (Throwable)e);
            return;
        }
        Coordinator remoteCoord = this.myCtx.getCoordinator();
        if (this.interpose && remoteCoord == null) {
            try {
                TraceTm.jta.debug((Object)"Creating a remote Control on JTM for a distributed transaction");
                remoteCoord = (Coordinator)PortableRemoteObject.narrow((Object)Current.getJTM().create(this.myCtx.getTimeout()), (Class)(class$org$objectweb$jotm$Coordinator == null ? (class$org$objectweb$jotm$Coordinator = TransactionImpl.class$("org.objectweb.jotm.Coordinator")) : class$org$objectweb$jotm$Coordinator));
            }
            catch (RemoteException e) {
                TraceTm.jotm.error((Object)"Cannot create distributed transaction:", (Throwable)e);
                return;
            }
            this.myCtx.setCoordinator(remoteCoord);
        }
        if (remoteCoord != null && this.recoveryCoord == null) {
            try {
                this.recoveryCoord = remoteCoord.register_resource(this.subcoord);
            }
            catch (RemoteException e) {
                TraceTm.jotm.error((Object)"Cannot make interposition:", (Throwable)e);
                return;
            }
        }
    }

    public boolean isRemovable() {
        return this.ucount == 0 && this.subcoord == null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

