/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.BigInt;
import com.sun.net.ssl.internal.ssl.BitArray;
import com.sun.net.ssl.internal.ssl.DerInputBuffer;
import com.sun.net.ssl.internal.ssl.DerInputStream;
import com.sun.net.ssl.internal.ssl.DerOutputStream;
import com.sun.net.ssl.internal.ssl.ObjectIdentifier;
import com.sun.net.ssl.internal.ssl.SunJSSE_g;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DerValue {
    public static final byte TAG_UNIVERSAL = 0;
    public static final byte TAG_APPLICATION = 64;
    public static final byte TAG_CONTEXT = -128;
    public static final byte TAG_PRIVATE = -64;
    public byte tag;
    protected DerInputBuffer buffer;
    public DerInputStream data;
    private int a;
    public static final byte tag_Boolean = 1;
    public static final byte tag_Integer = 2;
    public static final byte tag_BitString = 3;
    public static final byte tag_OctetString = 4;
    public static final byte tag_Null = 5;
    public static final byte tag_ObjectId = 6;
    public static final byte tag_Enumerated = 10;
    public static final byte tag_PrintableString = 19;
    public static final byte tag_T61String = 20;
    public static final byte tag_IA5String = 22;
    public static final byte tag_UtcTime = 23;
    public static final byte tag_GeneralizedTime = 24;
    public static final byte tag_BMPString = 30;
    public static final byte tag_UniversalString = 28;
    public static final byte tag_Sequence = 48;
    public static final byte tag_SequenceOf = 48;
    public static final byte tag_Set = 49;
    public static final byte tag_SetOf = 49;

    public DerValue(byte by, byte[] byArray) {
        this.tag = by;
        this.buffer = new DerInputBuffer((byte[])byArray.clone());
        this.a = byArray.length;
        this.data = new DerInputStream(this.buffer);
        this.data.mark(Integer.MAX_VALUE);
    }

    DerValue(DerInputBuffer derInputBuffer) throws IOException {
        this.tag = (byte)derInputBuffer.read();
        this.a = DerInputStream.a(derInputBuffer);
        if (this.a == -1) {
            derInputBuffer.reset();
            byte[] byArray = new byte[derInputBuffer.available()];
            DataInputStream dataInputStream = new DataInputStream(derInputBuffer);
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            SunJSSE_g sunJSSE_g = new SunJSSE_g();
            derInputBuffer = new DerInputBuffer(sunJSSE_g.a(byArray));
            if (this.tag != derInputBuffer.read()) {
                throw new IOException("Indefinite length encoding not supported");
            }
            this.a = DerInputStream.a(derInputBuffer);
        }
        this.buffer = derInputBuffer.a();
        this.buffer.b(this.a);
        this.data = new DerInputStream(this.buffer);
        derInputBuffer.skip(this.a);
    }

    public DerValue(InputStream inputStream) throws IOException {
        this.a(false, inputStream);
    }

    public DerValue(String string) throws IOException {
        this.tag = (byte)19;
        this.a = string.length();
        byte[] byArray = new byte[this.a];
        int n = 0;
        while (n < this.a) {
            byArray[n] = (byte)string.charAt(n);
            ++n;
        }
        this.buffer = new DerInputBuffer(byArray);
        this.data = new DerInputStream(this.buffer);
        this.data.mark(Integer.MAX_VALUE);
    }

    public DerValue(byte[] byArray) throws IOException {
        this.a(true, new ByteArrayInputStream(byArray));
    }

    public DerValue(byte[] byArray, int n, int n2) throws IOException {
        this.a(true, new ByteArrayInputStream(byArray, n, n2));
    }

    private byte[] a(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return byArray2;
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static byte createTag(byte by, boolean bl, byte by2) {
        byte by3 = (byte)(by | by2);
        if (bl) {
            by3 = (byte)(by3 | 0x20);
        }
        return by3;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.write(this.tag);
        derOutputStream.putLength(this.a);
        if (this.a > 0) {
            byte[] byArray = new byte[this.a];
            this.buffer.reset();
            if (this.buffer.read(byArray) != this.a) {
                throw new IOException("short DER value read (encode)");
            }
            derOutputStream.write(byArray);
        }
    }

    public boolean equals(DerValue derValue) {
        this.data.reset();
        derValue.data.reset();
        if (this == derValue) {
            return true;
        }
        if (this.tag != derValue.tag) {
            return false;
        }
        return this.buffer.a(derValue.buffer);
    }

    public boolean equals(Object object) {
        if (object instanceof DerValue) {
            return this.equals((DerValue)object);
        }
        return false;
    }

    public String getAsString() throws IOException {
        if (this.tag == 19) {
            return this.getPrintableString();
        }
        if (this.tag == 22) {
            return this.getIA5String();
        }
        if (this.tag == 20) {
            return this.getT61String();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getBMPString() throws IOException {
        if (this.tag != 30) {
            throw new IOException("DerValue.getIA5String, not BMP " + this.tag);
        }
        StringBuffer stringBuffer = new StringBuffer(this.a);
        try {
            int n = this.a;
            this.data.reset();
            while (true) {
                int n2 = --n;
                --n;
                if (n2 <= 0) {
                    return new String(stringBuffer);
                }
                int n3 = this.data.a();
                int n4 = this.data.a();
                stringBuffer.append((char)((n3 << 8) + n4));
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getBitString() throws IOException {
        if (this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.b();
    }

    public byte[] getBitString(boolean bl) throws IOException {
        if (!bl && this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.b();
    }

    public boolean getBoolean() throws IOException {
        if (this.tag != 1) {
            throw new IOException("DerValue.getBoolean, not a BOOLEAN " + this.tag);
        }
        if (this.a != 1) {
            throw new IOException("DerValue.getBoolean, invalid length " + this.a);
        }
        return this.buffer.read() != 0;
    }

    public BigInt getEnumerated() throws IOException {
        if (this.tag != 10) {
            throw new IOException("DerValue.getEnumerated, incorrect tag: " + this.tag);
        }
        return this.buffer.a(this.data.available());
    }

    public String getIA5String() throws IOException {
        if (this.tag != 22) {
            throw new IOException("DerValue.getIA5String, not IA5 " + this.tag);
        }
        return this.d();
    }

    public BigInt getInteger() throws IOException {
        if (this.tag != 2) {
            throw new IOException("DerValue.getInteger, not an int " + this.tag);
        }
        return this.buffer.a(this.data.available());
    }

    public BigInt getInteger(boolean bl) throws IOException {
        if (!bl && this.tag != 2) {
            throw new IOException("DerValue.getInteger, not an int " + this.tag);
        }
        return this.buffer.a(this.data.available());
    }

    public ObjectIdentifier getOID() throws IOException {
        if (this.tag != 6) {
            throw new IOException("DerValue.getOID, not an OID " + this.tag);
        }
        return new ObjectIdentifier(this.buffer);
    }

    public byte[] getOctetString() throws IOException {
        if (this.tag != 4 && !this.isConstructed((byte)4)) {
            throw new IOException("DerValue.getOctetString, not an Octet String: " + this.tag);
        }
        byte[] byArray = new byte[this.a];
        if (this.buffer.read(byArray) != this.a) {
            throw new IOException("short read on DerValue buffer");
        }
        if (this.isConstructed()) {
            DerInputStream derInputStream = new DerInputStream(byArray);
            byArray = null;
            while (derInputStream.available() != 0) {
                byArray = this.a(byArray, derInputStream.getOctetString());
            }
        }
        return byArray;
    }

    public String getPrintableString() throws IOException {
        if (this.tag != 19) {
            throw new IOException("DerValue.getPrintableString, not a string " + this.tag);
        }
        return this.d();
    }

    public String getT61String() throws IOException {
        if (this.tag != 20) {
            throw new IOException("DerValue.getT61String, not T61 " + this.tag);
        }
        return this.d();
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.c();
    }

    public BitArray getUnalignedBitString(boolean bl) throws IOException {
        if (!bl && this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.c();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private void a(boolean bl, InputStream inputStream) throws IOException {
        this.tag = (byte)inputStream.read();
        byte by = (byte)inputStream.read();
        this.a = DerInputStream.a(by & 0xFF, inputStream);
        if (this.a == -1) {
            int n = inputStream.available();
            int n2 = 2;
            byte[] byArray = new byte[n + n2];
            byArray[0] = this.tag;
            byArray[1] = by;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readFully(byArray, n2, n);
            dataInputStream.close();
            SunJSSE_g sunJSSE_g = new SunJSSE_g();
            inputStream = new ByteArrayInputStream(sunJSSE_g.a(byArray));
            if (this.tag != inputStream.read()) {
                throw new IOException("Indefinite length encoding not supported");
            }
            this.a = DerInputStream.a(inputStream);
        }
        if (this.a == 0) {
            return;
        }
        if (bl && inputStream.available() != this.a) {
            throw new IOException("extra data given to DerValue constructor");
        }
        byte[] byArray = new byte[this.a];
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.readFully(byArray);
        this.buffer = new DerInputBuffer(byArray);
        this.data = new DerInputStream(this.buffer);
    }

    boolean a() {
        return (this.tag & 0xC0) == 64;
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) == 32;
    }

    public boolean isConstructed(byte by) {
        if (!this.isConstructed()) {
            return false;
        }
        return (this.tag & 0x1F) == by;
    }

    public boolean isContextSpecific() {
        return (this.tag & 0xC0) == 128;
    }

    public boolean isContextSpecific(byte by) {
        if (!this.isContextSpecific()) {
            return false;
        }
        return (this.tag & 0x1F) == by;
    }

    boolean b() {
        return (this.tag & 0xC0) == 192;
    }

    boolean c() {
        return (this.tag & 0xC0) == 0;
    }

    public int length() {
        return this.a;
    }

    public void resetTag(byte by) {
        this.tag = by;
    }

    private String d() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(this.a);
        try {
            int n = this.a;
            this.data.reset();
            while (n-- > 0) {
                stringBuffer.append((char)this.data.a());
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return new String(stringBuffer);
    }

    public byte[] toByteArray() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.encode(derOutputStream);
        this.data.reset();
        return derOutputStream.toByteArray();
    }

    public DerInputStream toDerInputStream() throws IOException {
        if (this.tag == 48 || this.tag == 49) {
            return new DerInputStream(this.buffer);
        }
        throw new IOException("toDerInputStream rejects tag type " + this.tag);
    }

    public String toString() {
        try {
            if (this.tag == 19) {
                return "\"" + this.getPrintableString() + "\"";
            }
            if (this.tag == 5) {
                return "[DerValue, null]";
            }
            if (this.tag == 6) {
                return "OID." + this.getOID();
            }
            return "[DerValue, tag = " + this.tag + ", length = " + this.a + "]";
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("misformatted DER value");
        }
    }
}

