/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.X509KeyManager;
import com.sun.net.ssl.X509TrustManager;
import com.sun.net.ssl.internal.ssl.CipherSpec;
import com.sun.net.ssl.internal.ssl.ClientDiffieHellmanPublic;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.Handshaker;
import com.sun.net.ssl.internal.ssl.JsseX509TrustManager;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import com.sun.net.ssl.internal.ssl.SunJSSE_am;
import com.sun.net.ssl.internal.ssl.SunJSSE_h;
import com.sun.net.ssl.internal.ssl.SunJSSE_i;
import com.sun.net.ssl.internal.ssl.SunJSSE_j;
import com.sun.net.ssl.internal.ssl.SunJSSE_l;
import com.sun.net.ssl.internal.ssl.SunJSSE_n;
import com.sun.net.ssl.internal.ssl.SunJSSE_o;
import com.sun.net.ssl.internal.ssl.SunJSSE_p;
import com.sun.net.ssl.internal.ssl.SunJSSE_s;
import com.sun.net.ssl.internal.ssl.SunJSSE_u;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;

final class ServerHandshaker
extends Handshaker {
    private boolean a;
    private boolean b = false;
    private X509Certificate[] c;
    private PrivateKey d;
    private boolean e = false;
    private PrivateKey f;
    private RSAPublicKey g;
    private byte h;
    private byte i;
    private SunJSSE_u j;

    ServerHandshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl, boolean bl) throws NoSuchAlgorithmException {
        super(sSLSocketImpl, sSLContextImpl, bl);
        this.a = bl;
    }

    boolean a(int n, boolean bl) {
        if (this.k) {
            return true;
        }
        X509KeyManager x509KeyManager = ((Handshaker)this).g.g();
        if (n == 1 || n == 2 || n == 5) {
            String string = x509KeyManager.chooseServerAlias("RSA", null);
            if (string == null) {
                return false;
            }
            this.d = x509KeyManager.getPrivateKey(string);
            if (this.d == null) {
                return false;
            }
            this.c = x509KeyManager.getCertificateChain(string);
            RSAPublicKey rSAPublicKey = (RSAPublicKey)this.c[0].getPublicKey();
            if (n == 2 && rSAPublicKey.getModulus().bitLength() > 512 && !this.b(bl)) {
                return false;
            }
            if (n == 5) {
                this.a(bl);
            }
            return this.d != null && this.d instanceof RSAPrivateKey;
        }
        if (n == 6) {
            String string = x509KeyManager.chooseServerAlias("DSA", null);
            if (string == null) {
                return false;
            }
            this.d = x509KeyManager.getPrivateKey(string);
            if (this.d == null) {
                return false;
            }
            this.c = x509KeyManager.getCertificateChain(string);
            this.a(bl);
            return this.d != null;
        }
        if (n == 7) {
            this.a(bl);
            return true;
        }
        return false;
    }

    protected boolean canUseCipherSuite(String string) {
        if (string.startsWith("SSL_RSA_")) {
            return this.a(1, false);
        }
        if (string.startsWith("SSL_DH_anon_")) {
            return this.a(7, false);
        }
        if (string.startsWith("SSL_DHE_DSS_")) {
            return this.a(6, false);
        }
        return false;
    }

    private boolean a(SunJSSE_i sunJSSE_i, byte[] byArray) {
        boolean bl = false;
        int n = 0;
        while (n < sunJSSE_i.e.length) {
            if (byArray[0] == sunJSSE_i.e[n] && byArray[1] == sunJSSE_i.e[n + 1]) break;
            n += 2;
        }
        if (n < sunJSSE_i.e.length) {
            bl = this.c(byArray[0], byArray[1]);
        }
        return bl;
    }

    private void a(SunJSSE_i sunJSSE_i) throws IOException {
        int n = 0;
        while (n < sunJSSE_i.e.length) {
            if (this.c(sunJSSE_i.e[n], sunJSSE_i.e[n + 1]) && (!this.a || this.o != 7)) break;
            n += 2;
        }
        if (n >= sunJSSE_i.e.length) {
            ((Handshaker)this).a.a((byte)40, "no cipher suites in common");
        }
    }

    private void a(HandshakeMessage.CertificateMsg certificateMsg) throws IOException {
        boolean bl;
        X509TrustManager x509TrustManager;
        X509Certificate[] x509CertificateArray;
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            certificateMsg.a(System.out);
        }
        if ((x509CertificateArray = certificateMsg.getCertificateChain()).length == 0) {
            ((Handshaker)this).a.a((byte)42, "null cert chain");
        }
        if ((x509TrustManager = ((Handshaker)this).g.h()) instanceof JsseX509TrustManager) {
            String string = null;
            PublicKey publicKey = x509CertificateArray[0].getPublicKey();
            string = publicKey instanceof RSAPublicKey ? "RSA" : (publicKey instanceof DSAPublicKey ? "DSA" : "UNKNOWN");
            bl = ((JsseX509TrustManager)x509TrustManager).a(x509CertificateArray, string);
        } else {
            bl = x509TrustManager.isClientTrusted(x509CertificateArray);
        }
        if (bl) {
            this.e = true;
            ((Handshaker)this).j.a(x509CertificateArray);
        } else {
            ((Handshaker)this).a.a((byte)46, "untrusted client cert chain");
        }
    }

    private void a(SunJSSE_p sunJSSE_p) throws IOException {
        boolean bl = false;
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            sunJSSE_p.a(System.out);
        }
        try {
            PublicKey publicKey = ((Handshaker)this).j.getPeerCertificateChain()[0].getPublicKey();
            try {
                bl = sunJSSE_p.a(((CipherSpec)this).b, publicKey, (MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), ((Handshaker)this).j.c());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                bl = sunJSSE_p.a(((CipherSpec)this).b, publicKey, ((Handshaker)this).b[2], ((Handshaker)this).c[2], ((Handshaker)this).j.c());
                ((Handshaker)this).b[2] = null;
                ((Handshaker)this).c[2] = null;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            ((Handshaker)this).a.a((byte)43, "client cert type is unsupported");
        }
        catch (SignatureException signatureException) {
        }
        catch (InvalidKeyException invalidKeyException) {}
        if (!bl) {
            ((Handshaker)this).a.a((byte)42, "client cert didn't verify");
        }
        this.e = false;
    }

    private void a(HandshakeMessage.Finished finished) throws IOException {
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            finished.a(System.out);
        }
        if (this.a) {
            ((Handshaker)this).j.getPeerCertificateChain();
        }
        if (this.e) {
            ((Handshaker)this).a.a((byte)40, "client did not send certificate verify message");
        }
        boolean bl = false;
        try {
            bl = ((CipherSpec)this).b == 0 ? finished.verify((MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), HandshakeMessage.Finished.c, ((Handshaker)this).j.c()) : finished.verify((MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), "client finished", ((Handshaker)this).j.c());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            bl = ((CipherSpec)this).b == 0 ? finished.verify(((Handshaker)this).b[1], ((Handshaker)this).c[1], HandshakeMessage.Finished.c, ((Handshaker)this).j.c()) : finished.verify(((Handshaker)this).b[1], ((Handshaker)this).c[1], "client finished", ((Handshaker)this).j.c());
            ((Handshaker)this).b[1] = null;
            ((Handshaker)this).c[1] = null;
        }
        if (!bl) {
            ((Handshaker)this).a.a((byte)40, "client 'finished' message doesn't verify");
        }
        if (!this.k) {
            ((Handshaker)this).d.digestNow();
            this.c(false);
        }
        if (!this.k && ((Handshaker)this).j.e()) {
            ((Handshaker)this).g.f().a(((Handshaker)this).j);
            if (Handshaker.m != null && Debug.isOn("session")) {
                System.out.println("%% Cached server session: " + ((Handshaker)this).j);
            }
        } else if (!this.k && Handshaker.m != null && Debug.isOn("session")) {
            System.out.println("%% Didn't cache non-resumable server session: " + ((Handshaker)this).j);
        }
    }

    private void b(SunJSSE_i sunJSSE_i) throws IOException {
        Object object;
        Object object2;
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            sunJSSE_i.a(System.out);
        }
        ((Handshaker)this).d.digestNow();
        SunJSSE_j sunJSSE_j = new SunJSSE_j();
        this.h = sunJSSE_j.a;
        this.i = sunJSSE_j.b;
        if (sunJSSE_i.a != 3) {
            throw new SSLProtocolException("version mismatch, client is v" + sunJSSE_i.a + "." + sunJSSE_i.b);
        }
        sunJSSE_j.a = (byte)3;
        ((CipherSpec)this).a = sunJSSE_i.a;
        sunJSSE_j.b = sunJSSE_i.b > 1 ? (byte)1 : sunJSSE_i.b;
        ((CipherSpec)this).b = sunJSSE_j.b;
        ((Handshaker)this).a.a(((CipherSpec)this).a, ((CipherSpec)this).b);
        ((Handshaker)this).e.r.a(((CipherSpec)this).a, ((CipherSpec)this).b);
        ((Handshaker)this).h = sunJSSE_i.c;
        sunJSSE_j.c = ((Handshaker)this).i = new SunJSSE_s(((Handshaker)this).g.e());
        if (sunJSSE_i.d.b() != 0) {
            if (((Handshaker)this).j != null && !this.b && !sunJSSE_i.d.equals(((Handshaker)this).j.d())) {
                throw new SSLException("Client cannot change existing session");
            }
            ((Handshaker)this).j = null;
            object2 = ((Handshaker)this).g.f().a(sunJSSE_i.d.a());
            if (object2 != null) {
                object = ((SSLSessionImpl)object2).a().getCipherSuite();
                this.k = ((SSLSessionImpl)object2).e();
                if (this.k) {
                    this.k = this.a(sunJSSE_i, (byte[])object);
                }
                if (this.k && this.a) {
                    try {
                        ((SSLSessionImpl)object2).getPeerCertificateChain();
                    }
                    catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                        this.k = false;
                    }
                }
                if (this.k) {
                    ((Handshaker)this).j = object2;
                    if (Handshaker.m != null && (Debug.isOn("handshake") || Debug.isOn("session"))) {
                        System.out.println("%% Resuming " + ((Handshaker)this).j);
                    }
                }
            }
        } else {
            if (((Handshaker)this).j != null && !this.b) {
                throw new SSLException("Client cannot change existing session");
            }
            ((Handshaker)this).j = null;
        }
        if (((Handshaker)this).j == null) {
            if (!this.l) {
                throw new SSLException("Client did not resume a session");
            }
            ((Handshaker)this).j = new SSLSessionImpl((CipherSpec)this, ((Handshaker)this).g.e(), ((Handshaker)this).a.getInetAddress().getHostAddress(), ((Handshaker)this).a.getPort());
            this.a(sunJSSE_i);
        }
        sunJSSE_j.e = ((Handshaker)this).j.a().getCipherSuite();
        sunJSSE_j.d = ((Handshaker)this).j.d();
        sunJSSE_j.f = ((Handshaker)this).j.b();
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            sunJSSE_j.a(System.out);
            System.out.println("Cipher suite:  " + ((Handshaker)this).j.a());
        }
        sunJSSE_j.write(((Handshaker)this).e);
        if (this.k) {
            try {
                this.a(((Handshaker)this).j.c());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SSLException("Missing algorithm: " + noSuchAlgorithmException.getMessage());
            }
            this.c(true);
            return;
        }
        if (this.o != 7) {
            if (this.c == null) {
                throw new SSLException("internal error, no certs!");
            }
            object2 = new HandshakeMessage.CertificateMsg(this.c);
            if (Handshaker.m != null && Debug.isOn("handshake")) {
                ((HandshakeMessage.CertificateMsg)object2).a(System.out);
            }
            ((HandshakeMessage)object2).write(((Handshaker)this).e);
        }
        boolean bl = false;
        if (this.c == null) {
            bl = true;
        } else {
            switch (this.o) {
                case 1: 
                case 2: {
                    if (this.o != 2 || ((RSAPrivateKey)this.d).getModulus().bitLength() <= 512) break;
                    bl = true;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    bl = true;
                    break;
                }
                default: {
                    throw new SSLException("unsupported server key exchange " + this.o);
                }
                case 3: 
                case 4: 
            }
        }
        if (bl) {
            switch (this.o) {
                case 1: 
                case 2: {
                    try {
                        if (this.c == null) {
                            throw new SSLException("Anonymous RSA not supported");
                        }
                        object = new SunJSSE_l(this.g, this.d, ((Handshaker)this).h, ((Handshaker)this).i, ((Handshaker)this).g.e());
                        this.d = this.f;
                        break;
                    }
                    catch (SignatureException signatureException) {
                        throw new SSLException("Internal error, " + signatureException);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new SSLException("Algorithm missing, " + noSuchAlgorithmException);
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        throw new SSLException("Bad RSA key, " + invalidKeyException);
                    }
                }
                case 7: {
                    object = new HandshakeMessage.DH_ServerKeyExchange(this.j);
                    break;
                }
                case 5: 
                case 6: {
                    try {
                        object = new HandshakeMessage.DH_ServerKeyExchange(this.j, this.d, ((Handshaker)this).h.a, ((Handshaker)this).i.a, ((Handshaker)this).g.e());
                        break;
                    }
                    catch (SignatureException signatureException) {
                        throw new SSLException("Internal error, " + signatureException);
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        throw new SSLException("Bad RSA or DSS key, " + invalidKeyException);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new SSLException("Algorithm missing, " + noSuchAlgorithmException);
                    }
                }
                default: {
                    throw new SSLException("unsupported server key exchange " + this.o);
                }
            }
            if (Handshaker.m != null && Debug.isOn("handshake")) {
                ((HandshakeMessage)object).a(System.out);
            }
            ((HandshakeMessage)object).write(((Handshaker)this).e);
        }
        if (this.a) {
            X509Certificate[] x509CertificateArray = ((Handshaker)this).g.h().getAcceptedIssuers();
            object = new SunJSSE_n(x509CertificateArray, this.o);
            if (Handshaker.m != null && Debug.isOn("handshake")) {
                ((SunJSSE_n)object).a(System.out);
            }
            ((HandshakeMessage)object).write(((Handshaker)this).e);
        }
        object = new SunJSSE_o();
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            ((SunJSSE_o)object).a(System.out);
        }
        ((HandshakeMessage)object).write(((Handshaker)this).e);
        ((Handshaker)this).e.flush();
    }

    private byte[] a(ClientDiffieHellmanPublic clientDiffieHellmanPublic) throws IOException, NoSuchAlgorithmException {
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            clientDiffieHellmanPublic.a(System.out);
        }
        return this.j.a(clientDiffieHellmanPublic.getClientPublicKey());
    }

    private byte[] a(SunJSSE_am sunJSSE_am) throws IOException, NoSuchAlgorithmException {
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            sunJSSE_am.a(System.out);
        }
        return sunJSSE_am.e;
    }

    private void a(boolean bl) {
        if (!bl) {
            this.j = new SunJSSE_u();
            this.j.a(((Handshaker)this).g.e(), 768);
        } else {
            this.j = new SunJSSE_u(SunJSSE_u.i, SunJSSE_u.j);
            this.j.a(((Handshaker)this).g.e(), 512);
        }
    }

    private boolean b(boolean bl) {
        Object var2_2 = null;
        try {
            int n = !bl ? 1024 : 512;
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(n, ((Handshaker)this).g.e());
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            this.g = (RSAPublicKey)keyPair.getPublic();
            this.f = keyPair.getPrivate();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected HandshakeMessage getKickstartMessage() {
        return new SunJSSE_h();
    }

    void a(byte by) throws SSLProtocolException {
        String string = SSLSocketImpl.a(by);
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            System.out.println("SSL -- handshake alert:  " + string);
        }
        throw new SSLProtocolException("handshake alert:  " + string);
    }

    protected void processMessage(byte by, int n) throws IOException, NoSuchAlgorithmException {
        if (((Handshaker)this).f > by && ((Handshaker)this).f != 16 && by != 15) {
            throw new SSLProtocolException("Handshake message sequence violation, state = " + ((Handshaker)this).f + ", type = " + by);
        }
        switch (by) {
            case 1: {
                ((Handshaker)this).d.mark(n);
                SunJSSE_i sunJSSE_i = new SunJSSE_i(((Handshaker)this).d);
                ((Handshaker)this).d.reset();
                ((Handshaker)this).d.skip(n);
                this.b(sunJSSE_i);
                break;
            }
            case 11: {
                if (!this.a) {
                    ((Handshaker)this).a.a((byte)10, "client sent unsolicited cert chain");
                }
                this.a(new HandshakeMessage.CertificateMsg(((Handshaker)this).d));
                break;
            }
            case 16: {
                byte[] byArray;
                switch (this.o) {
                    case 1: 
                    case 2: {
                        byArray = this.a(new SunJSSE_am(((CipherSpec)this).a, ((CipherSpec)this).b, this.h, this.i, ((Handshaker)this).g.e(), ((Handshaker)this).d, n, this.d));
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        byArray = this.a(new ClientDiffieHellmanPublic(((Handshaker)this).d));
                        break;
                    }
                    default: {
                        throw new SSLProtocolException("unsupported key exchange algorithm = " + this.o);
                    }
                }
                this.b(byArray);
                int n2 = 0;
                while (n2 < byArray.length) {
                    byArray[n2] = 0;
                    ++n2;
                }
                break;
            }
            case 15: {
                this.a(new SunJSSE_p(((Handshaker)this).d));
                break;
            }
            case 20: {
                this.a(new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).d));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal server handshake msg, " + by);
            }
        }
        if (((Handshaker)this).f < by && by != 15) {
            ((Handshaker)this).f = by;
        }
    }

    private void c(boolean bl) throws IOException {
        HandshakeMessage.Finished finished;
        block3: {
            ((Handshaker)this).e.flush();
            try {
                finished = ((CipherSpec)this).b == 0 ? new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, (MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), HandshakeMessage.Finished.d, ((Handshaker)this).j.c()) : new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, (MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), "server finished", ((Handshaker)this).j.c());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                finished = ((CipherSpec)this).b == 0 ? new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).b[0], ((Handshaker)this).c[0], HandshakeMessage.Finished.d, ((Handshaker)this).j.c()) : new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).b[0], ((Handshaker)this).c[0], "server finished", ((Handshaker)this).j.c());
                if (bl && this.k) break block3;
                ((Handshaker)this).b[0] = null;
                ((Handshaker)this).c[0] = null;
            }
        }
        this.sendChangeCipherSpec(finished);
        if (!bl || !this.k) {
            ((Handshaker)this).f = 20;
        }
    }
}

