/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.log4j;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.HandlerFactory;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.LevelFactory;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.api.TopicalLogger;
import org.objectweb.util.monolog.wrapper.common.Configurable;
import org.objectweb.util.monolog.wrapper.log4j.ConsoleHandler;
import org.objectweb.util.monolog.wrapper.log4j.FileHandler;
import org.objectweb.util.monolog.wrapper.log4j.GenericHandler;
import org.objectweb.util.monolog.wrapper.log4j.LevelImpl;
import org.objectweb.util.monolog.wrapper.log4j.MonologCategory;
import org.objectweb.util.monolog.wrapper.log4j.MonologCategoryFactory;
import org.objectweb.util.monolog.wrapper.log4j.RollingFileHandler;

public class MonologLoggerFactory
implements Configurable,
LoggerFactory,
HandlerFactory,
LevelFactory {
    public static final String LOG4J_CF_PROP = "log4j.categoryFactory";
    public static final String LOG4J_CF_VALUE = "org.objectweb.util.monolog.wrapper.log4j.MonologCategoryFactory";
    protected String resourceBundleName = null;
    protected HashMap nameToLevel = null;
    protected HashMap intToNames = new HashMap();
    protected HashMap handlers = null;
    protected Logger rootLogger = null;
    private static org.apache.log4j.spi.LoggerFactory factory;
    private static Boolean debug;

    static {
        BasicLevel.INHERIT = -1;
        BasicLevel.DEBUG = org.apache.log4j.Level.DEBUG.toInt();
        BasicLevel.INFO = org.apache.log4j.Level.INFO.toInt();
        BasicLevel.WARN = org.apache.log4j.Level.WARN.toInt();
        BasicLevel.ERROR = org.apache.log4j.Level.ERROR.toInt();
        BasicLevel.FATAL = org.apache.log4j.Level.FATAL.toInt();
        BasicLevel.LEVEL_INHERIT = new LevelImpl("INHERIT", BasicLevel.INHERIT);
        BasicLevel.LEVEL_DEBUG = new LevelImpl("DEBUG", BasicLevel.DEBUG);
        BasicLevel.LEVEL_INFO = new LevelImpl("INFO", BasicLevel.INFO);
        BasicLevel.LEVEL_WARN = new LevelImpl("WARN", BasicLevel.WARN);
        BasicLevel.LEVEL_ERROR = new LevelImpl("ERROR", BasicLevel.ERROR);
        BasicLevel.LEVEL_FATAL = new LevelImpl("FATAL", BasicLevel.FATAL);
        if (!Category.getRoot().getAllAppenders().hasMoreElements()) {
            BasicConfigurator.configure();
        }
        factory = new MonologCategoryFactory();
        debug = null;
    }

    public MonologLoggerFactory() {
        this.nameToLevel = new HashMap();
        this.handlers = new HashMap();
        this.defineDefaultLevels();
        this.rootLogger = new MonologCategory(org.apache.log4j.Logger.getRootLogger());
    }

    public void configure(Properties properties) throws Exception {
        MonologLoggerFactory.debug("MonologLoggerFactory.configure(prop=" + properties + ")");
        if (properties == null) {
            if (!org.apache.log4j.Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
                BasicConfigurator.configure();
            }
            return;
        }
        String string = properties.getProperty("log.config.type", properties.getProperty("log4jConfiguration", "default"));
        MonologLoggerFactory.debug("MonologLoggerFactory.configure(): conf=" + string);
        if ("default".equals(string)) {
            if (!org.apache.log4j.Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
                BasicConfigurator.configure();
            }
            return;
        }
        String string2 = properties.getProperty("log.config.file", properties.getProperty("log4jConfigurationFile", ""));
        MonologLoggerFactory.debug("MonologLoggerFactory.configure(): filename=" + string2);
        if ("xml".equals(string)) {
            DOMConfigurator.configure((String)string2);
        } else if ("property".equals(string)) {
            Properties properties2 = null;
            if (properties.getProperty("log.config.file.useclasspath", "false").equalsIgnoreCase("true") || properties.getProperty("findFileInClassPath", "false").equalsIgnoreCase("true")) {
                MonologLoggerFactory.debug("MonologLoggerFactory.configure(): load from classpath");
                if (!"log4j.properties".equals(string2)) {
                    MonologLoggerFactory.debug("MonologLoggerFactory.configure(): not default config file");
                    properties2 = this.getProperties(string2);
                    properties2.setProperty(LOG4J_CF_PROP, LOG4J_CF_VALUE);
                    PropertyConfigurator.configure((Properties)properties2);
                }
            } else {
                MonologLoggerFactory.debug("MonologLoggerFactory.configure(): load from file system");
                properties2 = new Properties();
                properties2.load(new FileInputStream(string2));
                properties2.setProperty(LOG4J_CF_PROP, LOG4J_CF_VALUE);
                PropertyConfigurator.configure((Properties)properties2);
            }
        } else {
            throw new Exception("Unsupported configuration type: " + string);
        }
        MonologLoggerFactory.debug("MonologLoggerFactory.configure(): End");
    }

    public Handler createHandler(String string, byte by) {
        Handler handler = (Handler)this.handlers.get(string);
        if (handler != null) {
            return null;
        }
        switch (by) {
            case 2: {
                handler = new ConsoleHandler(string);
                break;
            }
            case 1: {
                handler = new FileHandler(string);
                break;
            }
            case 3: {
                handler = new RollingFileHandler(string);
                break;
            }
            case 4: {
                handler = new GenericHandler(string);
                break;
            }
            default: {
                return null;
            }
        }
        this.handlers.put(string, handler);
        return handler;
    }

    private static void debug(String string) {
        if (debug == null) {
            String string2 = System.getProperty("monolog.debug", "");
            debug = new Boolean(string2 != null && string2.equalsIgnoreCase("true"));
        }
        if (debug.booleanValue()) {
            System.out.println(string);
        }
    }

    protected void defineDefaultLevels() {
        this.defineLevel("INHERIT", -1);
        this.defineLevel("DEBUG", 10000);
        this.defineLevel("INFO", 20000);
        this.defineLevel("WARN", 30000);
        this.defineLevel("ERROR", 40000);
        this.defineLevel("FATAL", 50000);
    }

    public Level defineLevel(String string, int n) {
        return this.defineLevel(new LevelImpl(string, n));
    }

    public Level defineLevel(String string, String string2) {
        return this.defineLevel(new LevelImpl(string, string2, this));
    }

    private Level defineLevel(Level level) {
        String string = level.getName();
        int n = level.getIntValue();
        Level level2 = (Level)this.nameToLevel.get(string);
        if (level2 != null) {
            return level2.getIntValue() == n ? level2 : null;
        }
        level2 = level;
        this.nameToLevel.put(string, level2);
        Integer n2 = new Integer(n);
        Object v = this.intToNames.get(n2);
        if (v != null) {
            ArrayList arrayList;
            if (v instanceof String) {
                if (!((String)v).equalsIgnoreCase(string)) {
                    ArrayList<Object> arrayList2 = new ArrayList<Object>(5);
                    arrayList2.add(v);
                    arrayList2.add(string);
                    this.intToNames.put(n2, arrayList2);
                }
            } else if (v instanceof ArrayList && !(arrayList = (ArrayList)v).contains(string)) {
                arrayList.add(string);
            }
        } else {
            this.intToNames.put(n2, string);
        }
        return level2;
    }

    public Handler getHandler(String string) {
        return (Handler)this.handlers.get(string);
    }

    public Handler[] getHandlers() {
        return this.handlers.values().toArray(new Handler[0]);
    }

    public Level getLevel(int n) {
        Object v = this.intToNames.get(new Integer(n));
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return this.getLevel((String)v);
        }
        if (v instanceof ArrayList) {
            return this.getLevel((String)((ArrayList)v).get(0));
        }
        return null;
    }

    public Level getLevel(String string) {
        return (Level)this.nameToLevel.get(string);
    }

    public Level[] getLevels() {
        return this.nameToLevel.values().toArray(new Level[0]);
    }

    public Logger getLogger(String string) {
        if (string == null || string.length() == 0 || string.equalsIgnoreCase("root")) {
            return this.rootLogger;
        }
        if (this.resourceBundleName == null) {
            return (Logger)org.apache.log4j.Logger.getLogger((String)string, (org.apache.log4j.spi.LoggerFactory)factory);
        }
        return this.getLogger(string, this.resourceBundleName);
    }

    public synchronized Logger getLogger(String string, String string2) {
        if (string == null || string.length() == 0 || string.equalsIgnoreCase("root")) {
            return this.rootLogger;
        }
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)string, (org.apache.log4j.spi.LoggerFactory)factory);
        logger.setResourceBundle(ResourceBundle.getBundle(string2));
        return (Logger)logger;
    }

    public Logger[] getLoggers() {
        HashSet hashSet = new HashSet();
        Enumeration enumeration = LogManager.getCurrentLoggers();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Logger)) continue;
            hashSet.add(e);
        }
        hashSet.add(this.rootLogger);
        return ((AbstractCollection)hashSet).toArray(new TopicalLogger[0]);
    }

    private Properties getProperties(String string) throws IOException {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream != null) {
            Properties properties = new Properties();
            properties.load(inputStream);
            return properties;
        }
        throw new FileNotFoundException("Not found in classpath: " + string);
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public Handler removeHandler(String string) {
        return (Handler)this.handlers.remove(string);
    }

    public void removeLevel(String string) {
        Level level = (Level)this.nameToLevel.remove(string);
        if (level != null) {
            Integer n = new Integer(level.getIntValue());
            Object v = this.intToNames.get(n);
            if (v instanceof String) {
                this.intToNames.remove(n);
            } else if (v instanceof ArrayList) {
                ((AbstractCollection)((ArrayList)v)).remove(string);
            }
        }
    }

    public void setResourceBundleName(String string) {
        this.resourceBundleName = string;
    }
}

