/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;

public class Option {
    private Character _opt = null;
    private String _longOpt = null;
    private boolean _hasArg = false;
    private String _description = null;
    private boolean _required = false;
    private boolean _multipleArgs = false;
    private ArrayList _values = new ArrayList();

    public Option(char opt, boolean hasArg, String description) {
        this(opt, null, hasArg, description, false, false);
    }

    public Option(char opt, String longOpt, boolean hasArg, String description) {
        this(opt, longOpt, hasArg, description, false, false);
    }

    public Option(char opt, String longOpt, boolean hasArg, String description, boolean required) {
        this(opt, longOpt, hasArg, description, required, false);
    }

    public Option(char opt, String longOpt, boolean hasArg, String description, boolean required, boolean multipleArgs) {
        this._opt = new Character(opt);
        this._longOpt = longOpt;
        this._hasArg = hasArg;
        this._description = description;
        this._required = required;
        this._multipleArgs = multipleArgs;
    }

    public char getOpt() {
        return this._opt.charValue();
    }

    public String getLongOpt() {
        return this._longOpt;
    }

    public boolean hasLongOpt() {
        return this._longOpt != null;
    }

    public boolean hasArg() {
        return this._hasArg;
    }

    public String getDescription() {
        return this._description;
    }

    public boolean isRequired() {
        return this._required;
    }

    public boolean hasMultipleArgs() {
        return this._multipleArgs;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer().append("[ option: ");
        buf.append(this._opt);
        if (this._longOpt != null) {
            buf.append(" ").append(this._longOpt);
        }
        buf.append(" ");
        if (this._hasArg) {
            buf.append("+ARG");
        }
        buf.append(" :: ").append(this._description).append(" ]");
        return buf.toString();
    }

    public void addValue(String value) {
        this._values.add(value);
    }

    public String getValue() {
        return this._values.size() == 0 ? null : (String)this._values.get(0);
    }

    public String[] getValues() {
        return this._values.size() == 0 ? null : this._values.toArray(new String[0]);
    }
}

