/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.soap;

import java.io.IOException;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.security.auth.Subject;
import mx4j.remote.NotificationTuple;
import mx4j.remote.RemoteNotificationClientHandler;
import mx4j.tools.remote.soap.SOAPConnection;

class ClientInvoker
implements MBeanServerConnection {
    private final SOAPConnection connection;
    private final Subject delegate;
    private RemoteNotificationClientHandler notificationHandler;

    ClientInvoker(SOAPConnection soapConnection, RemoteNotificationClientHandler notificationHandler, Subject delegate) {
        this.connection = soapConnection;
        this.delegate = delegate;
        this.notificationHandler = notificationHandler;
    }

    public void addNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        NotificationTuple tuple = new NotificationTuple(observed, listener, filter, handback);
        tuple.setInvokeFilter(true);
        if (this.notificationHandler.contains(tuple)) {
            return;
        }
        Integer[] ids = this.connection.addNotificationListeners(new ObjectName[]{observed}, new Subject[]{this.delegate});
        this.notificationHandler.addNotificationListener(ids[0], tuple);
    }

    public void removeNotificationListener(ObjectName observed, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        Integer[] ids = this.notificationHandler.getNotificationListeners(new NotificationTuple(observed, listener));
        if (ids == null) {
            throw new ListenerNotFoundException("Could not find listener " + listener);
        }
        this.connection.removeNotificationListeners(observed, ids, this.delegate);
        this.notificationHandler.removeNotificationListeners(ids);
    }

    public void removeNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        Integer id = this.notificationHandler.getNotificationListener(new NotificationTuple(observed, listener, filter, handback));
        if (id == null) {
            throw new ListenerNotFoundException("Could not find listener " + listener + " with filter " + filter + " and handback " + handback);
        }
        Integer[] ids = new Integer[]{id};
        this.connection.removeNotificationListeners(observed, ids, this.delegate);
        this.notificationHandler.removeNotificationListeners(ids);
    }

    public void addNotificationListener(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        this.connection.addNotificationListener(observed, listener, filter, handback, this.delegate);
    }

    public void removeNotificationListener(ObjectName observed, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.connection.removeNotificationListener(observed, listener, this.delegate);
    }

    public void removeNotificationListener(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.connection.removeNotificationListener(observed, listener, filter, handback, this.delegate);
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        return this.connection.getMBeanInfo(objectName, this.delegate);
    }

    public boolean isInstanceOf(ObjectName objectName, String className) throws InstanceNotFoundException, IOException {
        return this.connection.isInstanceOf(objectName, className, this.delegate);
    }

    public String[] getDomains() throws IOException {
        return this.connection.getDomains(this.delegate);
    }

    public String getDefaultDomain() throws IOException {
        return this.connection.getDefaultDomain(this.delegate);
    }

    public ObjectInstance createMBean(String className, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        return this.connection.createMBean(className, objectName, null, null, this.delegate);
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        return this.connection.createMBean(className, objectName, args, parameters, this.delegate);
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        return this.connection.createMBean(className, objectName, loaderName, null, null, this.delegate);
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        return this.connection.createMBean(className, objectName, loaderName, args, parameters, this.delegate);
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        this.connection.unregisterMBean(objectName, this.delegate);
    }

    public Object getAttribute(ObjectName objectName, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        return this.connection.getAttribute(objectName, attribute, this.delegate);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        this.connection.setAttribute(objectName, attribute, this.delegate);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        return this.connection.getAttributes(objectName, attributes, this.delegate);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        return this.connection.setAttributes(objectName, attributes, this.delegate);
    }

    public Object invoke(ObjectName objectName, String methodName, Object[] args, String[] parameters) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.connection.invoke(objectName, methodName, args, parameters, this.delegate);
    }

    public Integer getMBeanCount() throws IOException {
        return this.connection.getMBeanCount(this.delegate);
    }

    public boolean isRegistered(ObjectName objectName) throws IOException {
        return this.connection.isRegistered(objectName, this.delegate);
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException, IOException {
        return this.connection.getObjectInstance(objectName, this.delegate);
    }

    public Set queryMBeans(ObjectName patternName, QueryExp filter) throws IOException {
        return this.connection.queryMBeans(patternName, filter, this.delegate);
    }

    public Set queryNames(ObjectName patternName, QueryExp filter) throws IOException {
        return this.connection.queryNames(patternName, filter, this.delegate);
    }
}

