/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.soap;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import mx4j.remote.ConnectionResolver;
import mx4j.remote.HeartBeat;
import mx4j.remote.RemoteNotificationClientHandler;
import mx4j.tools.remote.AbstractJMXConnector;
import mx4j.tools.remote.soap.ClientExceptionCatcher;
import mx4j.tools.remote.soap.ClientInvoker;
import mx4j.tools.remote.soap.ClientSOAPConnection;
import mx4j.tools.remote.soap.SOAPConnection;
import mx4j.tools.remote.soap.SOAPHeartBeat;
import mx4j.tools.remote.soap.SOAPRemoteNotificationClientHandler;

public class SOAPConnector
extends AbstractJMXConnector {
    public static final String SOAP_TRANSPORT_PROTOCOL = "jmx.remote.x.soap.transport.protocol";
    private transient ClientSOAPConnection connection;
    private transient RemoteNotificationClientHandler notificationHandler;
    private transient HeartBeat heartbeat;

    public SOAPConnector(JMXServiceURL url, Map environment) throws IOException {
        super(url);
    }

    protected void doConnect(Map environment) throws IOException, SecurityException {
        JMXServiceURL address = this.getAddress();
        String protocol = address.getProtocol();
        ConnectionResolver resolver = ConnectionResolver.newConnectionResolver(protocol, environment);
        if (resolver == null) {
            throw new MalformedURLException("Unsupported protocol: " + protocol);
        }
        this.connection = (ClientSOAPConnection)resolver.lookupClient(address, environment);
        this.connection = (ClientSOAPConnection)resolver.bindClient(this.connection, environment);
        Object credentials = environment == null ? null : environment.get("jmx.remote.credentials");
        this.connection.connect(credentials);
        this.heartbeat = new SOAPHeartBeat(this.connection, this.getConnectionNotificationEmitter(), environment);
        this.notificationHandler = new SOAPRemoteNotificationClientHandler(this.connection, this.getConnectionNotificationEmitter(), this.heartbeat, environment);
        this.heartbeat.start();
        this.notificationHandler.start();
    }

    protected void doClose() throws IOException {
        if (this.notificationHandler != null) {
            this.notificationHandler.stop();
        }
        if (this.heartbeat != null) {
            this.heartbeat.stop();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    protected MBeanServerConnection doGetMBeanServerConnection(Subject delegate) throws IOException {
        SOAPConnection catcher = ClientExceptionCatcher.newInstance(this.connection);
        return new ClientInvoker(catcher, this.notificationHandler, delegate);
    }

    public String getConnectionId() throws IOException {
        return this.connection.getConnectionId();
    }
}

