/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.soap;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXServiceURL;
import mx4j.remote.ConnectionResolver;
import mx4j.tools.remote.AbstractJMXConnectorServer;
import mx4j.tools.remote.soap.SOAPConnectionManager;
import mx4j.tools.remote.soap.web.WebContainer;

public class SOAPConnectorServer
extends AbstractJMXConnectorServer {
    public static final String USE_EXTERNAL_WEB_CONTAINER = "jmx.remote.x.soap.use.external.web.container";
    public static final String EMBEDDED_WEB_CONTAINER_CLASS = "jmx.remote.x.soap.embedded.web.container.class";
    public static final String AXIS_DEPLOY_URL = "jmx.remote.x.axis.deploy.url";
    public static final String DEFAULT_AXIS_DEPLOY_URL = "/axis/services/AdminService";
    private static Map instances = new HashMap();
    private MBeanServer mbeanServer;
    private WebContainer webContainer;
    private SOAPConnectionManager connectionManager;
    static /* synthetic */ Class class$mx4j$tools$remote$soap$SOAPConnectorServer;
    static /* synthetic */ Class class$mx4j$tools$remote$soap$web$jetty$JettyWebContainer;
    static /* synthetic */ Class class$mx4j$tools$remote$soap$web$axis$SimpleAxisWebContainer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SOAPConnectionManager find(JMXServiceURL address) {
        Class clazz = class$mx4j$tools$remote$soap$SOAPConnectorServer == null ? (class$mx4j$tools$remote$soap$SOAPConnectorServer = SOAPConnectorServer.class$("mx4j.tools.remote.soap.SOAPConnectorServer")) : class$mx4j$tools$remote$soap$SOAPConnectorServer;
        synchronized (clazz) {
            return (SOAPConnectionManager)instances.get(address);
        }
    }

    public SOAPConnectorServer(JMXServiceURL url, Map environment, MBeanServer server) {
        super(url, environment, server);
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    protected void doStart() throws IOException, IllegalStateException {
        boolean useExternalWebContainer;
        Map environment;
        JMXServiceURL address = this.getAddress();
        String protocol = address.getProtocol();
        ConnectionResolver resolver = ConnectionResolver.newConnectionResolver(protocol, environment = this.getEnvironment());
        if (resolver == null) {
            throw new MalformedURLException("Unsupported protocol: " + protocol);
        }
        MBeanServer realServer = null;
        MBeanServer server = super.getMBeanServer();
        MBeanServer resolvedServer = (MBeanServer)resolver.createServer(address, environment);
        if (resolvedServer == null) {
            if (server == null) {
                throw new IllegalStateException("This SOAPConnectorServer is not attached to an MBeanServer");
            }
            realServer = server;
        } else if (server == null) {
            realServer = resolvedServer;
        } else {
            if (server != resolvedServer) {
                throw new IllegalStateException("This SOAPConnectorServer cannot be attached to 2 MBeanServers");
            }
            realServer = server;
        }
        this.mbeanServer = realServer;
        boolean bl = useExternalWebContainer = environment == null ? false : Boolean.valueOf(String.valueOf(environment.get(USE_EXTERNAL_WEB_CONTAINER)));
        if (!useExternalWebContainer) {
            String webContainerClassName;
            String string = webContainerClassName = environment == null ? null : (String)environment.get(EMBEDDED_WEB_CONTAINER_CLASS);
            if (webContainerClassName == null || webContainerClassName.length() == 0) {
                webContainerClassName = (class$mx4j$tools$remote$soap$web$jetty$JettyWebContainer == null ? (class$mx4j$tools$remote$soap$web$jetty$JettyWebContainer = SOAPConnectorServer.class$("mx4j.tools.remote.soap.web.jetty.JettyWebContainer")) : class$mx4j$tools$remote$soap$web$jetty$JettyWebContainer).getName();
            }
            this.webContainer = this.createWebContainer(webContainerClassName, environment);
            if (this.webContainer == null) {
                this.webContainer = this.createWebContainer((class$mx4j$tools$remote$soap$web$axis$SimpleAxisWebContainer == null ? (class$mx4j$tools$remote$soap$web$axis$SimpleAxisWebContainer = SOAPConnectorServer.class$("mx4j.tools.remote.soap.web.axis.SimpleAxisWebContainer")) : class$mx4j$tools$remote$soap$web$axis$SimpleAxisWebContainer).getName(), environment);
            }
            if (this.webContainer == null) {
                throw new IOException("Could not start embedded web container");
            }
            try {
                this.webContainer.start(address, environment);
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Exception x) {
                throw new IOException(x.toString());
            }
        }
        this.connectionManager = new SOAPConnectionManager(this, environment);
        this.setAddress(resolver.bindServer(realServer, address, environment));
        this.register(this.getAddress(), this.connectionManager);
    }

    private WebContainer createWebContainer(String webContainerClassName, Map environment) {
        Object cl;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (environment != null && (cl = environment.get("jmx.remote.protocol.provider.class.loader")) instanceof ClassLoader) {
            loader = (ClassLoader)cl;
        }
        try {
            return (WebContainer)loader.loadClass(webContainerClassName).newInstance();
        }
        catch (Exception x) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(JMXServiceURL url, SOAPConnectionManager manager) throws IOException {
        Class clazz = class$mx4j$tools$remote$soap$SOAPConnectorServer == null ? (class$mx4j$tools$remote$soap$SOAPConnectorServer = SOAPConnectorServer.class$("mx4j.tools.remote.soap.SOAPConnectorServer")) : class$mx4j$tools$remote$soap$SOAPConnectorServer;
        synchronized (clazz) {
            if (instances.get(url) != null) {
                throw new IOException("A SOAPConnectorServer is already serving at address " + url);
            }
            instances.put(url, manager);
        }
    }

    protected void doStop() throws IOException {
        if (this.connectionManager != null) {
            this.connectionManager.close();
            this.connectionManager = null;
        }
        JMXServiceURL address = this.getAddress();
        this.unregister(address);
        String protocol = address.getProtocol();
        Map environment = this.getEnvironment();
        ConnectionResolver resolver = ConnectionResolver.newConnectionResolver(protocol, environment);
        if (resolver == null) {
            throw new MalformedURLException("Unsupported protocol: " + protocol);
        }
        resolver.unbindServer(this.getMBeanServer(), address, environment);
        try {
            if (this.webContainer != null) {
                this.webContainer.stop();
            }
            this.webContainer = null;
        }
        catch (Exception x) {
            throw new IOException(x.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(JMXServiceURL url) throws IOException {
        Class clazz = class$mx4j$tools$remote$soap$SOAPConnectorServer == null ? (class$mx4j$tools$remote$soap$SOAPConnectorServer = SOAPConnectorServer.class$("mx4j.tools.remote.soap.SOAPConnectorServer")) : class$mx4j$tools$remote$soap$SOAPConnectorServer;
        synchronized (clazz) {
            Object removed = instances.remove(url);
            if (removed == null) {
                throw new IOException("No SOAPConnectorServer is present for address " + url);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

