/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.shared.HttpSessionImpl;
import org.codehaus.wadi.shared.PassivationStrategy;
import org.codehaus.wadi.shared.StreamingStrategy;

public class FilePassivationStrategy
implements PassivationStrategy {
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected final File _dir;
    protected final File _dgcFile;
    protected FileLock _dgcLock;
    protected StreamingStrategy _streamingStrategy;

    public FilePassivationStrategy(String dir) {
        this(new File(dir));
    }

    public FilePassivationStrategy(File dir) {
        this._dir = dir;
        if (!this._dir.exists() && !this._dir.mkdirs()) {
            throw new IllegalArgumentException("could not create dir: " + this._dir);
        }
        if (!(this._dir.exists() && this._dir.isDirectory() && this._dir.canRead() && this._dir.canWrite())) {
            throw new IllegalArgumentException("bad dir (is it rw?): " + this._dir);
        }
        this._dgcFile = new File(this._dir, "housekeeper.lck");
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean passivate(HttpSessionImpl impl) {
        String id = impl.getRealId();
        File file = null;
        FileLock lock = null;
        file = new File(this._dir, String.valueOf(id) + "." + this._streamingStrategy.getSuffix());
        FileOutputStream fos = new FileOutputStream(file);
        lock = fos.getChannel().lock();
        ObjectOutput oos = this._streamingStrategy.getOutputStream(fos);
        impl.writeContent(oos);
        oos.flush();
        oos.close();
        long willTimeOutAt = impl.getLastAccessedTime() + (long)(impl.getMaxInactiveInterval() * 1000);
        file.setLastModified(willTimeOutAt);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)(String.valueOf(id) + ": emmigration (file: " + file.toString() + ")"));
        }
        Object var9_9 = null;
        try {
            if (lock == null) return true;
            lock.release();
            return true;
        }
        catch (IOException e2) {
            if (!this._log.isWarnEnabled()) return true;
            this._log.warn((Object)(String.valueOf(file.toString()) + ": problem releasing passivation resource"), (Throwable)e2);
        }
        return true;
        catch (Exception e) {
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)(String.valueOf(file.toString()) + ": problem storing passivated session"), (Throwable)e);
            }
            Object var9_10 = null;
            {
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    try {
                        if (lock == null) throw throwable;
                        lock.release();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        if (!this._log.isWarnEnabled()) throw throwable;
                        this._log.warn((Object)(String.valueOf(file.toString()) + ": problem releasing passivation resource"), (Throwable)e2);
                    }
                    throw throwable;
                }
            }
            try {
                if (lock == null) return false;
                lock.release();
                return false;
            }
            catch (IOException e2) {
                if (!this._log.isWarnEnabled()) return false;
                this._log.warn((Object)(String.valueOf(file.toString()) + ": problem releasing passivation resource"), (Throwable)e2);
            }
            return false;
        }
    }

    public boolean activate(String id, HttpSessionImpl impl) {
        block19: {
            File file = null;
            RandomAccessFile raf = null;
            try {
                block17: {
                    file = new File(this._dir, String.valueOf(id) + "." + this._streamingStrategy.getSuffix());
                    if (!file.exists()) {
                        return false;
                    }
                    FileLock lock = null;
                    try {
                        raf = new RandomAccessFile(file, "rw");
                        lock = raf.getChannel().lock();
                        FileInputStream fis = new FileInputStream(file);
                        ObjectInput ois = this._streamingStrategy.getInputStream(fis);
                        impl.readContent(ois);
                        ois.close();
                        if (this._log.isDebugEnabled()) {
                            this._log.debug((Object)(String.valueOf(impl.getRealId()) + ": immigration (file: " + file.toString() + ")"));
                        }
                        Object var8_10 = null;
                    }
                    catch (Throwable throwable) {
                        block18: {
                            Object var8_11 = null;
                            try {
                                if (lock != null) {
                                    lock.release();
                                }
                                if (raf != null) {
                                    raf.close();
                                }
                                file.delete();
                            }
                            catch (IOException e) {
                                if (!this._log.isWarnEnabled()) break block18;
                                this._log.warn((Object)(String.valueOf(file.toString()) + ": problem releasing passivation resource"), (Throwable)e);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        if (lock != null) {
                            lock.release();
                        }
                        if (raf != null) {
                            raf.close();
                        }
                        file.delete();
                    }
                    catch (IOException e) {
                        if (!this._log.isWarnEnabled()) break block17;
                        this._log.warn((Object)(String.valueOf(file.toString()) + ": problem releasing passivation resource"), (Throwable)e);
                    }
                }
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)(String.valueOf(file.toString()) + ": passivated session not found"));
                }
            }
            catch (IOException e) {
                if (this._log.isWarnEnabled()) {
                    this._log.warn((Object)(String.valueOf(file.toString()) + ": problem restoring passivated session"), (Throwable)e);
                }
            }
            catch (ClassNotFoundException e) {
                if (!this._log.isWarnEnabled()) break block19;
                this._log.warn((Object)(String.valueOf(file.toString()) + ": could not restore passivated session"), (Throwable)e);
            }
        }
        return false;
    }

    public Collection findTimedOut(long now, Collection collection) {
        int suffixLen = this._streamingStrategy.getSuffix().length() + 1;
        File[] files = this._dir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                long timeOutAt;
                File file = files[i];
                if (!file.equals(this._dgcFile) && (timeOutAt = file.lastModified()) <= now) {
                    String name = file.getName();
                    String id = name.substring(0, name.length() - suffixLen);
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)(String.valueOf(id) + " : file's lastModified indicates expiry: " + timeOutAt + "<=" + now));
                    }
                    collection.add(id);
                }
                ++i;
            }
        }
        return collection;
    }

    public boolean isElected() {
        return this._dgcLock != null;
    }

    public boolean standUp() {
        this._log.trace((Object)"standing up for election to distributed garbage collection duties");
        FileChannel channel = null;
        try {
            channel = new RandomAccessFile(this._dgcFile, "rw").getChannel();
            this._dgcLock = channel.tryLock();
        }
        catch (Exception e) {
            this._log.warn((Object)"problem acquiring distributed garbage collection lock", (Throwable)e);
        }
        if (this._dgcLock != null) {
            this._log.trace((Object)"elected to distributed garbage collection duties");
            return true;
        }
        try {
            channel.close();
        }
        catch (Exception e) {
            this._log.warn((Object)"problem tidying up file lock... ", (Throwable)e);
        }
        this._log.trace((Object)"not elected");
        return false;
    }

    public void standDown() {
        try {
            if (this._dgcLock != null) {
                this._log.trace((Object)"standing down from distributed garbage collection duties");
                this._dgcLock.release();
                this._dgcLock.channel().close();
                this._dgcLock = null;
            }
        }
        catch (Exception e) {
            this._log.warn((Object)"problem releasing distributed garbage collection lock", (Throwable)e);
        }
    }

    public StreamingStrategy getStreamingStrategy() {
        return this._streamingStrategy;
    }

    public void setStreamingStrategy(StreamingStrategy streamingStrategy) {
        this._streamingStrategy = streamingStrategy;
    }
}

